/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.role;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.web.GeoServerApplication;
import org.geotools.util.logging.Logging;

public class RoleChoice
extends DropDownChoice<String> {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");

    public RoleChoice(String id, IModel<? extends SecurityRoleServiceConfig> configModel) {
        super(id, (IModel)new RoleChoiceNameModel(configModel), (IChoiceRenderer)new RoleChoiceRenderer());
    }

    static class RoleChoiceNameModel
    implements IModel<List<String>> {
        IModel<? extends SecurityRoleServiceConfig> configModel;

        RoleChoiceNameModel(IModel<? extends SecurityRoleServiceConfig> configModel) {
            this.configModel = configModel;
        }

        public List<String> getObject() {
            SecurityRoleServiceConfig config = (SecurityRoleServiceConfig)this.configModel.getObject();
            ArrayList<String> roleNames = new ArrayList<String>();
            if (config.getId() != null) {
                try {
                    for (GeoServerRole role : GeoServerApplication.get().getSecurityManager().loadRoleService(config.getName()).getRoles()) {
                        roleNames.add(role.getAuthority());
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
            }
            return roleNames;
        }

        public void setObject(List<String> object) {
            throw new UnsupportedOperationException();
        }
    }

    static class RoleChoiceRenderer
    extends ChoiceRenderer<String> {
        RoleChoiceRenderer() {
        }

        public Object getDisplayValue(String object) {
            return object;
        }

        public String getIdValue(String object, int index) {
            return object;
        }
    }
}

