/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.role;

import java.io.IOException;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.web.role.EditRolePage;
import org.geoserver.security.web.role.NewRolePage;
import org.geoserver.security.web.role.RoleListProvider;
import org.geoserver.security.web.role.SelectionRoleRemovalLink;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.Icon;
import org.geoserver.web.wicket.SimpleAjaxLink;

public class RolePanel
extends Panel {
    protected GeoServerTablePanel<GeoServerRole> roles;
    protected GeoServerDialog dialog;
    protected SelectionRoleRemovalLink removal;
    protected Link<?> add;
    protected String roleServiceName;

    public RolePanel(String id, String serviceName) {
        super(id);
        this.roleServiceName = serviceName;
        RoleListProvider provider = new RoleListProvider(this.roleServiceName);
        Component[] componentArray = new Component[1];
        this.roles = new GeoServerTablePanel<GeoServerRole>("table", (GeoServerDataProvider)provider, true){

            protected Component getComponentForProperty(String id, IModel<GeoServerRole> itemModel, GeoServerDataProvider.Property<GeoServerRole> property) {
                if (property == RoleListProvider.ROLENAME) {
                    return RolePanel.this.editRoleLink(id, itemModel, property);
                }
                if ("parentrolename".equals(property.getName())) {
                    return RolePanel.this.editParentRoleLink(id, itemModel, property);
                }
                if (property == RoleListProvider.HASROLEPARAMS) {
                    if (((Boolean)property.getModel(itemModel).getObject()).booleanValue()) {
                        return new Icon(id, CatalogIconFactory.ENABLED_ICON);
                    }
                    return new Label(id, (Serializable)((Object)""));
                }
                throw new RuntimeException("Uknown property " + String.valueOf(property));
            }

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                RolePanel.this.removal.setEnabled(!RolePanel.this.roles.getSelection().isEmpty());
                target.add(new Component[]{RolePanel.this.removal});
            }
        };
        componentArray[0] = this.roles;
        this.add(componentArray);
        this.roles.setItemReuseStrategy((IItemReuseStrategy)new DefaultItemReuseStrategy());
        this.roles.setOutputMarkupId(true);
        Component[] componentArray2 = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray2[0] = this.dialog;
        this.add(componentArray2);
        this.headerComponents();
    }

    public RolePanel setHeaderVisible(boolean visible) {
        this.get("header").setVisible(visible);
        return this;
    }

    public RolePanel setPagersVisible(boolean top, boolean bottom) {
        this.roles.getTopPager().setVisible(top);
        this.roles.getBottomPager().setVisible(bottom);
        return this;
    }

    protected void headerComponents() {
        boolean canCreateStore = this.getService().canCreateStore();
        WebMarkupContainer h = new WebMarkupContainer("header");
        this.add(new Component[]{h});
        if (!canCreateStore) {
            h.add(new Component[]{new Label("message", (IModel)new StringResourceModel("noCreateStore", (Component)this, null)).add(new Behavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"info-link")), " ")})});
        } else {
            h.add(new Component[]{new Label("message", (IModel)new Model())});
        }
        Component[] componentArray = new Component[1];
        this.add = new Link<Object>("addNew"){

            public void onClick() {
                this.setResponsePage((IRequestablePage)new NewRolePage(RolePanel.this.roleServiceName).setReturnPage(this.getPage()));
            }
        };
        componentArray[0] = this.add;
        h.add(componentArray);
        this.add.setVisible(canCreateStore);
        Component[] componentArray2 = new Component[1];
        this.removal = new SelectionRoleRemovalLink(this.roleServiceName, "removeSelected", this.roles, this.dialog);
        componentArray2[0] = this.removal;
        h.add(componentArray2);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        this.removal.setVisible(canCreateStore);
    }

    protected GeoServerRoleService getService() {
        try {
            return GeoServerApplication.get().getSecurityManager().loadRoleService(this.roleServiceName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    Component editRoleLink(String id, IModel itemModel, GeoServerDataProvider.Property<GeoServerRole> property) {
        return new SimpleAjaxLink(id, itemModel, property.getModel(itemModel)){

            protected void onClick(AjaxRequestTarget target) {
                this.setResponsePage((IRequestablePage)new EditRolePage(RolePanel.this.roleServiceName, (GeoServerRole)this.getDefaultModelObject()).setReturnPage(this.getPage()));
            }
        };
    }

    Component editParentRoleLink(String id, IModel itemModel, GeoServerDataProvider.Property<GeoServerRole> property) {
        return new SimpleAjaxLink(id, itemModel, property.getModel(itemModel)){

            protected void onClick(AjaxRequestTarget target) {
                GeoServerRole parentRole;
                GeoServerRole role = (GeoServerRole)this.getDefaultModelObject();
                try {
                    parentRole = GeoServerApplication.get().getSecurityManager().loadRoleService(RolePanel.this.roleServiceName).getParentRole(role);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.setResponsePage((IRequestablePage)new EditRolePage(RolePanel.this.roleServiceName, parentRole).setReturnPage(this.getPage()));
            }
        };
    }

    protected void onBeforeRender() {
        this.roles.clearSelection();
        this.removal.setEnabled(false);
        super.onBeforeRender();
    }
}

