/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.role;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.web.SecurityNamedServicePanel;
import org.geoserver.security.web.SecurityNamedServiceTabbedPanel;
import org.geoserver.security.web.role.RoleChoice;
import org.geoserver.security.web.role.RolePanel;

public class RoleServicePanel<T extends SecurityRoleServiceConfig>
extends SecurityNamedServicePanel<T>
implements SecurityNamedServiceTabbedPanel<T> {
    public RoleServicePanel(String id, IModel<T> model) {
        super(id, model);
        this.add(new Component[]{new RoleChoice("adminRoleName", model)});
        this.add(new Component[]{new RoleChoice("groupAdminRoleName", model)});
    }

    @Override
    public List<ITab> createTabs(final IModel<T> model) {
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        tabs.add((ITab)new AbstractTab((IModel)new StringResourceModel("roles", (Component)this, null)){

            public Panel getPanel(String panelId) {
                return new RolePanel(panelId, ((SecurityRoleServiceConfig)model.getObject()).getName());
            }
        });
        return tabs;
    }

    @Override
    public void doSave(T config) throws Exception {
        this.getSecurityManager().saveRoleService(config);
    }

    @Override
    public void doLoad(T config) throws Exception {
        this.getSecurityManager().loadRoleService(config.getName());
    }
}

