/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid.hexagon;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.Neighbor;
import org.geotools.grid.PolygonBuilder;
import org.geotools.grid.PolygonElement;
import org.geotools.grid.hexagon.Hexagon;
import org.geotools.grid.hexagon.HexagonOrientation;
import org.geotools.grid.hexagon.Hexagons;

public class HexagonBuilder
extends PolygonBuilder {
    private final double sideLen;
    private final HexagonOrientation orientation;
    private final Neighbor[] nextX = new Neighbor[2];
    private final Neighbor[] nextY = new Neighbor[2];
    private int xIndex = 0;
    private int yIndex = 0;

    public HexagonBuilder(ReferencedEnvelope gridBounds, double sideLen, HexagonOrientation orientation) {
        super(gridBounds);
        this.sideLen = sideLen;
        this.orientation = orientation;
        if (orientation == HexagonOrientation.ANGLED) {
            this.nextX[0] = this.nextX[1] = Neighbor.RIGHT;
            this.nextY[0] = Neighbor.UPPER_RIGHT;
            this.nextY[1] = Neighbor.UPPER_LEFT;
        } else {
            this.nextX[0] = Neighbor.LOWER_RIGHT;
            this.nextX[1] = Neighbor.UPPER_RIGHT;
            this.nextY[0] = this.nextY[1] = Neighbor.UPPER;
        }
    }

    @Override
    public boolean isValidNeighbor(Neighbor neighbor) {
        switch (neighbor) {
            case LEFT: 
            case RIGHT: {
                return this.orientation == HexagonOrientation.ANGLED;
            }
            case LOWER: 
            case UPPER: {
                return this.orientation == HexagonOrientation.FLAT;
            }
            case LOWER_LEFT: 
            case LOWER_RIGHT: 
            case UPPER_LEFT: 
            case UPPER_RIGHT: {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid value for neighbor");
    }

    @Override
    public Hexagon createNeighbor(PolygonElement el, Neighbor neighbor) {
        double dx;
        if (el == null || neighbor == null) {
            throw new IllegalArgumentException("el and neighbour position must both be non-null");
        }
        if (!(el instanceof Hexagon)) {
            throw new IllegalArgumentException("el must be an instance of Hexagon");
        }
        Hexagon hexagon = (Hexagon)el;
        if (!this.isValidNeighbor(neighbor)) {
            throw new IllegalArgumentException(String.valueOf((Object)neighbor) + " is not a valid neighbour position for orientation " + String.valueOf((Object)hexagon.getOrientation()));
        }
        ReferencedEnvelope bounds = hexagon.getBounds();
        return Hexagons.create(bounds.getMinX() + dx, bounds.getMinY() + (switch (neighbor) {
            case Neighbor.LEFT -> {
                dx = -bounds.getWidth();
                yield 0.0;
            }
            case Neighbor.LOWER -> {
                dx = 0.0;
                yield -bounds.getHeight();
            }
            case Neighbor.LOWER_LEFT -> {
                if (hexagon.getOrientation() == HexagonOrientation.FLAT) {
                    dx = -0.75 * bounds.getWidth();
                    yield -0.5 * bounds.getHeight();
                }
                dx = -0.5 * bounds.getWidth();
                yield -0.75 * bounds.getHeight();
            }
            case Neighbor.LOWER_RIGHT -> {
                if (hexagon.getOrientation() == HexagonOrientation.FLAT) {
                    dx = 0.75 * bounds.getWidth();
                    yield -0.5 * bounds.getHeight();
                }
                dx = 0.5 * bounds.getWidth();
                yield -0.75 * bounds.getHeight();
            }
            case Neighbor.RIGHT -> {
                dx = bounds.getWidth();
                yield 0.0;
            }
            case Neighbor.UPPER -> {
                dx = 0.0;
                yield bounds.getHeight();
            }
            case Neighbor.UPPER_LEFT -> {
                if (hexagon.getOrientation() == HexagonOrientation.FLAT) {
                    dx = -0.75 * bounds.getWidth();
                    yield 0.5 * bounds.getHeight();
                }
                dx = -0.5 * bounds.getWidth();
                yield 0.75 * bounds.getHeight();
            }
            case Neighbor.UPPER_RIGHT -> {
                if (hexagon.getOrientation() == HexagonOrientation.FLAT) {
                    dx = 0.75 * bounds.getWidth();
                    yield 0.5 * bounds.getHeight();
                }
                dx = 0.5 * bounds.getWidth();
                yield 0.75 * bounds.getHeight();
            }
            default -> throw new IllegalArgumentException("Unrecognized value for neighbor");
        }), hexagon.getSideLength(), hexagon.getOrientation(), bounds.getCoordinateReferenceSystem());
    }

    @Override
    public PolygonElement getFirstElement() {
        return Hexagons.create(this.gridBounds.getMinX(), this.gridBounds.getMinY(), this.sideLen, this.orientation, this.gridBounds.getCoordinateReferenceSystem());
    }

    @Override
    public PolygonElement getNextXElement(PolygonElement el) {
        Hexagon h = this.createNeighbor(el, this.nextX[this.xIndex]);
        this.xIndex = (this.xIndex + 1) % 2;
        return h;
    }

    @Override
    public PolygonElement getNextYElement(PolygonElement el) {
        Hexagon h = this.createNeighbor(el, this.nextY[this.yIndex]);
        this.yIndex = (this.yIndex + 1) % 2;
        this.xIndex = 0;
        return h;
    }

    @Override
    public boolean isValidDenseVertexSpacing(double v) {
        return v > 0.0 && v < this.sideLen / 2.0;
    }
}

