/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid.oval;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.Neighbor;
import org.geotools.grid.PolygonBuilder;
import org.geotools.grid.PolygonElement;
import org.geotools.grid.oval.Oval;
import org.geotools.grid.oval.Ovals;

public class OvalBuilder
extends PolygonBuilder {
    private final double elementWidth;
    private final double elementHeight;

    OvalBuilder(ReferencedEnvelope bounds, double width, double height) {
        super(bounds);
        this.elementWidth = width;
        this.elementHeight = height;
    }

    @Override
    public boolean isValidNeighbor(Neighbor neighbor) {
        return true;
    }

    @Override
    public Oval createNeighbor(PolygonElement el, Neighbor neighbor) {
        double dx;
        if (el == null || neighbor == null) {
            throw new IllegalArgumentException("el and neighbour position must both be non-null");
        }
        if (!(el instanceof Oval)) {
            throw new IllegalArgumentException("el must be an instance of Oval");
        }
        Oval oval = (Oval)el;
        ReferencedEnvelope bounds = oval.getBounds();
        return Ovals.create(bounds.getMinX() + dx, bounds.getMinY() + (switch (neighbor) {
            case Neighbor.LEFT -> {
                dx = -bounds.getWidth();
                yield 0.0;
            }
            case Neighbor.LOWER -> {
                dx = 0.0;
                yield -bounds.getHeight();
            }
            case Neighbor.LOWER_LEFT -> {
                dx = -bounds.getWidth();
                yield -bounds.getHeight();
            }
            case Neighbor.LOWER_RIGHT -> {
                dx = bounds.getWidth();
                yield -bounds.getHeight();
            }
            case Neighbor.RIGHT -> {
                dx = bounds.getWidth();
                yield 0.0;
            }
            case Neighbor.UPPER -> {
                dx = 0.0;
                yield bounds.getHeight();
            }
            case Neighbor.UPPER_LEFT -> {
                dx = -bounds.getWidth();
                yield bounds.getHeight();
            }
            case Neighbor.UPPER_RIGHT -> {
                dx = bounds.getWidth();
                yield bounds.getHeight();
            }
            default -> throw new IllegalArgumentException("Unrecognized value for neighbor");
        }), bounds.getWidth(), bounds.getHeight(), bounds.getCoordinateReferenceSystem());
    }

    @Override
    public boolean isValidDenseVertexSpacing(double v) {
        return v > 0.0 && v < Math.min(this.elementWidth, this.elementHeight) / 2.0;
    }

    @Override
    public PolygonElement getFirstElement() {
        return Ovals.create(this.gridBounds.getMinX(), this.gridBounds.getMinY(), this.elementWidth, this.elementHeight, this.gridBounds.getCoordinateReferenceSystem());
    }

    @Override
    public PolygonElement getNextXElement(PolygonElement el) {
        return this.createNeighbor(el, Neighbor.RIGHT);
    }

    @Override
    public PolygonElement getNextYElement(PolygonElement el) {
        return this.createNeighbor(el, Neighbor.UPPER);
    }
}

