/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.InvalidParameterNameException;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.parameter.AbstractParameterDescriptor;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.util.UnmodifiableArrayList;

public class DefaultParameterDescriptorGroup
extends AbstractParameterDescriptor
implements ParameterDescriptorGroup {
    private static final long serialVersionUID = -4613190550542423839L;
    private final int maximumOccurs;
    private final GeneralParameterDescriptor[] parameters;
    private transient List<GeneralParameterDescriptor> asList;

    public DefaultParameterDescriptorGroup(ParameterDescriptorGroup group) {
        super((GeneralParameterDescriptor)group);
        this.maximumOccurs = group.getMaximumOccurs();
        List c = group.descriptors();
        this.parameters = c.toArray(new GeneralParameterDescriptor[c.size()]);
    }

    public DefaultParameterDescriptorGroup(String name, GeneralParameterDescriptor ... parameters) {
        this(Collections.singletonMap("name", name), parameters);
    }

    public DefaultParameterDescriptorGroup(Citation authority, String name, GeneralParameterDescriptor ... parameters) {
        this(Collections.singletonMap("name", new NamedIdentifier(authority, name)), parameters);
    }

    public DefaultParameterDescriptorGroup(Map<String, ?> properties, GeneralParameterDescriptor ... parameters) {
        this(properties, 1, 1, parameters);
    }

    public DefaultParameterDescriptorGroup(Map<String, ?> properties, int minimumOccurs, int maximumOccurs, GeneralParameterDescriptor ... parameters) {
        super(properties, minimumOccurs, maximumOccurs);
        int i;
        this.maximumOccurs = maximumOccurs;
        DefaultParameterDescriptorGroup.ensureNonNull("parameters", parameters);
        this.parameters = new GeneralParameterDescriptor[parameters.length];
        for (i = 0; i < parameters.length; ++i) {
            this.parameters[i] = parameters[i];
            DefaultParameterDescriptorGroup.ensureNonNull("parameters", parameters, i);
        }
        parameters = this.parameters;
        for (i = 0; i < parameters.length; ++i) {
            String name = parameters[i].getName().getCode();
            for (int j = 0; j < parameters.length; ++j) {
                if (i == j || !DefaultParameterDescriptorGroup.nameMatches((IdentifiedObject)parameters[j], name)) continue;
                String arg0 = parameters[j].getName().getCode();
                throw new InvalidParameterNameException(MessageFormat.format("Name or alias for parameter \"{0}\" at index {1} conflict with name \"{2}\" at index {3}.", arg0, j, name, i), name);
            }
        }
    }

    @Override
    public int getMaximumOccurs() {
        return this.maximumOccurs;
    }

    public ParameterValueGroup createValue() {
        return new ParameterGroup(this);
    }

    public List<GeneralParameterDescriptor> descriptors() {
        if (this.asList == null) {
            if (this.parameters == null) {
                this.asList = Collections.emptyList();
            } else {
                switch (this.parameters.length) {
                    case 0: {
                        this.asList = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        this.asList = Collections.singletonList(this.parameters[0]);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.asList = UnmodifiableArrayList.wrap((Object[])this.parameters);
                        break;
                    }
                    default: {
                        this.asList = new AsList(this.parameters);
                    }
                }
            }
        }
        return this.asList;
    }

    public GeneralParameterDescriptor descriptor(String name) throws ParameterNotFoundException {
        DefaultParameterDescriptorGroup.ensureNonNull("name", name);
        name = name.trim();
        LinkedList<DefaultParameterDescriptorGroup> subgroups = null;
        List<GeneralParameterDescriptor> parameters = this.descriptors();
        while (parameters != null) {
            for (GeneralParameterDescriptor param : parameters) {
                if (param instanceof ParameterDescriptor) {
                    if (!DefaultParameterDescriptorGroup.nameMatches((IdentifiedObject)param, name)) continue;
                    return param;
                }
                if (!(param instanceof DefaultParameterDescriptorGroup)) continue;
                DefaultParameterDescriptorGroup group = (DefaultParameterDescriptorGroup)param;
                if (subgroups == null) {
                    subgroups = new LinkedList<DefaultParameterDescriptorGroup>();
                }
                assert (!subgroups.contains(param)) : param;
                subgroups.add(group);
            }
            if (subgroups == null || subgroups.isEmpty()) break;
            parameters = ((DefaultParameterDescriptorGroup)subgroups.remove(0)).descriptors();
        }
        throw new ParameterNotFoundException(MessageFormat.format("Parameter \"{0}\" is missing.", name), name);
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultParameterDescriptorGroup that = (DefaultParameterDescriptorGroup)object;
            return Arrays.equals(this.parameters, that.parameters);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        for (GeneralParameterDescriptor parameter : this.parameters) {
            code = code * 37 + parameter.hashCode();
        }
        return code;
    }

    private static final class AsList
    extends UnmodifiableArrayList<GeneralParameterDescriptor> {
        private static final long serialVersionUID = -2116304004367396735L;
        private transient Set<GeneralParameterDescriptor> asSet;

        public AsList(GeneralParameterDescriptor ... array) {
            super((Object[])array);
        }

        public boolean contains(Object object) {
            if (this.asSet == null) {
                this.asSet = new HashSet<GeneralParameterDescriptor>((Collection<GeneralParameterDescriptor>)((Object)this));
            }
            return this.asSet.contains(object);
        }
    }
}

