/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.awt.image.RenderedImage;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.imagen.EnumeratedParameter;
import org.eclipse.imagen.OperationDescriptor;
import org.eclipse.imagen.ParameterListDescriptor;
import org.eclipse.imagen.RegistryElementDescriptor;
import org.eclipse.imagen.util.Range;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.metadata.citation.Contact;
import org.geotools.api.metadata.citation.OnLineFunction;
import org.geotools.api.metadata.citation.OnLineResource;
import org.geotools.api.metadata.citation.ResponsibleParty;
import org.geotools.api.metadata.citation.Role;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.InvalidParameterNameException;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.util.GenericName;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.citation.ContactImpl;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.metadata.iso.citation.ResponsiblePartyImpl;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ImagingParameterDescription;
import org.geotools.parameter.ImagingParameters;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.util.NameFactory;
import org.geotools.util.Utilities;
import org.geotools.util.XArray;

public class ImagingParameterDescriptors
extends DefaultParameterDescriptorGroup {
    private static final long serialVersionUID = 2127050865911951239L;
    private static final Object[] AUTHORITIES = new Object[]{"org.eclipse.imagen.media", Citations.IMAGEN, "org.geotools", Citations.GEOTOOLS, "org.jaitools.media.jai", Citations.IMAGEN, "org.eclipse.imagen.media", Citations.IMAGEN};
    public static final Map<Class<?>, Class<?>> DEFAULT_SOURCE_TYPE_MAP = Collections.singletonMap(RenderedImage.class, GridCoverage.class);
    protected final String registryMode;
    protected final RegistryElementDescriptor operation;
    protected final ParameterListDescriptor descriptor;

    public ImagingParameterDescriptors(RegistryElementDescriptor operation) {
        this(ImagingParameterDescriptors.properties(operation), operation.getParameterListDescriptor("rendered"), operation, "rendered", DEFAULT_SOURCE_TYPE_MAP, null);
    }

    public ImagingParameterDescriptors(RegistryElementDescriptor operation, Collection<ParameterDescriptor> extension) {
        this(ImagingParameterDescriptors.properties(operation), operation, "rendered", DEFAULT_SOURCE_TYPE_MAP, extension);
    }

    public ImagingParameterDescriptors(Map<String, ?> properties, RegistryElementDescriptor operation, String registryMode, Map<Class<?>, Class<?>> sourceTypeMap, Collection<ParameterDescriptor> extension) {
        this(properties, operation.getParameterListDescriptor(registryMode), operation, registryMode, sourceTypeMap, extension);
    }

    public ImagingParameterDescriptors(Map<String, ?> properties, ParameterListDescriptor descriptor) {
        this(properties, descriptor, null, null, null, null);
    }

    private ImagingParameterDescriptors(Map<String, ?> properties, ParameterListDescriptor descriptor, RegistryElementDescriptor operation, String registryMode, Map<Class<?>, Class<?>> sourceTypeMap, Collection<ParameterDescriptor> extension) {
        super(properties, 1, 1, (GeneralParameterDescriptor[])ImagingParameterDescriptors.asDescriptors(descriptor, operation, registryMode, sourceTypeMap, extension));
        this.descriptor = descriptor;
        this.operation = operation;
        this.registryMode = registryMode;
    }

    public static Map<String, Object> properties(RegistryElementDescriptor operation) {
        String name = operation.getName();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (operation instanceof OperationDescriptor) {
            OperationDescriptor op = (OperationDescriptor)operation;
            ResourceBundle bundle = op.getResourceBundle(Locale.getDefault());
            String vendor = op.getResourceBundle(Locale.US).getString("Vendor");
            Citation authority = null;
            if (vendor != null) {
                vendor = vendor.trim();
                name = ImagingParameterDescription.trimPrefix(name, vendor);
                for (int i = 0; i < AUTHORITIES.length; i += 2) {
                    if (!vendor.equalsIgnoreCase((String)AUTHORITIES[i])) continue;
                    authority = (Citation)AUTHORITIES[i + 1];
                    break;
                }
            }
            if (authority == null) {
                throw new IllegalArgumentException(MessageFormat.format("No object of type \"{0}\" has been found for code \"{1}\".", "AUTHORITIES", vendor));
            }
            ImagingParameterDescription description = new ImagingParameterDescription(op, "Description", null);
            try {
                ResponsibleParty oldParty;
                URI uri = new URI(bundle.getString("DocURL"));
                OnLineResourceImpl resource = new OnLineResourceImpl(uri);
                resource.setFunction(OnLineFunction.INFORMATION);
                resource.setDescription((InternationalString)description);
                CitationImpl citation = new CitationImpl(authority);
                Collection parties = citation.getCitedResponsibleParties();
                Iterator it = parties.iterator();
                if (it.hasNext()) {
                    oldParty = (ResponsibleParty)it.next();
                    it.remove();
                } else {
                    oldParty = null;
                }
                ResponsiblePartyImpl party = new ResponsiblePartyImpl(oldParty);
                party.setRole(Role.RESOURCE_PROVIDER);
                party.setContactInfo((Contact)new ContactImpl((OnLineResource)resource));
                parties.add(party);
                authority = (Citation)citation.unmodifiable();
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
            GenericName alias = NameFactory.create((CharSequence[])new InternationalString[]{new ImagingParameterDescription(op, "Vendor", null), new ImagingParameterDescription(op, "LocalName", "Vendor")}, (char)'.');
            properties.put("alias", alias);
            properties.put("remarks", description);
            properties.put("version", bundle.getString("Version"));
            properties.put("authority", authority);
        }
        properties.put("name", name);
        return properties;
    }

    private static ParameterDescriptor[] asDescriptors(ParameterListDescriptor descriptor, RegistryElementDescriptor operation, String registryMode, Map<Class<?>, Class<?>> sourceTypeMap, Collection<ParameterDescriptor> extension) {
        int i;
        Object[] desc;
        ImagingParameterDescriptors.ensureNonNull("descriptor", descriptor);
        LinkedHashMap<String, ParameterDescriptor> replacements = new LinkedHashMap<String, ParameterDescriptor>();
        if (extension != null) {
            for (ParameterDescriptor d : extension) {
                String name = d.getName().getCode().trim().toLowerCase();
                if (replacements.put(name, d) == null) continue;
                throw new InvalidParameterNameException(MessageFormat.format("Duplicated values for code \"{0}\".", name), name);
            }
        }
        int numParameters = descriptor.getNumParameters();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (operation instanceof OperationDescriptor) {
            OperationDescriptor op = (OperationDescriptor)operation;
            String[] names = op.getSourceNames();
            Class[] types = op.getSourceClasses(registryMode);
            numSources = op.getNumSources();
            desc = new ParameterDescriptor[numParameters + numSources];
            for (i = 0; i < numSources; ++i) {
                char c;
                int length;
                Class type = sourceTypeMap.get(types[i]);
                if (type == null) {
                    type = types[i];
                }
                String name = names[i];
                properties.clear();
                if (numSources == 1 && (length = name.length()) != 0 && ((c = name.charAt(length - 1)) == '0' || c == '1')) {
                    properties.put("alias", name);
                    name = name.substring(0, length - 1);
                }
                properties.put("name", name);
                desc[i] = new DefaultParameterDescriptor<Object>(properties, type, null, null, null, null, null, true);
            }
        } else {
            numSources = 0;
            desc = new ParameterDescriptor[numParameters];
        }
        String[] names = descriptor.getParamNames();
        Class[] classes = descriptor.getParamClasses();
        Object[] defaults = descriptor.getParamDefaults();
        for (i = 0; i < numParameters; ++i) {
            OperationDescriptor operationDescriptor;
            ImagingParameterDescription remark;
            Object defaultValue;
            EnumeratedParameter[] validValues;
            Comparable max;
            Comparable min;
            String name = names[i];
            ParameterDescriptor replacement = (ParameterDescriptor)replacements.remove(name.trim().toLowerCase());
            if (replacement != null) {
                desc[i + numSources] = replacement;
                continue;
            }
            Class type = classes[i];
            Range range = descriptor.getParamValueRange(name);
            if (range != null) {
                min = range.getMinValue();
                max = range.getMaxValue();
            } else {
                min = null;
                max = null;
            }
            if (EnumeratedParameter.class.isAssignableFrom(type)) {
                try {
                    validValues = descriptor.getEnumeratedParameterValues(name);
                }
                catch (UnsupportedOperationException exception) {
                    validValues = null;
                }
            } else {
                validValues = null;
            }
            if ((defaultValue = defaults[i]) == ParameterListDescriptor.NO_PARAMETER_DEFAULT) {
                defaultValue = null;
            }
            properties.clear();
            properties.put("name", name);
            if (operation instanceof OperationDescriptor && (remark = new ImagingParameterDescription(operationDescriptor = (OperationDescriptor)operation, i)).exists()) {
                properties.put("remarks", remark);
            }
            desc[i + numSources] = new DefaultParameterDescriptor<Object>(properties, type, validValues, defaultValue, min, max, null, true);
        }
        i = desc.length;
        desc = (ParameterDescriptor[])XArray.resize((Object[])desc, (int)(i + replacements.size()));
        for (ParameterDescriptor d : replacements.values()) {
            desc[i++] = d;
        }
        return desc;
    }

    @Override
    public ParameterValueGroup createValue() {
        return new ImagingParameters(this);
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            ImagingParameterDescriptors that = (ImagingParameterDescriptors)object;
            return Utilities.equals((Object)this.operation, (Object)that.operation) && Utilities.equals((Object)this.descriptor, (Object)that.descriptor);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.descriptor.hashCode();
    }
}

