/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.InvalidParameterCardinalityException;
import org.geotools.api.parameter.InvalidParameterTypeException;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.parameter.AbstractParameter;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterValueList;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.util.Utilities;

public class ParameterGroup
extends AbstractParameter
implements ParameterValueGroup {
    private static final long serialVersionUID = -1985309386356545126L;
    public static ParameterValueGroup EMPTY = new ParameterGroup(Collections.singletonMap("name", "Void"), (GeneralParameterValue[])new ParameterValue[0]);
    private ArrayList<GeneralParameterValue> values;
    private transient List<GeneralParameterValue> asList;

    public ParameterGroup(ParameterDescriptorGroup descriptor) {
        super((GeneralParameterDescriptor)descriptor);
        List parameters = descriptor.descriptors();
        this.values = new ArrayList(parameters.size());
        for (GeneralParameterDescriptor element : parameters) {
            int count = element.getMinimumOccurs();
            while (--count >= 0) {
                GeneralParameterValue value = element.createValue();
                ParameterGroup.ensureNonNull("createValue", value);
                this.values.add(value);
            }
        }
    }

    public ParameterGroup(ParameterDescriptorGroup descriptor, GeneralParameterValue ... values) {
        super((GeneralParameterDescriptor)descriptor);
        ParameterGroup.ensureNonNull("values", values);
        this.values = new ArrayList(values.length);
        this.values.addAll(Arrays.asList(values));
        List parameters = descriptor.descriptors();
        LinkedHashMap<GeneralParameterDescriptor, int[]> occurences = new LinkedHashMap<GeneralParameterDescriptor, int[]>(Math.round((float)parameters.size() / 0.75f) + 1, 0.75f);
        for (GeneralParameterDescriptor param : parameters) {
            ParameterGroup.ensureNonNull("parameters", param);
            occurences.put(param, new int[1]);
        }
        ParameterGroup.ensureValidOccurs(values, occurences);
    }

    public ParameterGroup(Map<String, ?> properties, GeneralParameterValue ... values) {
        super((GeneralParameterDescriptor)ParameterGroup.createDescriptor(properties, values));
        this.values = new ArrayList(values.length);
        this.values.addAll(Arrays.asList(values));
    }

    private static ParameterDescriptorGroup createDescriptor(Map<String, ?> properties, GeneralParameterValue ... values) {
        ParameterGroup.ensureNonNull("values", values);
        LinkedHashMap<GeneralParameterDescriptor, int[]> occurences = new LinkedHashMap<GeneralParameterDescriptor, int[]>(Math.round((float)values.length / 0.75f) + 1, 0.75f);
        for (int i = 0; i < values.length; ++i) {
            ParameterGroup.ensureNonNull("values", values, i);
            occurences.put(values[i].getDescriptor(), new int[1]);
        }
        ParameterGroup.ensureValidOccurs(values, occurences);
        Set descriptors = occurences.keySet();
        return new DefaultParameterDescriptorGroup(properties, descriptors.toArray(new GeneralParameterDescriptor[descriptors.size()]));
    }

    private static void ensureValidOccurs(GeneralParameterValue[] values, Map<GeneralParameterDescriptor, int[]> occurences) {
        for (int i = 0; i < values.length; ++i) {
            ParameterGroup.ensureNonNull("values", values, i);
            GeneralParameterDescriptor descriptor = values[i].getDescriptor();
            int[] count = occurences.get(descriptor);
            if (count == null) {
                String name = ParameterGroup.getName(descriptor);
                throw new InvalidParameterTypeException(MessageFormat.format("Illegal descriptor for parameter \"{0}\".", name), name);
            }
            count[0] = count[0] + 1;
        }
        for (Map.Entry<GeneralParameterDescriptor, int[]> entry : occurences.entrySet()) {
            GeneralParameterDescriptor descriptor = entry.getKey();
            int count = entry.getValue()[0];
            int min = descriptor.getMinimumOccurs();
            int max = descriptor.getMaximumOccurs();
            if (count >= min && count <= max) continue;
            String name = ParameterGroup.getName(descriptor);
            throw new InvalidParameterCardinalityException(MessageFormat.format("Parameter \"{0}\" occurs {1} time, while the expected range of occurences was [{2}..{3}].", name, count, min, max), name);
        }
    }

    public ParameterDescriptorGroup getDescriptor() {
        return (ParameterDescriptorGroup)super.getDescriptor();
    }

    public List<GeneralParameterValue> values() {
        if (this.asList == null) {
            this.asList = new ParameterValueList((ParameterDescriptorGroup)this.descriptor, this.values);
        }
        return this.asList;
    }

    final GeneralParameterValue parameter(int index) throws IndexOutOfBoundsException {
        return this.values.get(index);
    }

    public ParameterValue parameter(String name) throws ParameterNotFoundException {
        ParameterGroup.ensureNonNull("name", name);
        name = name.trim();
        for (GeneralParameterValue value : this.values) {
            if (!(value instanceof ParameterValue)) continue;
            ParameterValue parameterValue = (ParameterValue)value;
            if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), name)) continue;
            return parameterValue;
        }
        for (GeneralParameterDescriptor descriptor : this.getDescriptor().descriptors()) {
            if (!(descriptor instanceof ParameterDescriptor)) continue;
            ParameterDescriptor parameterDescriptor = (ParameterDescriptor)descriptor;
            if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)descriptor, name)) continue;
            ParameterValue value = parameterDescriptor.createValue();
            this.values.add((GeneralParameterValue)value);
            return value;
        }
        throw new ParameterNotFoundException(MessageFormat.format("Parameter \"{0}\" is missing.", name), name);
    }

    public List<ParameterValueGroup> groups(String name) throws ParameterNotFoundException {
        GeneralParameterDescriptor check;
        ParameterGroup.ensureNonNull("name", name);
        name = name.trim();
        ArrayList<ParameterValueGroup> groups = new ArrayList<ParameterValueGroup>(Math.min(this.values.size(), 10));
        for (GeneralParameterValue value : this.values) {
            if (!(value instanceof ParameterValueGroup)) continue;
            ParameterValueGroup group = (ParameterValueGroup)value;
            if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), name)) continue;
            groups.add(group);
        }
        if (groups.isEmpty() && !((check = ((ParameterDescriptorGroup)this.descriptor).descriptor(name)) instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(MessageFormat.format("Parameter \"{0}\" is missing.", name), name);
        }
        return groups;
    }

    public ParameterValueGroup addGroup(String name) throws ParameterNotFoundException, InvalidParameterCardinalityException {
        GeneralParameterDescriptor check = ((ParameterDescriptorGroup)this.descriptor).descriptor(name);
        if (!(check instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(MessageFormat.format("Parameter \"{0}\" is missing.", name), name);
        }
        int count = 0;
        for (GeneralParameterValue value : this.values) {
            if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), name)) continue;
            ++count;
        }
        if (count >= check.getMaximumOccurs()) {
            throw new InvalidParameterCardinalityException(MessageFormat.format("Too many occurences of \"{0}\". There is already {1} of them.", name, count), name);
        }
        ParameterValueGroup value = ((ParameterDescriptorGroup)check).createValue();
        this.values.add((GeneralParameterValue)value);
        return value;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ParameterGroup that = (ParameterGroup)object;
            return Utilities.equals(this.values, that.values);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.values.hashCode();
    }

    @Override
    public ParameterGroup clone() {
        ParameterGroup copy = (ParameterGroup)super.clone();
        copy.values = (ArrayList)copy.values.clone();
        int i = copy.values.size();
        while (--i >= 0) {
            copy.values.set(i, copy.values.get(i).clone());
        }
        copy.asList = null;
        return copy;
    }
}

