/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.geotools.api.metadata.Identifier;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.referencing.AuthorityFactory;
import org.geotools.api.referencing.Factory;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.util.Classes;
import org.geotools.util.TableWriter;
import org.geotools.util.factory.FactoryRegistry;

final class FactoryPrinter
implements Comparator<Class<?>> {
    @Override
    public int compare(Class<?> factory1, Class<?> factory2) {
        return Classes.getShortName(factory1).compareToIgnoreCase(Classes.getShortName(factory2));
    }

    public void list(FactoryRegistry registry, Writer out, Locale locale) throws IOException {
        List categories = registry.streamCategories().sorted(this).collect(Collectors.toList());
        Vocabulary resources = Vocabulary.getResources((Locale)locale);
        TableWriter table = new TableWriter(out, " \u2502 ");
        table.setMultiLinesCells(true);
        table.writeHorizontalSeparator();
        table.write(resources.getString(69));
        table.nextColumn();
        table.write(resources.getString(6));
        table.nextColumn();
        table.write(resources.getString(237));
        table.nextColumn();
        table.write(resources.getString(107));
        table.nextLine();
        table.nextLine('\u2550');
        StringBuilder vendors = new StringBuilder();
        StringBuilder implementations = new StringBuilder();
        for (Class category : categories) {
            table.write(Classes.getShortName((Class)category));
            table.nextColumn();
            Iterator providers = registry.getFactories(category, null, null).iterator();
            while (providers.hasNext()) {
                if (implementations.length() != 0) {
                    table.write(10);
                    vendors.append('\n');
                    implementations.append('\n');
                }
                Factory provider = (Factory)providers.next();
                Citation vendor = provider.getVendor();
                vendors.append(vendor.getTitle().toString(locale));
                implementations.append(Classes.getShortClassName((Object)provider));
                if (!(provider instanceof AuthorityFactory)) continue;
                AuthorityFactory factory = (AuthorityFactory)provider;
                Citation authority = factory.getAuthority();
                Iterator identifiers = authority.getIdentifiers().iterator();
                String identifier = identifiers.hasNext() ? ((Identifier)identifiers.next()).getCode().toString() : authority.getTitle().toString(locale);
                table.write(identifier);
            }
            table.nextColumn();
            table.write(vendors.toString());
            vendors.setLength(0);
            table.nextColumn();
            table.write(implementations.toString());
            implementations.setLength(0);
            table.writeHorizontalSeparator();
        }
        table.flush();
    }
}

