/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.ReferenceSystem;
import org.geotools.api.referencing.datum.Datum;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.AbstractCoordinateOperation;
import org.geotools.util.MapEntry;

final class Properties
extends AbstractMap<String, Object> {
    private final IdentifiedObject info;
    private transient Set<Map.Entry<String, Object>> entries;
    private static final String[] KEYS = new String[]{"name", "identifiers", "alias", "remarks", "scope", "domainOfValidity", "operationVersion", "coordinateOperationAccuracy"};

    public Properties(IdentifiedObject info) {
        this.info = info;
        AbstractIdentifiedObject.ensureNonNull("info", info);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            String string = (String)key;
            String s = string.trim();
            for (int i = 0; i < KEYS.length; ++i) {
                if (!KEYS[i].equalsIgnoreCase(s)) continue;
                return this.get(i);
            }
        }
        return null;
    }

    private Object get(int key) {
        switch (key) {
            case 0: {
                return this.info.getName();
            }
            case 1: {
                return this.info.getIdentifiers().toArray(AbstractIdentifiedObject.EMPTY_IDENTIFIER_ARRAY);
            }
            case 2: {
                return this.info.getAlias().toArray(AbstractIdentifiedObject.EMPTY_ALIAS_ARRAY);
            }
            case 3: {
                return this.info.getRemarks();
            }
            case 4: {
                IdentifiedObject identifiedObject = this.info;
                if (identifiedObject instanceof ReferenceSystem) {
                    ReferenceSystem system = (ReferenceSystem)identifiedObject;
                    return system.getScope();
                }
                identifiedObject = this.info;
                if (identifiedObject instanceof Datum) {
                    Datum datum = (Datum)identifiedObject;
                    return datum.getScope();
                }
                identifiedObject = this.info;
                if (!(identifiedObject instanceof CoordinateOperation)) break;
                CoordinateOperation operation = (CoordinateOperation)identifiedObject;
                return operation.getScope();
            }
            case 5: {
                IdentifiedObject identifiedObject = this.info;
                if (identifiedObject instanceof ReferenceSystem) {
                    ReferenceSystem system = (ReferenceSystem)identifiedObject;
                    return system.getDomainOfValidity();
                }
                identifiedObject = this.info;
                if (identifiedObject instanceof Datum) {
                    Datum datum = (Datum)identifiedObject;
                    return datum.getDomainOfValidity();
                }
                identifiedObject = this.info;
                if (!(identifiedObject instanceof CoordinateOperation)) break;
                CoordinateOperation operation = (CoordinateOperation)identifiedObject;
                return operation.getDomainOfValidity();
            }
            case 6: {
                IdentifiedObject identifiedObject = this.info;
                if (!(identifiedObject instanceof CoordinateOperation)) break;
                CoordinateOperation operation = (CoordinateOperation)identifiedObject;
                return operation.getOperationVersion();
            }
            case 7: {
                IdentifiedObject identifiedObject = this.info;
                if (!(identifiedObject instanceof CoordinateOperation)) break;
                CoordinateOperation operation = (CoordinateOperation)identifiedObject;
                return operation.getCoordinateOperationAccuracy().toArray(AbstractCoordinateOperation.EMPTY_ACCURACY_ARRAY);
            }
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.entries == null) {
            this.entries = new HashSet<Map.Entry<String, Object>>(Math.round((float)KEYS.length / 0.75f) + 1, 0.75f);
            for (int i = 0; i < KEYS.length; ++i) {
                Object value = this.get(i);
                if (value == null) continue;
                this.entries.add((Map.Entry<String, Object>)new MapEntry((Object)KEYS[i], value));
            }
            this.entries = Collections.unmodifiableSet(this.entries);
        }
        return this.entries;
    }
}

