/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Set;
import javax.measure.Unit;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.referencing.AuthorityFactory;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.CompoundCRS;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.DerivedCRS;
import org.geotools.api.referencing.crs.EngineeringCRS;
import org.geotools.api.referencing.crs.GeocentricCRS;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.ImageCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.crs.TemporalCRS;
import org.geotools.api.referencing.crs.VerticalCRS;
import org.geotools.api.referencing.cs.CSAuthorityFactory;
import org.geotools.api.referencing.cs.CartesianCS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.cs.CylindricalCS;
import org.geotools.api.referencing.cs.EllipsoidalCS;
import org.geotools.api.referencing.cs.PolarCS;
import org.geotools.api.referencing.cs.SphericalCS;
import org.geotools.api.referencing.cs.TimeCS;
import org.geotools.api.referencing.cs.VerticalCS;
import org.geotools.api.referencing.datum.Datum;
import org.geotools.api.referencing.datum.DatumAuthorityFactory;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.datum.EngineeringDatum;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.api.referencing.datum.ImageDatum;
import org.geotools.api.referencing.datum.PrimeMeridian;
import org.geotools.api.referencing.datum.TemporalDatum;
import org.geotools.api.referencing.datum.VerticalDatum;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.CoordinateOperationAuthorityFactory;
import org.geotools.api.util.InternationalString;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.util.ObjectCache;
import org.geotools.util.ObjectCaches;
import org.geotools.util.factory.BufferedFactory;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;

public final class CachedAuthorityDecorator
extends AbstractAuthorityFactory
implements AuthorityFactory,
CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory,
BufferedFactory {
    ObjectCache<Object, Object> cache;
    private AuthorityFactory authority;
    private CRSAuthorityFactory crsAuthority;
    private CSAuthorityFactory csAuthority;
    private DatumAuthorityFactory datumAuthority;
    private CoordinateOperationAuthorityFactory operationAuthority;
    private AbstractAuthorityFactory delegate;

    public CachedAuthorityDecorator(AuthorityFactory factory) {
        this(factory, CachedAuthorityDecorator.createCache(GeoTools.getDefaultHints()));
    }

    CachedAuthorityDecorator(AuthorityFactory factory, ObjectCache<Object, Object> cache) {
        super(((ReferencingFactory)factory).getPriority());
        this.cache = cache;
        this.authority = factory;
        this.crsAuthority = (CRSAuthorityFactory)factory;
        this.csAuthority = (CSAuthorityFactory)factory;
        this.datumAuthority = (DatumAuthorityFactory)factory;
        this.operationAuthority = (CoordinateOperationAuthorityFactory)factory;
        this.delegate = (AbstractAuthorityFactory)factory;
    }

    static <K, V> ObjectCache<K, V> createCache(Hints hints) throws FactoryRegistryException {
        return ObjectCaches.create((Hints)hints);
    }

    String toKey(String code) {
        return ObjectCaches.toKey((Citation)this.getAuthority(), (String)code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdentifiedObject createObject(String code) throws FactoryException {
        String key = this.toKey(code);
        IdentifiedObject obj = (IdentifiedObject)this.cache.get((Object)key);
        if (obj == null) {
            try {
                this.cache.writeLock((Object)key);
                obj = (IdentifiedObject)this.cache.peek((Object)key);
                if (obj == null) {
                    obj = this.authority.createObject(code);
                    this.cache.put((Object)key, (Object)obj);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return obj;
    }

    @Override
    public Citation getAuthority() {
        return this.authority.getAuthority();
    }

    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        return this.authority.getAuthorityCodes(type);
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        return this.authority.getDescriptionText(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CompoundCRS createCompoundCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        CompoundCRS crs = (CompoundCRS)this.cache.get((Object)key);
        if (crs == null) {
            try {
                this.cache.writeLock((Object)key);
                crs = (CompoundCRS)this.cache.peek((Object)key);
                if (crs == null) {
                    crs = this.crsAuthority.createCompoundCRS(code);
                    this.cache.put((Object)key, (Object)crs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        String key = this.toKey(code);
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)this.cache.get((Object)key);
        if (crs == null) {
            try {
                this.cache.writeLock((Object)key);
                crs = (CoordinateReferenceSystem)this.cache.peek((Object)key);
                if (crs == null) {
                    crs = this.crsAuthority.createCoordinateReferenceSystem(code);
                    this.cache.put((Object)key, (Object)crs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        DerivedCRS crs = (DerivedCRS)this.cache.get((Object)key);
        if (crs == null) {
            try {
                this.cache.writeLock((Object)key);
                crs = (DerivedCRS)this.cache.peek((Object)key);
                if (crs == null) {
                    crs = this.crsAuthority.createDerivedCRS(code);
                    this.cache.put((Object)key, (Object)crs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        EngineeringCRS crs = (EngineeringCRS)this.cache.get((Object)key);
        if (crs == null) {
            try {
                this.cache.writeLock((Object)key);
                crs = (EngineeringCRS)this.cache.peek((Object)key);
                if (crs == null) {
                    crs = this.crsAuthority.createEngineeringCRS(code);
                    this.cache.put((Object)key, (Object)crs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        GeocentricCRS crs = (GeocentricCRS)this.cache.get((Object)key);
        if (crs == null) {
            try {
                this.cache.writeLock((Object)key);
                crs = (GeocentricCRS)this.cache.peek((Object)key);
                if (crs == null) {
                    crs = this.crsAuthority.createGeocentricCRS(code);
                    this.cache.put((Object)key, (Object)crs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        GeographicCRS crs = (GeographicCRS)this.cache.get((Object)key);
        if (crs == null) {
            try {
                this.cache.writeLock((Object)key);
                crs = (GeographicCRS)this.cache.peek((Object)key);
                if (crs == null) {
                    crs = this.crsAuthority.createGeographicCRS(code);
                    this.cache.put((Object)key, (Object)crs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageCRS createImageCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        ImageCRS crs = (ImageCRS)this.cache.get((Object)key);
        if (crs == null) {
            try {
                this.cache.writeLock((Object)key);
                crs = (ImageCRS)this.cache.peek((Object)key);
                if (crs == null) {
                    crs = this.crsAuthority.createImageCRS(code);
                    this.cache.put((Object)key, (Object)crs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        ProjectedCRS crs = (ProjectedCRS)this.cache.get((Object)key);
        if (crs == null) {
            try {
                this.cache.writeLock((Object)key);
                crs = (ProjectedCRS)this.cache.peek((Object)key);
                if (crs == null) {
                    crs = this.crsAuthority.createProjectedCRS(code);
                    this.cache.put((Object)key, (Object)crs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        TemporalCRS crs = (TemporalCRS)this.cache.get((Object)key);
        if (crs == null) {
            try {
                this.cache.writeLock((Object)key);
                crs = (TemporalCRS)this.cache.peek((Object)key);
                if (crs == null) {
                    crs = this.crsAuthority.createTemporalCRS(code);
                    this.cache.put((Object)key, (Object)crs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        VerticalCRS crs = (VerticalCRS)this.cache.get((Object)key);
        if (crs == null) {
            try {
                this.cache.writeLock((Object)key);
                crs = (VerticalCRS)this.cache.peek((Object)key);
                if (crs == null) {
                    crs = this.crsAuthority.createVerticalCRS(code);
                    this.cache.put((Object)key, (Object)crs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CartesianCS createCartesianCS(String code) throws FactoryException {
        String key = this.toKey(code);
        CartesianCS cs = (CartesianCS)this.cache.get((Object)key);
        if (cs == null) {
            try {
                this.cache.writeLock((Object)key);
                cs = (CartesianCS)this.cache.peek((Object)key);
                if (cs == null) {
                    cs = this.csAuthority.createCartesianCS(code);
                    this.cache.put((Object)key, (Object)cs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        String key = this.toKey(code);
        CoordinateSystem cs = (CoordinateSystem)this.cache.get((Object)key);
        if (cs == null) {
            try {
                this.cache.writeLock((Object)key);
                cs = (CoordinateSystem)this.cache.peek((Object)key);
                if (cs == null) {
                    cs = this.csAuthority.createCoordinateSystem(code);
                    this.cache.put((Object)key, (Object)cs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        String key = this.toKey(code);
        CoordinateSystemAxis axis = (CoordinateSystemAxis)this.cache.get((Object)key);
        if (axis == null) {
            try {
                this.cache.writeLock((Object)key);
                axis = (CoordinateSystemAxis)this.cache.peek((Object)key);
                if (axis == null) {
                    axis = this.csAuthority.createCoordinateSystemAxis(code);
                    this.cache.put((Object)key, (Object)axis);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return axis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CylindricalCS createCylindricalCS(String code) throws FactoryException {
        String key = this.toKey(code);
        CylindricalCS cs = (CylindricalCS)this.cache.get((Object)key);
        if (cs == null) {
            try {
                this.cache.writeLock((Object)key);
                cs = (CylindricalCS)this.cache.peek((Object)key);
                if (cs == null) {
                    cs = this.csAuthority.createCylindricalCS(code);
                    this.cache.put((Object)key, (Object)cs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        String key = this.toKey(code);
        EllipsoidalCS cs = (EllipsoidalCS)this.cache.get((Object)key);
        if (cs == null) {
            try {
                this.cache.writeLock((Object)key);
                cs = (EllipsoidalCS)this.cache.peek((Object)key);
                if (cs == null) {
                    cs = this.csAuthority.createEllipsoidalCS(code);
                    this.cache.put((Object)key, (Object)cs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PolarCS createPolarCS(String code) throws FactoryException {
        String key = this.toKey(code);
        PolarCS cs = (PolarCS)this.cache.get((Object)key);
        if (cs == null) {
            try {
                this.cache.writeLock((Object)key);
                cs = (PolarCS)this.cache.peek((Object)key);
                if (cs == null) {
                    cs = this.csAuthority.createPolarCS(code);
                    this.cache.put((Object)key, (Object)cs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SphericalCS createSphericalCS(String code) throws FactoryException {
        String key = this.toKey(code);
        SphericalCS cs = (SphericalCS)this.cache.get((Object)key);
        if (cs == null) {
            try {
                this.cache.writeLock((Object)key);
                cs = (SphericalCS)this.cache.peek((Object)key);
                if (cs == null) {
                    cs = this.csAuthority.createSphericalCS(code);
                    this.cache.put((Object)key, (Object)cs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeCS createTimeCS(String code) throws FactoryException {
        String key = this.toKey(code);
        TimeCS cs = (TimeCS)this.cache.get((Object)key);
        if (cs == null) {
            try {
                this.cache.writeLock((Object)key);
                cs = (TimeCS)this.cache.peek((Object)key);
                if (cs == null) {
                    cs = this.csAuthority.createTimeCS(code);
                    this.cache.put((Object)key, (Object)cs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Unit<?> createUnit(String code) throws FactoryException {
        String key = this.toKey(code);
        Unit unit = (Unit)this.cache.get((Object)key);
        if (unit == null) {
            try {
                this.cache.writeLock((Object)key);
                unit = (Unit)this.cache.peek((Object)key);
                if (unit == null) {
                    unit = this.csAuthority.createUnit(code);
                    this.cache.put((Object)key, (Object)unit);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerticalCS createVerticalCS(String code) throws FactoryException {
        String key = this.toKey(code);
        VerticalCS cs = (VerticalCS)this.cache.get((Object)key);
        if (cs == null) {
            try {
                this.cache.writeLock((Object)key);
                cs = (VerticalCS)this.cache.peek((Object)key);
                if (cs == null) {
                    cs = this.csAuthority.createVerticalCS(code);
                    this.cache.put((Object)key, (Object)cs);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum createDatum(String code) throws FactoryException {
        String key = this.toKey(code);
        Datum datum = (Datum)this.cache.get((Object)key);
        if (datum == null) {
            try {
                this.cache.writeLock((Object)key);
                datum = (Datum)this.cache.peek((Object)key);
                if (datum == null) {
                    datum = this.datumAuthority.createDatum(code);
                    this.cache.put((Object)key, (Object)datum);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        String key = this.toKey(code);
        Ellipsoid ellipsoid = (Ellipsoid)this.cache.get((Object)key);
        if (ellipsoid == null) {
            try {
                this.cache.writeLock((Object)key);
                ellipsoid = (Ellipsoid)this.cache.peek((Object)key);
                if (ellipsoid == null) {
                    ellipsoid = this.datumAuthority.createEllipsoid(code);
                    this.cache.put((Object)key, (Object)ellipsoid);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return ellipsoid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        String key = this.toKey(code);
        EngineeringDatum datum = (EngineeringDatum)this.cache.get((Object)key);
        if (datum == null) {
            try {
                this.cache.writeLock((Object)key);
                datum = (EngineeringDatum)this.cache.peek((Object)key);
                if (datum == null) {
                    datum = this.datumAuthority.createEngineeringDatum(code);
                    this.cache.put((Object)key, (Object)datum);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        String key = this.toKey(code);
        GeodeticDatum datum = (GeodeticDatum)this.cache.get((Object)key);
        if (datum == null) {
            try {
                this.cache.writeLock((Object)key);
                datum = (GeodeticDatum)this.cache.peek((Object)key);
                if (datum == null) {
                    datum = this.datumAuthority.createGeodeticDatum(code);
                    this.cache.put((Object)key, (Object)datum);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageDatum createImageDatum(String code) throws FactoryException {
        String key = this.toKey(code);
        ImageDatum datum = (ImageDatum)this.cache.get((Object)key);
        if (datum == null) {
            try {
                this.cache.writeLock((Object)key);
                datum = (ImageDatum)this.cache.peek((Object)key);
                if (datum == null) {
                    datum = this.datumAuthority.createImageDatum(code);
                    this.cache.put((Object)key, (Object)datum);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        String key = this.toKey(code);
        PrimeMeridian datum = (PrimeMeridian)this.cache.get((Object)key);
        if (datum == null) {
            try {
                this.cache.writeLock((Object)key);
                datum = (PrimeMeridian)this.cache.peek((Object)key);
                if (datum == null) {
                    datum = this.datumAuthority.createPrimeMeridian(code);
                    this.cache.put((Object)key, (Object)datum);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        String key = this.toKey(code);
        TemporalDatum datum = (TemporalDatum)this.cache.get((Object)key);
        if (datum == null) {
            try {
                this.cache.writeLock((Object)key);
                datum = (TemporalDatum)this.cache.peek((Object)key);
                if (datum == null) {
                    datum = this.datumAuthority.createTemporalDatum(code);
                    this.cache.put((Object)key, (Object)datum);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        String key = this.toKey(code);
        VerticalDatum datum = (VerticalDatum)this.cache.get((Object)key);
        if (datum == null) {
            try {
                this.cache.writeLock((Object)key);
                datum = (VerticalDatum)this.cache.peek((Object)key);
                if (datum == null) {
                    datum = this.datumAuthority.createVerticalDatum(code);
                    this.cache.put((Object)key, (Object)datum);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        String key = this.toKey(code);
        CoordinateOperation operation = (CoordinateOperation)this.cache.get((Object)key);
        if (operation == null) {
            try {
                this.cache.writeLock((Object)key);
                operation = (CoordinateOperation)this.cache.peek((Object)key);
                if (operation == null) {
                    operation = this.operationAuthority.createCoordinateOperation(code);
                    this.cache.put((Object)key, (Object)operation);
                }
            }
            finally {
                this.cache.writeUnLock((Object)key);
            }
        }
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCode, String targetCode) throws FactoryException {
        Object key = ObjectCaches.toKey((Citation)this.getAuthority(), (String)sourceCode, (String)targetCode);
        Set operations = (Set)this.cache.get(key);
        if (operations == null) {
            try {
                this.cache.writeLock(key);
                operations = (Set)this.cache.peek(key);
                if (operations == null) {
                    operations = this.operationAuthority.createFromCoordinateReferenceSystemCodes(sourceCode, targetCode);
                    this.cache.put(key, (Object)operations);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return operations;
    }

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> type) throws FactoryException {
        return this.delegate.getIdentifiedObjectFinder(type);
    }

    @Override
    public void dispose() throws FactoryException {
        this.delegate.dispose();
        this.cache.clear();
        this.cache = null;
        this.delegate = null;
    }

    @Override
    public String getBackingStoreDescription() throws FactoryException {
        return this.delegate.getBackingStoreDescription();
    }
}

