/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import javax.measure.Unit;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.TransformedAuthorityFactory;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.Hints;
import si.uom.NonSI;
import si.uom.SI;
import systems.uom.common.USCustomary;

public class OrderedAxisCRSAuthorityFactory
extends TransformedAuthorityFactory
implements CRSAuthorityFactory,
Comparator<CoordinateSystemAxis> {
    private static final AxisDirection[] DEFAULT_ORDER = new AxisDirection[]{AxisDirection.EAST, AxisDirection.EAST_NORTH_EAST, AxisDirection.NORTH_EAST, AxisDirection.NORTH_NORTH_EAST, AxisDirection.NORTH, AxisDirection.UP, AxisDirection.GEOCENTRIC_X, AxisDirection.GEOCENTRIC_Y, AxisDirection.GEOCENTRIC_Z, AxisDirection.COLUMN_POSITIVE, AxisDirection.ROW_POSITIVE, AxisDirection.DISPLAY_RIGHT, AxisDirection.DISPLAY_UP, AxisDirection.FUTURE};
    protected final int[] directionRanks;
    protected final boolean forceStandardDirections;
    protected final boolean forceStandardUnits;

    public OrderedAxisCRSAuthorityFactory(String authority, Hints userHints, AxisDirection ... axisOrder) throws FactoryRegistryException, IllegalArgumentException {
        super(authority, userHints);
        this.forceStandardUnits = OrderedAxisCRSAuthorityFactory.booleanValue(userHints, Hints.FORCE_STANDARD_AXIS_UNITS);
        this.forceStandardDirections = OrderedAxisCRSAuthorityFactory.booleanValue(userHints, Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        this.directionRanks = OrderedAxisCRSAuthorityFactory.computeDirectionRanks(axisOrder);
        this.completeHints();
    }

    public OrderedAxisCRSAuthorityFactory(AbstractAuthorityFactory factory, Hints userHints, AxisDirection ... axisOrder) throws IllegalArgumentException {
        super(factory);
        this.forceStandardUnits = OrderedAxisCRSAuthorityFactory.booleanValue(userHints, Hints.FORCE_STANDARD_AXIS_UNITS);
        this.forceStandardDirections = OrderedAxisCRSAuthorityFactory.booleanValue(userHints, Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        this.directionRanks = OrderedAxisCRSAuthorityFactory.computeDirectionRanks(axisOrder);
        this.completeHints();
    }

    protected static boolean booleanValue(Hints userHints, Hints.Key key) {
        Boolean value;
        if (userHints != null && (value = (Boolean)userHints.get((Object)key)) != null) {
            return value;
        }
        return false;
    }

    protected static int[] computeDirectionRanks(AxisDirection ... axisOrder) throws IllegalArgumentException {
        if (axisOrder == null || axisOrder.length == 0) {
            axisOrder = DEFAULT_ORDER;
        }
        int length = 0;
        for (AxisDirection axisDirection : axisOrder) {
            int ordinal = axisDirection.absolute().ordinal() + 1;
            if (ordinal <= length) continue;
            length = ordinal;
        }
        int[] directionRanks = new int[length];
        Arrays.fill(directionRanks, length);
        int i = 0;
        while (i < axisOrder.length) {
            int ordinal = axisOrder[i].absolute().ordinal();
            int previous = directionRanks[ordinal];
            if (previous != length) {
                throw new IllegalArgumentException(MessageFormat.format("Axis {0} and {1} are colinear.", axisOrder[previous].name(), axisOrder[i].name()));
            }
            directionRanks[ordinal] = i++;
        }
        return directionRanks;
    }

    protected void completeHints() {
        this.hints.put(Hints.FORCE_STANDARD_AXIS_UNITS, this.forceStandardUnits);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, this.forceStandardDirections);
        if (this.compare(DefaultCoordinateSystemAxis.EASTING, DefaultCoordinateSystemAxis.NORTHING) < 0) {
            this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE);
        }
    }

    private final int rank(CoordinateSystemAxis axis) {
        int c = axis.getDirection().absolute().ordinal();
        c = c >= 0 && c < this.directionRanks.length ? this.directionRanks[c] : this.directionRanks.length;
        return c;
    }

    @Override
    public int compare(CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) {
        int r1 = this.rank(axis1);
        int r2 = this.rank(axis2);
        if (r1 >= this.directionRanks.length && r2 >= this.directionRanks.length) {
            String abb1 = axis1.getAbbreviation();
            String abb2 = axis2.getAbbreviation();
            if (abb1.equals(DefaultCoordinateSystemAxis.NORTHING.getAbbreviation()) && abb2.equals(DefaultCoordinateSystemAxis.EASTING.getAbbreviation())) {
                return 1;
            }
            if (abb1.equals(DefaultCoordinateSystemAxis.EASTING.getAbbreviation()) && abb2.equals(DefaultCoordinateSystemAxis.NORTHING.getAbbreviation())) {
                return -1;
            }
        }
        return r1 - r2;
    }

    @Override
    public Unit<?> replace(Unit<?> units) {
        if (this.forceStandardUnits) {
            if (units.isCompatible(SI.METRE)) {
                return SI.METRE;
            }
            if (units.equals((Object)SI.RADIAN) || units.equals((Object)USCustomary.GRADE)) {
                return NonSI.DEGREE_ANGLE;
            }
        }
        return units;
    }

    @Override
    protected AxisDirection replace(AxisDirection direction) {
        return this.forceStandardDirections ? direction.absolute() : direction;
    }
}

