/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.metadata.extent.Extent;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.referencing.AuthorityFactory;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.CompoundCRS;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.DerivedCRS;
import org.geotools.api.referencing.crs.EngineeringCRS;
import org.geotools.api.referencing.crs.GeocentricCRS;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.ImageCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.crs.TemporalCRS;
import org.geotools.api.referencing.crs.VerticalCRS;
import org.geotools.api.referencing.cs.CSAuthorityFactory;
import org.geotools.api.referencing.cs.CartesianCS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.cs.CylindricalCS;
import org.geotools.api.referencing.cs.EllipsoidalCS;
import org.geotools.api.referencing.cs.PolarCS;
import org.geotools.api.referencing.cs.SphericalCS;
import org.geotools.api.referencing.cs.TimeCS;
import org.geotools.api.referencing.cs.VerticalCS;
import org.geotools.api.referencing.datum.Datum;
import org.geotools.api.referencing.datum.DatumAuthorityFactory;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.datum.EngineeringDatum;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.api.referencing.datum.ImageDatum;
import org.geotools.api.referencing.datum.PrimeMeridian;
import org.geotools.api.referencing.datum.TemporalDatum;
import org.geotools.api.referencing.datum.VerticalDatum;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.CoordinateOperationAuthorityFactory;
import org.geotools.api.referencing.operation.OperationMethod;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.OldReferencingObjectCache;
import org.geotools.util.Utilities;
import org.geotools.util.factory.BufferedFactory;
import org.geotools.util.factory.Hints;

public class ThreadedAuthorityFactory
extends AbstractAuthorityFactory
implements BufferedFactory {
    static final int DEFAULT_MAX = 20;
    AbstractAuthorityFactory backingStore;
    private final OldReferencingObjectCache objectCache;
    private final Map<IdentifiedObject, IdentifiedObject> findPool = new WeakHashMap<IdentifiedObject, IdentifiedObject>();

    protected ThreadedAuthorityFactory(AbstractAuthorityFactory factory) {
        this(factory, 20);
    }

    protected ThreadedAuthorityFactory(AbstractAuthorityFactory factory, int maxStrongReferences) {
        super(factory.getPriority());
        while (factory instanceof ThreadedAuthorityFactory) {
            factory = ((ThreadedAuthorityFactory)factory).backingStore;
        }
        this.backingStore = factory;
        this.objectCache = new OldReferencingObjectCache(maxStrongReferences);
        this.completeHints();
    }

    ThreadedAuthorityFactory(int priority, int maxStrongReferences) {
        super(priority);
        this.objectCache = new OldReferencingObjectCache(maxStrongReferences);
    }

    final void completeHints() {
        if (this.backingStore instanceof DatumAuthorityFactory) {
            this.hints.put(Hints.DATUM_AUTHORITY_FACTORY, this.backingStore);
        }
        if (this.backingStore instanceof CSAuthorityFactory) {
            this.hints.put(Hints.CS_AUTHORITY_FACTORY, this.backingStore);
        }
        if (this.backingStore instanceof CRSAuthorityFactory) {
            this.hints.put(Hints.CRS_AUTHORITY_FACTORY, this.backingStore);
        }
        if (this.backingStore instanceof CoordinateOperationAuthorityFactory) {
            this.hints.put(Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, this.backingStore);
        }
    }

    @Override
    Collection<? super AuthorityFactory> dependencies() {
        Object factory;
        try {
            factory = this.getBackingStore();
        }
        catch (FactoryException e) {
            factory = e;
        }
        return Collections.singleton(factory);
    }

    AbstractAuthorityFactory getBackingStore() throws FactoryException {
        if (this.backingStore == null) {
            throw new FactoryException("The factory has been disposed.");
        }
        return this.backingStore;
    }

    @Override
    boolean isAvailable() {
        try {
            return this.getBackingStore().isAvailable();
        }
        catch (FactoryNotFoundException factoryNotFoundException) {
        }
        catch (FactoryException exception) {
            Citation citation = this.getAuthority();
            Collection titles = citation.getAlternateTitles();
            InternationalString title = citation.getTitle();
            if (titles != null) {
                for (Object o : titles) {
                    InternationalString candidate = (InternationalString)o;
                    if (candidate.length() <= title.length()) continue;
                    title = candidate;
                }
            }
            LogRecord record = Loggings.format((Level)Level.WARNING, (int)42, (Object)title);
            record.setSourceClassName(((Object)((Object)this)).getClass().getName());
            record.setSourceMethodName("isAvailable");
            record.setThrown(exception);
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
        }
        return false;
    }

    @Override
    boolean sameAuthorityCodes(AuthorityFactory factory) {
        AbstractAuthorityFactory backingStore = this.backingStore;
        if (backingStore != null && backingStore.sameAuthorityCodes(factory)) {
            return true;
        }
        return super.sameAuthorityCodes(factory);
    }

    @Override
    public Citation getVendor() {
        return this.backingStore != null ? this.backingStore.getVendor() : super.getVendor();
    }

    @Override
    public Citation getAuthority() {
        return this.backingStore != null ? this.backingStore.getAuthority() : null;
    }

    @Override
    public String getBackingStoreDescription() throws FactoryException {
        return this.getBackingStore().getBackingStoreDescription();
    }

    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        return this.getBackingStore().getAuthorityCodes(type);
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        return this.getBackingStore().getDescriptionText(code);
    }

    @Override
    public synchronized IdentifiedObject createObject(String code) throws FactoryException {
        IdentifiedObject identifiedObject;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        IdentifiedObject object = cached instanceof IdentifiedObject ? (identifiedObject = (IdentifiedObject)cached) : this.getBackingStore().createObject(code);
        this.objectCache.put(key, object);
        return object;
    }

    @Override
    public synchronized Datum createDatum(String code) throws FactoryException {
        Datum datum1;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        Datum datum = cached instanceof Datum ? (datum1 = (Datum)cached) : this.getBackingStore().createDatum(code);
        this.objectCache.put(key, datum);
        return datum;
    }

    @Override
    public synchronized EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        EngineeringDatum engineeringDatum;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        EngineeringDatum datum = cached instanceof EngineeringDatum ? (engineeringDatum = (EngineeringDatum)cached) : this.getBackingStore().createEngineeringDatum(code);
        this.objectCache.put(key, datum);
        return datum;
    }

    @Override
    public synchronized ImageDatum createImageDatum(String code) throws FactoryException {
        ImageDatum imageDatum;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        ImageDatum datum = cached instanceof ImageDatum ? (imageDatum = (ImageDatum)cached) : this.getBackingStore().createImageDatum(code);
        this.objectCache.put(key, datum);
        return datum;
    }

    @Override
    public synchronized VerticalDatum createVerticalDatum(String code) throws FactoryException {
        VerticalDatum verticalDatum;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        VerticalDatum datum = cached instanceof VerticalDatum ? (verticalDatum = (VerticalDatum)cached) : this.getBackingStore().createVerticalDatum(code);
        this.objectCache.put(key, datum);
        return datum;
    }

    @Override
    public synchronized TemporalDatum createTemporalDatum(String code) throws FactoryException {
        TemporalDatum temporalDatum;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        TemporalDatum datum = cached instanceof TemporalDatum ? (temporalDatum = (TemporalDatum)cached) : this.getBackingStore().createTemporalDatum(code);
        this.objectCache.put(key, datum);
        return datum;
    }

    @Override
    public synchronized GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        GeodeticDatum geodeticDatum;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        GeodeticDatum datum = cached instanceof GeodeticDatum ? (geodeticDatum = (GeodeticDatum)cached) : this.getBackingStore().createGeodeticDatum(code);
        this.objectCache.put(key, datum);
        return datum;
    }

    @Override
    public synchronized Ellipsoid createEllipsoid(String code) throws FactoryException {
        Ellipsoid ellipsoid1;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        Ellipsoid ellipsoid = cached instanceof Ellipsoid ? (ellipsoid1 = (Ellipsoid)cached) : this.getBackingStore().createEllipsoid(code);
        this.objectCache.put(key, ellipsoid);
        return ellipsoid;
    }

    @Override
    public synchronized PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        PrimeMeridian primeMeridian;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        PrimeMeridian meridian = cached instanceof PrimeMeridian ? (primeMeridian = (PrimeMeridian)cached) : this.getBackingStore().createPrimeMeridian(code);
        this.objectCache.put(key, meridian);
        return meridian;
    }

    @Override
    public synchronized Extent createExtent(String code) throws FactoryException {
        Extent extent1;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        Extent extent = cached instanceof Extent ? (extent1 = (Extent)cached) : this.getBackingStore().createExtent(code);
        this.objectCache.put(key, extent);
        return extent;
    }

    @Override
    public synchronized CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        CoordinateSystem system;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        CoordinateSystem cs = cached instanceof CoordinateSystem ? (system = (CoordinateSystem)cached) : this.getBackingStore().createCoordinateSystem(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized CartesianCS createCartesianCS(String code) throws FactoryException {
        CartesianCS cS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        CartesianCS cs = cached instanceof CartesianCS ? (cS = (CartesianCS)cached) : this.getBackingStore().createCartesianCS(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized PolarCS createPolarCS(String code) throws FactoryException {
        PolarCS cS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        PolarCS cs = cached instanceof PolarCS ? (cS = (PolarCS)cached) : this.getBackingStore().createPolarCS(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized CylindricalCS createCylindricalCS(String code) throws FactoryException {
        CylindricalCS cS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        CylindricalCS cs = cached instanceof CylindricalCS ? (cS = (CylindricalCS)cached) : this.getBackingStore().createCylindricalCS(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized SphericalCS createSphericalCS(String code) throws FactoryException {
        SphericalCS cS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        SphericalCS cs = cached instanceof SphericalCS ? (cS = (SphericalCS)cached) : this.getBackingStore().createSphericalCS(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        EllipsoidalCS cS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        EllipsoidalCS cs = cached instanceof EllipsoidalCS ? (cS = (EllipsoidalCS)cached) : this.getBackingStore().createEllipsoidalCS(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized VerticalCS createVerticalCS(String code) throws FactoryException {
        VerticalCS cS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        VerticalCS cs = cached instanceof VerticalCS ? (cS = (VerticalCS)cached) : this.getBackingStore().createVerticalCS(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized TimeCS createTimeCS(String code) throws FactoryException {
        TimeCS cS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        TimeCS cs = cached instanceof TimeCS ? (cS = (TimeCS)cached) : this.getBackingStore().createTimeCS(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        CoordinateSystemAxis systemAxis;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        CoordinateSystemAxis axis = cached instanceof CoordinateSystemAxis ? (systemAxis = (CoordinateSystemAxis)cached) : this.getBackingStore().createCoordinateSystemAxis(code);
        this.objectCache.put(key, axis);
        return axis;
    }

    @Override
    public synchronized Unit<?> createUnit(String code) throws FactoryException {
        Unit<?> unit1;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        Unit<?> unit = cached instanceof Unit ? (unit1 = (Unit<?>)cached) : this.getBackingStore().createUnit(code);
        this.objectCache.put(key, unit);
        return unit;
    }

    @Override
    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        CoordinateReferenceSystem crs;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        if (cached instanceof CoordinateReferenceSystem) {
            CoordinateReferenceSystem system;
            crs = system = (CoordinateReferenceSystem)cached;
        } else {
            crs = this.getBackingStore().createCoordinateReferenceSystem(code);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Created CRS with code:" + code + "\n" + String.valueOf(crs));
            }
        }
        LOGGER.fine(() -> "Using CRS[" + String.valueOf(crs.getName()) + "] for code:" + code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized CompoundCRS createCompoundCRS(String code) throws FactoryException {
        CompoundCRS rS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        CompoundCRS crs = cached instanceof CompoundCRS ? (rS = (CompoundCRS)cached) : this.getBackingStore().createCompoundCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized DerivedCRS createDerivedCRS(String code) throws FactoryException {
        DerivedCRS rS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        DerivedCRS crs = cached instanceof DerivedCRS ? (rS = (DerivedCRS)cached) : this.getBackingStore().createDerivedCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        EngineeringCRS rS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        EngineeringCRS crs = cached instanceof EngineeringCRS ? (rS = (EngineeringCRS)cached) : this.getBackingStore().createEngineeringCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized GeographicCRS createGeographicCRS(String code) throws FactoryException {
        GeographicCRS rS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        GeographicCRS crs = cached instanceof GeographicCRS ? (rS = (GeographicCRS)cached) : this.getBackingStore().createGeographicCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        GeocentricCRS rS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        GeocentricCRS crs = cached instanceof GeocentricCRS ? (rS = (GeocentricCRS)cached) : this.getBackingStore().createGeocentricCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized ImageCRS createImageCRS(String code) throws FactoryException {
        ImageCRS rS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        ImageCRS crs = cached instanceof ImageCRS ? (rS = (ImageCRS)cached) : this.getBackingStore().createImageCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        ProjectedCRS rS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        ProjectedCRS crs = cached instanceof ProjectedCRS ? (rS = (ProjectedCRS)cached) : this.getBackingStore().createProjectedCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized TemporalCRS createTemporalCRS(String code) throws FactoryException {
        TemporalCRS rS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        TemporalCRS crs = cached instanceof TemporalCRS ? (rS = (TemporalCRS)cached) : this.getBackingStore().createTemporalCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized VerticalCRS createVerticalCRS(String code) throws FactoryException {
        VerticalCRS rS;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        VerticalCRS crs = cached instanceof VerticalCRS ? (rS = (VerticalCRS)cached) : this.getBackingStore().createVerticalCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized ParameterDescriptor createParameterDescriptor(String code) throws FactoryException {
        ParameterDescriptor descriptor;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        ParameterDescriptor parameter = cached instanceof ParameterDescriptor ? (descriptor = (ParameterDescriptor)cached) : this.getBackingStore().createParameterDescriptor(code);
        this.objectCache.put(key, parameter);
        return parameter;
    }

    @Override
    public synchronized OperationMethod createOperationMethod(String code) throws FactoryException {
        OperationMethod operationMethod;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        OperationMethod method = cached instanceof OperationMethod ? (operationMethod = (OperationMethod)cached) : this.getBackingStore().createOperationMethod(code);
        this.objectCache.put(key, method);
        return method;
    }

    @Override
    public synchronized CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        CoordinateOperation coordinateOperation;
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        CoordinateOperation operation = cached instanceof CoordinateOperation ? (coordinateOperation = (CoordinateOperation)cached) : this.getBackingStore().createCoordinateOperation(code);
        this.objectCache.put(key, operation);
        return operation;
    }

    @Override
    public synchronized Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCode, String targetCode) throws FactoryException {
        CodePair key = new CodePair(this.trimAuthority(sourceCode), this.trimAuthority(targetCode));
        Object cached = this.objectCache.get(key);
        Set<CoordinateOperation> operations = cached instanceof CoordinateOperation ? (Set<CoordinateOperation>)cached : Collections.unmodifiableSet(this.getBackingStore().createFromCoordinateReferenceSystemCodes(sourceCode, targetCode));
        this.objectCache.put(key, operations);
        return operations;
    }

    @Override
    public synchronized IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> type) throws FactoryException {
        return new Finder(this.getBackingStore().getIdentifiedObjectFinder(type));
    }

    @Override
    public synchronized void dispose() throws FactoryException {
        if (this.backingStore != null) {
            this.backingStore.dispose();
            this.backingStore = null;
        }
        this.objectCache.clear();
        super.dispose();
    }

    private static final class CodePair {
        private final String source;
        private final String target;

        public CodePair(String source, String target) {
            this.source = source;
            this.target = target;
        }

        public int hashCode() {
            int code = 0;
            if (this.source != null) {
                code = this.source.hashCode();
            }
            if (this.target != null) {
                code += this.target.hashCode() * 37;
            }
            return code;
        }

        public boolean equals(Object other) {
            if (other instanceof CodePair) {
                CodePair that = (CodePair)other;
                return Utilities.equals((Object)this.source, (Object)that.source) && Utilities.equals((Object)this.target, (Object)that.target);
            }
            return false;
        }

        public String toString() {
            return this.source + " \u21e8 " + this.target;
        }
    }

    private final class Finder
    extends IdentifiedObjectFinder.Adapter {
        Finder(IdentifiedObjectFinder finder) {
            super(finder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IdentifiedObject find(IdentifiedObject object) throws FactoryException {
            IdentifiedObject candidate;
            Map<IdentifiedObject, IdentifiedObject> map = ThreadedAuthorityFactory.this.findPool;
            synchronized (map) {
                candidate = ThreadedAuthorityFactory.this.findPool.get(object);
            }
            if (candidate == null && (candidate = this.finder.find(object)) != null) {
                map = ThreadedAuthorityFactory.this.findPool;
                synchronized (map) {
                    ThreadedAuthorityFactory.this.findPool.put(object, candidate);
                }
            }
            return candidate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String findIdentifier(IdentifiedObject object) throws FactoryException {
            IdentifiedObject candidate;
            Map<IdentifiedObject, IdentifiedObject> map = ThreadedAuthorityFactory.this.findPool;
            synchronized (map) {
                candidate = ThreadedAuthorityFactory.this.findPool.get(object);
            }
            if (candidate != null) {
                return this.getIdentifier(candidate);
            }
            return this.finder.findIdentifier(object);
        }
    }
}

