/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.InvalidParameterNameException;
import org.geotools.api.parameter.InvalidParameterValueException;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.Operation;
import org.geotools.api.referencing.operation.OperationMethod;
import org.geotools.api.referencing.operation.Projection;
import org.geotools.api.util.GenericName;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.Parameters;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.transform.MathTransformProxy;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.XArray;

public abstract class MathTransformProvider
extends DefaultOperationMethod {
    private static final long serialVersionUID = 7530475536803158473L;

    public MathTransformProvider(int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters) {
        this(MathTransformProvider.toMap((IdentifiedObject)parameters), sourceDimensions, targetDimensions, parameters);
    }

    public MathTransformProvider(Map<String, ?> properties, int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters) {
        super(properties, sourceDimensions, targetDimensions, parameters);
    }

    private static Map<String, Object> toMap(IdentifiedObject parameters) {
        MathTransformProvider.ensureNonNull("parameters", parameters);
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", parameters.getName());
        properties.put("identifiers", parameters.getIdentifiers().toArray(EMPTY_IDENTIFIER_ARRAY));
        properties.put("alias", parameters.getAlias().toArray(EMPTY_ALIAS_ARRAY));
        return properties;
    }

    @Override
    public Class<? extends Operation> getOperationType() {
        return Operation.class;
    }

    protected abstract MathTransform createMathTransform(ParameterValueGroup var1) throws InvalidParameterNameException, ParameterNotFoundException, InvalidParameterValueException, FactoryException;

    protected static ParameterDescriptor<Double> createDescriptor(ReferenceIdentifier[] identifiers, double defaultValue, double minimum, double maximum, Unit<?> unit) {
        return DefaultParameterDescriptor.create(MathTransformProvider.toMap(identifiers), defaultValue, minimum, maximum, unit, true);
    }

    protected static ParameterDescriptor<Double> createOptionalDescriptor(ReferenceIdentifier[] identifiers, double minimum, double maximum, Unit<?> unit) {
        return DefaultParameterDescriptor.create(MathTransformProvider.toMap(identifiers), Double.NaN, minimum, maximum, unit, false);
    }

    protected static ParameterDescriptorGroup createDescriptorGroup(ReferenceIdentifier[] identifiers, GeneralParameterDescriptor[] parameters) {
        return new DefaultParameterDescriptorGroup(MathTransformProvider.toMap(identifiers), parameters);
    }

    protected static Map<String, Object> toMap(ReferenceIdentifier ... identifiers) {
        MathTransformProvider.ensureNonNull("identifiers", identifiers);
        if (identifiers.length == 0) {
            throw new IllegalArgumentException("The array should contains at least one element.");
        }
        int idCount = 0;
        int aliasCount = 0;
        Object[] id = new ReferenceIdentifier[identifiers.length];
        Object[] alias = new GenericName[identifiers.length];
        for (ReferenceIdentifier candidate : identifiers) {
            if (candidate instanceof GenericName) {
                GenericName name = (GenericName)candidate;
                alias[aliasCount++] = name;
                continue;
            }
            id[idCount++] = candidate;
        }
        id = (ReferenceIdentifier[])XArray.resize((Object[])id, (int)idCount);
        alias = (GenericName[])XArray.resize((Object[])alias, (int)aliasCount);
        HashMap<String, Object> properties = new HashMap<String, Object>(4, 0.8f);
        properties.put("name", identifiers[0]);
        properties.put("identifiers", id);
        properties.put("alias", alias);
        return properties;
    }

    protected ParameterValueGroup ensureValidValues(ParameterValueGroup values) throws InvalidParameterNameException, InvalidParameterValueException {
        ParameterDescriptorGroup descriptor;
        ParameterDescriptorGroup parameters = this.getParameters();
        if (parameters.equals(descriptor = values.getDescriptor())) {
            return values;
        }
        ParameterValueGroup copy = parameters.createValue();
        MathTransformProvider.copy(values, copy);
        return copy;
    }

    private static void copy(ParameterValueGroup values, ParameterValueGroup copy) throws InvalidParameterNameException, InvalidParameterValueException {
        for (GeneralParameterValue value : values.values()) {
            ParameterValue target;
            String name = value.getDescriptor().getName().getCode();
            if (value instanceof ParameterValueGroup) {
                GeneralParameterDescriptor descriptor = copy.getDescriptor().descriptor(name);
                if (descriptor instanceof ParameterDescriptorGroup) {
                    ParameterValueGroup groups = (ParameterValueGroup)descriptor.createValue();
                    MathTransformProvider.copy((ParameterValueGroup)value, groups);
                    values.groups(name).add(groups);
                    continue;
                }
                throw new InvalidParameterNameException(MessageFormat.format("Parameter \"{0}\" was not expected.", name), name);
            }
            ParameterValue source = (ParameterValue)value;
            try {
                target = copy.parameter(name);
            }
            catch (ParameterNotFoundException cause) {
                InvalidParameterNameException exception = new InvalidParameterNameException(MessageFormat.format("Parameter \"{0}\" was not expected.", name), name);
                exception.initCause((Throwable)cause);
                throw exception;
            }
            Object v = source.getValue();
            Unit unit = source.getUnit();
            if (unit == null) {
                target.setValue(v);
                continue;
            }
            if (v instanceof Number) {
                Number number = (Number)v;
                target.setValue(number.doubleValue(), unit);
                continue;
            }
            if (v instanceof double[]) {
                double[] doubles = (double[])v;
                target.setValue(doubles, unit);
                continue;
            }
            throw new InvalidParameterValueException(MessageFormat.format("Illegal argument: \"{0}={1}\".", name, v), name, v);
        }
    }

    protected static <T> ParameterValue<T> getParameter(ParameterDescriptor<T> param, ParameterValueGroup group) throws ParameterNotFoundException {
        String name = MathTransformProvider.getName(param, group.getDescriptor().getName().getAuthority());
        if (name == null) {
            name = param.getName().getCode();
        }
        if (param.getMinimumOccurs() != 0) {
            return Parameters.cast(group.parameter(name), param.getValueClass());
        }
        GeneralParameterDescriptor search = group.getDescriptor().descriptor(name);
        if (search instanceof ParameterDescriptor) {
            for (GeneralParameterValue candidate : group.values()) {
                if (!search.equals(candidate.getDescriptor())) continue;
                return Parameters.cast((ParameterValue)candidate, param.getValueClass());
            }
        }
        return null;
    }

    protected static <T> T value(ParameterDescriptor<T> param, ParameterValueGroup group) throws ParameterNotFoundException {
        ParameterValue<T> value = MathTransformProvider.getParameter(param, group);
        return (T)(value != null ? value.getValue() : null);
    }

    protected static String stringValue(ParameterDescriptor<?> param, ParameterValueGroup group) throws ParameterNotFoundException {
        ParameterValue<?> value = MathTransformProvider.getParameter(param, group);
        return value != null ? value.stringValue() : null;
    }

    protected static int intValue(ParameterDescriptor<?> param, ParameterValueGroup group) throws ParameterNotFoundException {
        ParameterValue<?> value = MathTransformProvider.getParameter(param, group);
        return value != null ? value.intValue() : 0;
    }

    protected static double doubleValue(ParameterDescriptor<?> param, ParameterValueGroup group) throws ParameterNotFoundException {
        Unit unit = param.getUnit();
        ParameterValue<?> value = MathTransformProvider.getParameter(param, group);
        return value == null ? Double.NaN : (unit != null ? value.doubleValue(unit) : value.doubleValue());
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        Class<? extends Operation> type = this.getOperationType();
        if (Projection.class.isAssignableFrom(type)) {
            return super.formatWKT(formatter);
        }
        formatter.setInvalidWKT(OperationMethod.class);
        return "OperationMethod";
    }

    protected static final class Delegate
    extends MathTransformProxy {
        private static final long serialVersionUID = -3942740060970730790L;
        public final OperationMethod method;

        public Delegate(MathTransform transform, OperationMethod method) {
            super(transform);
            this.method = method;
            MathTransformProvider.ensureNonNull("transform", transform);
            MathTransformProvider.ensureNonNull("method", method);
        }
    }
}

