/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.MismatchedReferenceSystemException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.geometry.GeneralBounds;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.AffineTransformBuilder;
import org.geotools.referencing.operation.builder.MapTriangulationFactory;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.geotools.referencing.operation.builder.MathTransformBuilder;
import org.geotools.referencing.operation.builder.Quadrilateral;
import org.geotools.referencing.operation.builder.RubberSheetTransform;
import org.geotools.referencing.operation.builder.TINTriangle;
import org.geotools.referencing.operation.builder.TriangulationException;

public class RubberSheetBuilder
extends MathTransformBuilder {
    private HashMap<TINTriangle, Object> trianglesMap;
    private Map<TINTriangle, Object> trianglesToKeysMap;

    public RubberSheetBuilder(List<MappedPosition> vectors, List<Position> vertices) throws IllegalArgumentException, MismatchedDimensionException, MismatchedReferenceSystemException, TriangulationException {
        CoordinateReferenceSystem crs;
        super.setMappedPositions(vectors);
        if (vertices.size() != 4) {
            throw new IllegalArgumentException("The region of interest must have four vertices.");
        }
        Position[] ddpp = new Position[4];
        for (int i = 0; i < vertices.size(); ++i) {
            ddpp[i] = vertices.get(i);
        }
        try {
            crs = this.getSourceCRS();
        }
        catch (FactoryException e) {
            crs = ddpp[0].getCoordinateReferenceSystem();
        }
        if (!(CRS.equalsIgnoreMetadata(crs, ddpp[0].getCoordinateReferenceSystem()) || CRS.equalsIgnoreMetadata(crs, ddpp[1].getCoordinateReferenceSystem()) || CRS.equalsIgnoreMetadata(crs, ddpp[2].getCoordinateReferenceSystem()) || CRS.equalsIgnoreMetadata(crs, ddpp[3].getCoordinateReferenceSystem()))) {
            throw new MismatchedReferenceSystemException("Region of interest defined by mismatched DirectPositions.");
        }
        Position[] dpa = this.getSourcePoints();
        GeneralBounds srcextnt = new GeneralBounds(2);
        for (Position directPosition : dpa) {
            srcextnt.add(directPosition);
        }
        GeneralBounds vtxextnt = new GeneralBounds(2);
        vtxextnt.add(ddpp[0]);
        vtxextnt.add(ddpp[1]);
        vtxextnt.add(ddpp[2]);
        vtxextnt.add(ddpp[3]);
        if (!vtxextnt.contains(srcextnt, true)) {
            throw new IllegalArgumentException("The region of interest must contain the control points");
        }
        Quadrilateral quad = new Quadrilateral(ddpp[0], ddpp[1], ddpp[2], ddpp[3]);
        MapTriangulationFactory trianglemap = new MapTriangulationFactory(quad, vectors);
        this.trianglesMap = trianglemap.getTriangleMap();
        this.trianglesToKeysMap = this.mapTrianglesToKey();
    }

    @Override
    public int getMinimumPointCount() {
        return 1;
    }

    public Map<TINTriangle, Object> getMapTriangulation() {
        return this.trianglesMap;
    }

    @Override
    protected MathTransform computeMathTransform() throws FactoryException {
        return new RubberSheetTransform(this.trianglesToKeysMap);
    }

    private Map<TINTriangle, Object> mapTrianglesToKey() {
        HashMap trianglesToKeysMap = (HashMap)this.trianglesMap.clone();
        for (Map.Entry entry : trianglesToKeysMap.entrySet()) {
            ArrayList<MappedPosition> pts = new ArrayList<MappedPosition>();
            for (int i = 1; i <= 3; ++i) {
                pts.add(new MappedPosition(((TINTriangle)entry.getKey()).getPoints()[i], ((TINTriangle)entry.getValue()).getPoints()[i]));
            }
            try {
                AffineTransformBuilder calculator = new AffineTransformBuilder(pts);
                entry.setValue(calculator.getMathTransform());
            }
            catch (Exception e) {
                Logger.getGlobal().log(Level.INFO, "", e);
            }
        }
        return trianglesToKeysMap;
    }
}

