/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.Mollweide;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.referencing.operation.projection.Sinusoidal;

public class Homolosine
extends MapProjection {
    private static final long serialVersionUID = 4740760391570944118L;
    private static double LAT_THRESH = Math.toRadians(40.73661111111111);
    private static final double[] INTERRUP_NORTH = new double[]{Math.toRadians(-180.0), Math.toRadians(-40.0), Math.toRadians(180.0)};
    private static final double[] INTERRUP_SOUTH = new double[]{Math.toRadians(-180.0), Math.toRadians(-100.0), Math.toRadians(-20.0), Math.toRadians(80.0), Math.toRadians(180.0)};
    private static final double[] CENTRAL_MERID_NORTH = new double[]{Math.toRadians(-100.0), Math.toRadians(30.0)};
    private static final double[] CENTRAL_MERID_SOUTH = new double[]{Math.toRadians(-160.0), Math.toRadians(-60.0), Math.toRadians(20.0), Math.toRadians(140.0)};
    ParameterDescriptorGroup descriptors;
    ParameterValueGroup parameters;
    Mollweide moll;
    Sinusoidal sinu;

    protected Homolosine(ParameterDescriptorGroup descriptors, ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters, descriptors.descriptors());
        this.descriptors = descriptors;
        this.parameters = parameters;
        this.sinu = new Sinusoidal(this.parameters);
        this.moll = new Mollweide(Mollweide.ProjectionMode.Mollweide, this.descriptors, this.parameters);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    protected double computeOffset() throws ProjectionException {
        Point2D moll_tresh = this.moll.transformNormalized(0.0, LAT_THRESH, null);
        return moll_tresh.getY() - LAT_THRESH;
    }

    protected double wrapLongitude(double lam) throws ProjectionException {
        if (lam > Math.PI) {
            double quoc = lam / Math.PI;
            return -Math.PI + (quoc - Math.floor(quoc)) * Math.PI;
        }
        if (lam < -Math.PI) {
            double quoc = Math.abs(lam / Math.PI);
            return Math.PI - (quoc - Math.floor(quoc)) * Math.PI;
        }
        return lam;
    }

    protected double wrapLatitude(double phi) throws ProjectionException {
        double halfPI = 1.5707963267948966;
        if (phi > halfPI) {
            double quoc = phi / halfPI;
            return halfPI - (quoc - Math.floor(quoc)) * halfPI;
        }
        if (phi < -halfPI) {
            double quoc = Math.abs(phi / halfPI);
            return halfPI + (quoc - Math.floor(quoc)) * halfPI;
        }
        return phi;
    }

    @Override
    protected Point2D transformNormalized(double lam, double phi, Point2D ptDst) throws ProjectionException {
        Point2D p;
        double[] central_merids;
        double[] interruptions;
        double offset = this.computeOffset();
        int i = 0;
        lam = this.wrapLongitude(lam);
        if ((phi = this.wrapLatitude(phi)) >= 0.0) {
            interruptions = INTERRUP_NORTH;
            central_merids = CENTRAL_MERID_NORTH;
        } else {
            interruptions = INTERRUP_SOUTH;
            central_merids = CENTRAL_MERID_SOUTH;
            offset = -offset;
        }
        if (lam >= interruptions[interruptions.length - 1]) {
            i = interruptions.length - 1;
        } else {
            while (lam >= interruptions[i]) {
                ++i;
            }
        }
        double central_merid = central_merids[i - 1];
        double lam_shift = lam - central_merid;
        if (phi > LAT_THRESH || phi < -LAT_THRESH) {
            p = this.moll.transformNormalized(lam_shift, phi, ptDst);
            p.setLocation(p.getX(), p.getY() - offset);
        } else {
            p = new Point2D.Double(lam_shift * Math.cos(phi), phi);
        }
        Point2D shift = this.sinu.transformNormalized(central_merid, 0.0, null);
        p.setLocation(p.getX() + shift.getX(), p.getY());
        if (ptDst != null) {
            ptDst.setLocation(p.getX(), p.getY());
            return ptDst;
        }
        return p;
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double[] interruptions;
        double[] central_merids;
        double offset = this.computeOffset();
        int i = 0;
        double thresh_map = LAT_THRESH;
        if (y >= 0.0) {
            central_merids = CENTRAL_MERID_NORTH;
            interruptions = new double[INTERRUP_NORTH.length];
            for (j = 0; j < INTERRUP_NORTH.length; ++j) {
                interruptions[j] = this.sinu.transformNormalized(INTERRUP_NORTH[j], 0.0, null).getX();
            }
        } else {
            central_merids = CENTRAL_MERID_SOUTH;
            offset = -offset;
            interruptions = new double[INTERRUP_SOUTH.length];
            for (j = 0; j < INTERRUP_SOUTH.length; ++j) {
                interruptions[j] = this.sinu.transformNormalized(INTERRUP_SOUTH[j], 0.0, null).getX();
            }
        }
        if (x >= interruptions[interruptions.length - 1]) {
            i = interruptions.length - 1;
        } else if (x < interruptions[0]) {
            i = 1;
        } else {
            while (x >= interruptions[i]) {
                ++i;
            }
        }
        double central_merid = central_merids[i - 1];
        Point2D shift = this.sinu.transformNormalized(central_merid, 0.0, null);
        Point2D p = y > thresh_map || y < -thresh_map ? this.moll.inverseTransformNormalized(x - shift.getX(), y + offset, ptDst) : new Point2D.Double((x - shift.getX()) / Math.cos(y), y);
        p.setLocation(p.getX() + central_merid, p.getY());
        if (ptDst != null) {
            ptDst.setLocation(p.getX(), p.getY());
            return ptDst;
        }
        return p;
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = -7345885830045627291L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, "Goode_Homolosine"), new NamedIdentifier(Citations.ESRI, "Interrupted_Homolosine"), new NamedIdentifier(Citations.PROJ, "goode")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new Homolosine(PARAMETERS, parameters);
        }
    }
}

