/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.List;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.operation.ConicProjection;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import si.uom.NonSI;
import tech.units.indriya.AbstractUnit;

public class Krovak
extends MapProjection {
    private static final long serialVersionUID = -8359105634355342212L;
    private static final int MAXIMUM_ITERATIONS = 15;
    private static final double ITERATION_TOLERANCE = 1.0E-11;
    protected final double azimuth;
    protected final ParameterDescriptorGroup descriptors;
    protected double x_scale;
    protected double y_scale;
    protected double xy_plane_rotation;
    boolean esriDefinition;
    private MathTransform axisTransform = null;
    protected final double pseudoStandardParallel;
    private final double sinAzim;
    private final double cosAzim;
    private final double n;
    private final double tanS2;
    private final double alfa;
    private final double hae;
    private final double k1;
    private final double ka;
    private final double ro0;
    private final double rop;
    private static final double s45 = 0.785398163397448;

    protected Krovak(ParameterValueGroup parameters, ParameterDescriptorGroup descriptors, boolean esriDefinition) throws ParameterNotFoundException {
        super(parameters, descriptors.descriptors());
        this.descriptors = descriptors;
        this.esriDefinition = esriDefinition;
        List expected = this.getParameterDescriptors().descriptors();
        this.latitudeOfOrigin = this.doubleValue(expected, BaseProvider.LATITUDE_OF_CENTER, parameters);
        this.centralMeridian = this.doubleValue(expected, BaseProvider.LONGITUDE_OF_CENTER, parameters);
        this.azimuth = this.doubleValue(expected, BaseProvider.AZIMUTH, parameters);
        this.pseudoStandardParallel = this.doubleValue(expected, BaseProvider.PSEUDO_STANDARD_PARALLEL, parameters);
        this.scaleFactor = this.doubleValue(expected, BaseProvider.SCALE_FACTOR, parameters);
        this.x_scale = this.doubleValue(expected, BaseProvider.X_SCALE, parameters);
        this.y_scale = this.doubleValue(expected, BaseProvider.Y_SCALE, parameters);
        this.xy_plane_rotation = this.doubleValue(expected, BaseProvider.XY_PLANE_ROTATION, parameters);
        if (Double.isNaN(this.doubleValue(expected, BaseProvider.X_SCALE, parameters)) && Double.isNaN(this.doubleValue(expected, BaseProvider.Y_SCALE, parameters)) && Double.isNaN(this.doubleValue(expected, BaseProvider.XY_PLANE_ROTATION, parameters))) {
            this.esriDefinition = false;
        } else {
            this.axisTransform = this.createAffineTransform(this.x_scale, this.y_scale, this.xy_plane_rotation);
        }
        Krovak.ensureLatitudeInRange(BaseProvider.LATITUDE_OF_CENTER, this.latitudeOfOrigin, false);
        Krovak.ensureLongitudeInRange(BaseProvider.LONGITUDE_OF_CENTER, this.centralMeridian, false);
        this.sinAzim = Math.sin(this.azimuth);
        this.cosAzim = Math.cos(this.azimuth);
        this.n = Math.sin(this.pseudoStandardParallel);
        this.tanS2 = Math.tan(this.pseudoStandardParallel / 2.0 + 0.785398163397448);
        double sinLat = Math.sin(this.latitudeOfOrigin);
        double cosLat = Math.cos(this.latitudeOfOrigin);
        double cosL2 = cosLat * cosLat;
        this.alfa = Math.sqrt(1.0 + this.excentricitySquared * (cosL2 * cosL2) / (1.0 - this.excentricitySquared));
        this.hae = this.alfa * this.excentricity / 2.0;
        double u0 = Math.asin(sinLat / this.alfa);
        double esl = this.excentricity * sinLat;
        double g = Math.pow((1.0 - esl) / (1.0 + esl), this.alfa * this.excentricity / 2.0);
        this.k1 = Math.pow(Math.tan(this.latitudeOfOrigin / 2.0 + 0.785398163397448), this.alfa) * g / Math.tan(u0 / 2.0 + 0.785398163397448);
        this.ka = Math.pow(1.0 / this.k1, -1.0 / this.alfa);
        double radius = Math.sqrt(1.0 - this.excentricitySquared) / (1.0 - this.excentricitySquared * (sinLat * sinLat));
        this.ro0 = this.scaleFactor * radius / Math.tan(this.pseudoStandardParallel);
        this.rop = this.ro0 * Math.pow(this.tanS2, this.n);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.descriptors;
    }

    private MathTransform createAffineTransform(double x_scale, double y_scale, double xy_plane_rotation) {
        double a00 = x_scale * Math.cos(xy_plane_rotation);
        double a01 = -y_scale * Math.sin(xy_plane_rotation);
        double a10 = x_scale * Math.sin(xy_plane_rotation);
        double a11 = y_scale * Math.cos(xy_plane_rotation);
        AffineTransform at = new AffineTransform(a00, a10, a01, a11, 0.0, 0.0);
        AffineTransform2D theAffineTransform = new AffineTransform2D(at);
        return theAffineTransform;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        List expected = this.getParameterDescriptors().descriptors();
        ParameterValueGroup values = super.getParameterValues();
        this.set(expected, BaseProvider.LATITUDE_OF_CENTER, values, this.latitudeOfOrigin);
        this.set(expected, BaseProvider.LONGITUDE_OF_CENTER, values, this.centralMeridian);
        this.set(expected, BaseProvider.AZIMUTH, values, this.azimuth);
        this.set(expected, BaseProvider.PSEUDO_STANDARD_PARALLEL, values, this.pseudoStandardParallel);
        this.set(expected, BaseProvider.SCALE_FACTOR, values, this.scaleFactor);
        if (this.esriDefinition) {
            this.set(expected, BaseProvider.X_SCALE, values, this.x_scale);
            this.set(expected, BaseProvider.Y_SCALE, values, this.y_scale);
            this.set(expected, BaseProvider.XY_PLANE_ROTATION, values, this.xy_plane_rotation);
        }
        return values;
    }

    @Override
    protected Point2D transformNormalized(double lambda, double phi, Point2D ptDst) throws ProjectionException {
        double esp = this.excentricity * Math.sin(phi);
        double gfi = Math.pow((1.0 - esp) / (1.0 + esp), this.hae);
        double u = 2.0 * (Math.atan(Math.pow(Math.tan(phi / 2.0 + 0.785398163397448), this.alfa) / this.k1 * gfi) - 0.785398163397448);
        double deltav = -lambda * this.alfa;
        double cosU = Math.cos(u);
        double s = Math.asin(this.cosAzim * Math.sin(u) + this.sinAzim * cosU * Math.cos(deltav));
        double d = Math.asin(cosU * Math.sin(deltav) / Math.cos(s));
        double eps = this.n * d;
        double ro = this.rop / Math.pow(Math.tan(s / 2.0 + 0.785398163397448), this.n);
        double y = -(ro * Math.cos(eps));
        double x = -(ro * Math.sin(eps));
        double[] result = new double[]{x, y};
        if (this.axisTransform != null) {
            try {
                this.axisTransform.transform(new double[]{x, y}, 0, result, 0, 1);
            }
            catch (TransformException e) {
                throw new ProjectionException(e);
            }
        }
        if (ptDst != null) {
            ptDst.setLocation(result[0], result[1]);
            return ptDst;
        }
        return new Point2D.Double(result[0], result[1]);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double esf;
        double[] result = new double[]{x, y};
        if (this.axisTransform != null) {
            try {
                this.axisTransform.transform(new double[]{x, y}, 0, result, 0, 1);
            }
            catch (TransformException e) {
                throw new ProjectionException(e);
            }
        }
        double ro = Math.hypot(result[0], result[1]);
        double eps = Math.atan2(-result[0], -result[1]);
        double d = eps / this.n;
        double s = 2.0 * (Math.atan(Math.pow(this.ro0 / ro, 1.0 / this.n) * this.tanS2) - 0.785398163397448);
        double cs = Math.cos(s);
        double u = Math.asin(this.cosAzim * Math.sin(s) - this.sinAzim * cs * Math.cos(d));
        double kau = this.ka * Math.pow(Math.tan(u / 2.0 + 0.785398163397448), 1.0 / this.alfa);
        double deltav = Math.asin(cs * Math.sin(d) / Math.cos(u));
        double lambda = -deltav / this.alfa;
        double phi = 0.0;
        double fi1 = u;
        int i = 15;
        while (!(Math.abs((fi1 = phi) - (phi = 2.0 * (Math.atan(kau * Math.pow((1.0 + (esf = this.excentricity * Math.sin(fi1))) / (1.0 - esf), this.excentricity / 2.0)) - 0.785398163397448))) <= 1.0E-11)) {
            if (--i >= 0) continue;
            throw new ProjectionException("Transformation doesn't convergence.");
        }
        if (ptDst != null) {
            ptDst.setLocation(lambda, phi);
            return ptDst;
        }
        return new Point2D.Double(lambda, phi);
    }

    @Override
    public int hashCode() {
        long code = Double.doubleToLongBits(this.azimuth) ^ Double.doubleToLongBits(this.pseudoStandardParallel);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            Krovak that = (Krovak)object;
            return Krovak.equals(this.azimuth, that.azimuth) && Krovak.equals(this.pseudoStandardParallel, that.pseudoStandardParallel);
        }
        return false;
    }

    private static abstract class BaseProvider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = -278392856661204734L;
        public static final ParameterDescriptor LATITUDE_OF_CENTER = BaseProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "latitude_of_center"), new NamedIdentifier(Citations.EPSG, "Latitude of projection centre"), new NamedIdentifier(Citations.EPSG, "Latitude of origin"), new NamedIdentifier(Citations.GEOTIFF, "CenterLat"), new NamedIdentifier(Citations.PROJ, "lat_0")}, 49.5, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LONGITUDE_OF_CENTER = BaseProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "longitude_of_center"), new NamedIdentifier(Citations.EPSG, "Longitude of projection centre"), new NamedIdentifier(Citations.EPSG, "Longitude of origin"), new NamedIdentifier(Citations.GEOTIFF, "CenterLong"), new NamedIdentifier(Citations.PROJ, "lon_0")}, 24.83333333333333, -180.0, 180.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor AZIMUTH = BaseProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Co-latitude of cone axis"), new NamedIdentifier(Citations.OGC, "azimuth"), new NamedIdentifier(Citations.EPSG, "Azimuth of initial line"), new NamedIdentifier(Citations.GEOTIFF, "AzimuthAngle"), new NamedIdentifier(Citations.ESRI, "Azimuth"), new NamedIdentifier(Citations.PROJ, "alpha")}, 30.28813972222222, 0.0, 360.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor PSEUDO_STANDARD_PARALLEL = BaseProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "pseudo_standard_parallel_1"), new NamedIdentifier(Citations.EPSG, "Latitude of Pseudo Standard Parallel"), new NamedIdentifier(Citations.ESRI, "Pseudo_Standard_Parallel_1")}, 78.5, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor SCALE_FACTOR = BaseProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "scale_factor"), new NamedIdentifier(Citations.EPSG, "Scale factor on pseudo standard parallel"), new NamedIdentifier(Citations.GEOTIFF, "ScaleAtCenter"), new NamedIdentifier(Citations.OGC, "Scale_Factor"), new NamedIdentifier(Citations.PROJ, "k_0")}, 0.9999, 0.0, Double.POSITIVE_INFINITY, AbstractUnit.ONE);
        public static final ParameterDescriptor X_SCALE = BaseProvider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "X_Scale")}, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, AbstractUnit.ONE);
        public static final ParameterDescriptor Y_SCALE = BaseProvider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Y_Scale")}, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, AbstractUnit.ONE);
        public static final ParameterDescriptor XY_PLANE_ROTATION = BaseProvider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "XY_Plane_Rotation")}, -360.0, 360.0, NonSI.DEGREE_ANGLE);

        public BaseProvider(ParameterDescriptorGroup params) {
            super(params);
        }

        public Class<ConicProjection> getOperationType() {
            return ConicProjection.class;
        }
    }

    public static class NorthProvider
    extends BaseProvider {
        static final ParameterDescriptorGroup PARAMETERS = NorthProvider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Krovak"), new NamedIdentifier(Citations.GEOTIFF, "Krovak"), new NamedIdentifier(Citations.OGC, "Krovak (North Orientated)"), new NamedIdentifier(Citations.EPSG, "Krovak (North Orientated)"), new NamedIdentifier(Citations.EPSG, "1041"), new NamedIdentifier(Citations.PROJ, "krovak")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LATITUDE_OF_CENTER, LONGITUDE_OF_CENTER, AZIMUTH, PSEUDO_STANDARD_PARALLEL, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public NorthProvider() {
            super(PARAMETERS);
        }

        @Override
        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new Krovak(parameters, PARAMETERS, false);
        }
    }

    public static class Provider
    extends BaseProvider {
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Krovak"), new NamedIdentifier(Citations.GEOTIFF, "Krovak"), new NamedIdentifier(Citations.EPSG, "Krovak Oblique Conformal Conic"), new NamedIdentifier(Citations.EPSG, "Krovak Oblique Conic Conformal"), new NamedIdentifier(Citations.EPSG, "9819"), new NamedIdentifier(Citations.ESRI, "Krovak"), new NamedIdentifier(Citations.PROJ, "krovak")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LATITUDE_OF_CENTER, LONGITUDE_OF_CENTER, AZIMUTH, PSEUDO_STANDARD_PARALLEL, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});
        static final ParameterDescriptorGroup ESRI_PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Krovak"), new NamedIdentifier(Citations.GEOTIFF, "Krovak"), new NamedIdentifier(Citations.EPSG, "Krovak Oblique Conformal Conic"), new NamedIdentifier(Citations.EPSG, "Krovak Oblique Conic Conformal"), new NamedIdentifier(Citations.EPSG, "9819"), new NamedIdentifier(Citations.ESRI, "Krovak"), new NamedIdentifier(Citations.PROJ, "krovak")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LATITUDE_OF_CENTER, LONGITUDE_OF_CENTER, AZIMUTH, PSEUDO_STANDARD_PARALLEL, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING, X_SCALE, Y_SCALE, XY_PLANE_ROTATION});

        public Provider() {
            super(ESRI_PARAMETERS);
        }

        @Override
        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            boolean esriDefinition = this.isESRIDefinition(parameters);
            if (esriDefinition) {
                return new Krovak(parameters, ESRI_PARAMETERS, true);
            }
            return new Krovak(parameters, PARAMETERS, false);
        }

        private boolean isESRIDefinition(ParameterValueGroup parameters) {
            for (GeneralParameterDescriptor descriptor : parameters.getDescriptor().descriptors()) {
                if (!(descriptor instanceof ParameterDescriptor) || !AbstractIdentifiedObject.nameMatches((IdentifiedObject)descriptor, (IdentifiedObject)X_SCALE) && !AbstractIdentifiedObject.nameMatches((IdentifiedObject)descriptor, (IdentifiedObject)Y_SCALE) && !AbstractIdentifiedObject.nameMatches((IdentifiedObject)descriptor, (IdentifiedObject)XY_PLANE_ROTATION)) continue;
                return true;
            }
            return false;
        }
    }
}

