/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.operation.Conversion;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.FloatParameter;
import org.geotools.parameter.Parameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import si.uom.SI;

public class GeocentricTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -3352045463953828140L;
    private static final double MAX_ERROR = 0.01;
    private static final double COS_67P5 = 0.3826834323650898;
    private static final double AD_C = 1.0026;
    private final double a;
    private final double b;
    private final double a2;
    private final double b2;
    private final double e2;
    private final double ep2;
    private final boolean hasHeight;
    private transient MathTransform inverse;

    public GeocentricTransform(Ellipsoid ellipsoid, boolean hasHeight) {
        this(ellipsoid.getSemiMajorAxis(), ellipsoid.getSemiMinorAxis(), (Unit<Length>)ellipsoid.getAxisUnit(), hasHeight);
    }

    public GeocentricTransform(double semiMajor, double semiMinor, Unit<Length> units, boolean hasHeight) {
        this.hasHeight = hasHeight;
        UnitConverter converter = units.getConverterTo(SI.METRE);
        this.a = converter.convert(semiMajor);
        this.b = converter.convert(semiMinor);
        this.a2 = this.a * this.a;
        this.b2 = this.b * this.b;
        this.e2 = (this.a2 - this.b2) / this.a2;
        this.ep2 = (this.a2 - this.b2) / this.b2;
        GeocentricTransform.checkArgument("a", this.a, Double.MAX_VALUE);
        GeocentricTransform.checkArgument("b", this.b, this.a);
    }

    private static void checkArgument(String name, double value, double max) throws IllegalArgumentException {
        if (!(value >= 0.0) || !(value <= max)) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal argument: \"{0}={1}\".", name, value));
        }
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.getParameterValues(this.getParameterDescriptors());
    }

    private ParameterValueGroup getParameterValues(ParameterDescriptorGroup descriptor) {
        ParameterValue[] parameters = new ParameterValue[this.hasHeight ? 2 : 3];
        int index = 0;
        if (!this.hasHeight) {
            Parameter<Integer> p = new Parameter<Integer>(Provider.DIM);
            p.setValue(2);
            parameters[index++] = p;
        }
        parameters[index++] = new FloatParameter(Provider.SEMI_MAJOR, this.a);
        parameters[index++] = new FloatParameter(Provider.SEMI_MINOR, this.b);
        return new ParameterGroup(descriptor, (GeneralParameterValue[])parameters);
    }

    @Override
    public int getSourceDimensions() {
        return this.hasHeight ? 3 : 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 3;
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        this.transform(srcPts, srcOff, dstPts, dstOff, numPts, false);
    }

    private void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts, boolean hasHeight) {
        int dimSource = this.getSourceDimensions();
        hasHeight |= dimSource >= 3;
        if (srcPts == dstPts && GeocentricTransform.needCopy(srcOff, dimSource, dstOff, 3, numPts)) {
            double[] old = srcPts;
            srcPts = new double[numPts * (hasHeight ? 3 : 2)];
            System.arraycopy(old, srcOff, srcPts, 0, srcPts.length);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            double L = Math.toRadians(srcPts[srcOff++]);
            double P = Math.toRadians(srcPts[srcOff++]);
            double h = hasHeight ? srcPts[srcOff++] : 0.0;
            double cosLat = Math.cos(P);
            double sinLat = Math.sin(P);
            double rn = this.a / Math.sqrt(1.0 - this.e2 * (sinLat * sinLat));
            dstPts[dstOff++] = (rn + h) * cosLat * Math.cos(L);
            dstPts[dstOff++] = (rn + h) * cosLat * Math.sin(L);
            dstPts[dstOff++] = (rn * (1.0 - this.e2) + h) * sinLat;
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        boolean hasHeight;
        int dimSource = this.getSourceDimensions();
        boolean bl = hasHeight = dimSource >= 3;
        if (srcPts == dstPts && GeocentricTransform.needCopy(srcOff, dimSource, dstOff, 3, numPts)) {
            float[] old = srcPts;
            srcPts = new float[numPts * dimSource];
            System.arraycopy(old, srcOff, srcPts, 0, srcPts.length);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            double L = Math.toRadians(srcPts[srcOff++]);
            double P = Math.toRadians(srcPts[srcOff++]);
            double h = hasHeight ? (double)srcPts[srcOff++] : 0.0;
            double cosLat = Math.cos(P);
            double sinLat = Math.sin(P);
            double rn = this.a / Math.sqrt(1.0 - this.e2 * (sinLat * sinLat));
            dstPts[dstOff++] = (float)((rn + h) * cosLat * Math.cos(L));
            dstPts[dstOff++] = (float)((rn + h) * cosLat * Math.sin(L));
            dstPts[dstOff++] = (float)((rn * (1.0 - this.e2) + h) * sinLat);
        }
    }

    public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int dimTarget = this.getSourceDimensions();
        if (srcPts == dstPts && GeocentricTransform.needCopy(srcOff, 3, dstOff, dimTarget, numPts)) {
            double[] old = srcPts;
            srcPts = new double[numPts * 3];
            System.arraycopy(old, srcOff, srcPts, 0, srcPts.length);
            srcOff = 0;
        }
        this.inverseTransform(null, srcPts, srcOff, null, dstPts, dstOff, numPts, dimTarget);
    }

    public void inverseTransform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        int dimTarget = this.getSourceDimensions();
        if (srcPts == dstPts && GeocentricTransform.needCopy(srcOff, 3, dstOff, dimTarget, numPts)) {
            float[] old = srcPts;
            srcPts = new float[numPts * 3];
            System.arraycopy(old, srcOff, srcPts, 0, srcPts.length);
            srcOff = 0;
        }
        this.inverseTransform(srcPts, null, srcOff, dstPts, null, dstOff, numPts, dimTarget);
    }

    private void inverseTransform(float[] srcPts1, double[] srcPts2, int srcOff, float[] dstPts1, double[] dstPts2, int dstOff, int numPts, int dimTarget) {
        boolean hasHeight;
        boolean computeHeight = hasHeight = dimTarget >= 3;
        if (!$assertionsDisabled) {
            computeHeight = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        while (--numPts >= 0) {
            double distance;
            double z;
            double y;
            double x;
            if (srcPts2 != null) {
                x = srcPts2[srcOff++];
                y = srcPts2[srcOff++];
                z = srcPts2[srcOff++];
            } else {
                x = srcPts1[srcOff++];
                y = srcPts1[srcOff++];
                z = srcPts1[srcOff++];
            }
            double W2 = x * x + y * y;
            double W = Math.sqrt(W2);
            double T0 = z * 1.0026;
            double S0 = Math.sqrt(T0 * T0 + W2);
            double sin_B0 = T0 / S0;
            double cos_B0 = W / S0;
            double sin3_B0 = sin_B0 * sin_B0 * sin_B0;
            double T1 = z + this.b * this.ep2 * sin3_B0;
            double sum = W - this.a * this.e2 * (cos_B0 * cos_B0 * cos_B0);
            double S1 = Math.sqrt(T1 * T1 + sum * sum);
            double sin_p1 = T1 / S1;
            double cos_p1 = sum / S1;
            double longitude = Math.toDegrees(Math.atan2(y, x));
            double latitude = Math.toDegrees(Math.atan(sin_p1 / cos_p1));
            if (dstPts2 != null) {
                dstPts2[dstOff++] = longitude;
                dstPts2[dstOff++] = latitude;
            } else {
                dstPts1[dstOff++] = (float)longitude;
                dstPts1[dstOff++] = (float)latitude;
            }
            if (!computeHeight) continue;
            double rn = this.a / Math.sqrt(1.0 - this.e2 * (sin_p1 * sin_p1));
            double height = cos_p1 >= 0.3826834323650898 ? W / cos_p1 - rn : (cos_p1 <= -0.3826834323650898 ? W / -cos_p1 - rn : z / sin_p1 + rn * (this.e2 - 1.0));
            if (hasHeight) {
                if (dstPts2 != null) {
                    dstPts2[dstOff++] = height;
                } else {
                    dstPts1[dstOff++] = (float)height;
                }
            }
            assert (0.01 > (distance = this.checkTransform(new double[]{x, y, z, longitude, latitude, height}))) : distance;
        }
    }

    private double checkTransform(double[] points) {
        this.transform(points, 3, points, 3, 1, true);
        double dx = points[0] - points[3];
        double dy = points[1] - points[4];
        double dz = points[2] - points[5];
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public synchronized MathTransform inverse() {
        if (this.inverse == null) {
            this.inverse = new Inverse();
        }
        return this.inverse;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeocentricTransform that = (GeocentricTransform)o;
        return Double.compare(that.a, this.a) == 0 && Double.compare(that.b, this.b) == 0 && Double.compare(that.a2, this.a2) == 0 && Double.compare(that.b2, this.b2) == 0 && Double.compare(that.e2, this.e2) == 0 && Double.compare(that.ep2, this.ep2) == 0 && this.hasHeight == that.hasHeight;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.a, this.b, this.a2, this.b2, this.e2, this.ep2, this.hasHeight);
    }

    public static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = 7043216580786030251L;
        public static final ParameterDescriptor<Double> SEMI_MAJOR = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "semi_major"), new NamedIdentifier(Citations.EPSG, "semi-major axis")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METRE);
        public static final ParameterDescriptor<Double> SEMI_MINOR = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "semi_minor"), new NamedIdentifier(Citations.EPSG, "semi-minor axis")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METRE);
        static final ParameterDescriptor<Integer> DIM = DefaultParameterDescriptor.create(Collections.singletonMap("name", new NamedIdentifier(Citations.GEOTOOLS, "dim")), 3, 2, 3, false);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup("Ellipsoid_To_Geocentric", "Geographic/geocentric conversions", "9602", 79);
        transient Provider noHeight;

        static ParameterDescriptorGroup createDescriptorGroup(String ogc, String epsgName, String epsgCode, int geotools) {
            return Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, ogc), new NamedIdentifier(Citations.EPSG, epsgName), new NamedIdentifier(Citations.EPSG, epsgCode), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)geotools))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, DIM});
        }

        public Provider() {
            super(3, 3, PARAMETERS);
        }

        Provider(int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters) {
            super(sourceDimensions, targetDimensions, parameters);
        }

        public Class<Conversion> getOperationType() {
            return Conversion.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException {
            int dimGeographic = Provider.intValue(DIM, values);
            double semiMajor = Provider.doubleValue(SEMI_MAJOR, values);
            double semiMinor = Provider.doubleValue(SEMI_MINOR, values);
            boolean hasHeight = dimGeographic != 2;
            Serializable transform = new GeocentricTransform(semiMajor, semiMinor, (Unit<Length>)SI.METRE, hasHeight);
            if (!hasHeight) {
                if (this.noHeight == null) {
                    this.noHeight = new Provider(2, 3, PARAMETERS);
                }
                transform = new MathTransformProvider.Delegate((MathTransform)transform, this.noHeight);
            }
            return transform;
        }
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements Serializable {
        private static final long serialVersionUID = 6942084702259211803L;

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return ProviderInverse.PARAMETERS;
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            return GeocentricTransform.this.getParameterValues(this.getParameterDescriptors());
        }

        public void transform(double[] source, int srcOffset, double[] dest, int dstOffset, int length) {
            GeocentricTransform.this.inverseTransform(source, srcOffset, dest, dstOffset, length);
        }

        @Override
        public void transform(float[] source, int srcOffset, float[] dest, int dstOffset, int length) {
            GeocentricTransform.this.inverseTransform(source, srcOffset, dest, dstOffset, length);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            GeocentricTransform.this.inverse = this;
        }
    }

    public static class ProviderInverse
    extends Provider {
        private static final long serialVersionUID = -7356791540110076789L;
        static final ParameterDescriptorGroup PARAMETERS = ProviderInverse.createDescriptorGroup("Geocentric_To_Ellipsoid", "Geographic/geocentric conversions", "9602", 79);

        public ProviderInverse() {
            super(3, 3, PARAMETERS);
        }

        ProviderInverse(int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters) {
            super(sourceDimensions, targetDimensions, parameters);
        }

        @Override
        public MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException {
            int dimGeographic = ProviderInverse.intValue(DIM, values);
            double semiMajor = ProviderInverse.doubleValue(SEMI_MAJOR, values);
            double semiMinor = ProviderInverse.doubleValue(SEMI_MINOR, values);
            boolean hasHeight = dimGeographic != 2;
            MathTransform transform = new GeocentricTransform(semiMajor, semiMinor, (Unit<Length>)SI.METRE, hasHeight).inverse();
            if (!hasHeight) {
                if (this.noHeight == null) {
                    this.noHeight = new ProviderInverse(3, 2, PARAMETERS);
                }
                transform = new MathTransformProvider.Delegate(transform, this.noHeight);
            }
            return transform;
        }
    }
}

