/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.proj;

import java.lang.reflect.Array;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import javax.measure.Unit;
import org.apache.commons.lang3.StringUtils;
import org.geotools.api.metadata.Identifier;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.datum.Datum;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.datum.PrimeMeridian;
import org.geotools.api.util.GenericName;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.proj.PROJAliases;
import org.geotools.referencing.proj.PROJFormattable;
import org.geotools.referencing.proj.PROJRefiner;

public class PROJFormatter {
    public static final String NO_KEYWORD = "";
    private StringBuffer buffer;
    private static final FieldPosition FP_ZERO = new FieldPosition(0);
    private static final PROJAliases PROJ_ALIASES = new PROJAliases();
    private static final PROJRefiner PROJ_REFINER = new PROJRefiner();
    private boolean projectedCRS = false;
    private boolean datumProvided = false;
    private boolean ellipsoidProvided = false;
    private boolean primeMeridianProvided = false;
    private NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);

    public PROJFormatter() {
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setMinimumFractionDigits(1);
        this.numberFormat.setMaximumFractionDigits(17);
        this.buffer = new StringBuffer();
    }

    public boolean isProjectedCRS() {
        return this.projectedCRS;
    }

    public boolean isDatumProvided() {
        return this.datumProvided;
    }

    public boolean isEllipsoidProvided() {
        return this.ellipsoidProvided;
    }

    public boolean isPrimeMeridianProvided() {
        return this.primeMeridianProvided;
    }

    public void append(PROJFormattable formattable) {
        String keyword;
        IdentifiedObject io;
        IdentifiedObject info;
        int base = this.buffer.length();
        IdentifiedObject identifiedObject = info = formattable instanceof IdentifiedObject ? (io = (IdentifiedObject)formattable) : null;
        if (info != null) {
            this.buffer.append(this.getName(info)).append(" ");
        }
        if (!StringUtils.isEmpty((CharSequence)(keyword = formattable.formatPROJ(this)))) {
            this.buffer.insert(base, keyword);
        }
    }

    public void append(GeneralParameterValue parameter) {
        if (parameter instanceof ParameterValueGroup) {
            ParameterValueGroup group = (ParameterValueGroup)parameter;
            for (GeneralParameterValue param : group.values()) {
                this.append(param);
            }
        }
        if (parameter instanceof ParameterValue) {
            ParameterValue param = (ParameterValue)parameter;
            ParameterDescriptor descriptor = param.getDescriptor();
            Unit valueUnit = descriptor.getUnit();
            String name = this.getName((IdentifiedObject)descriptor);
            if (name != null && !name.isBlank()) {
                if (valueUnit != null) {
                    double value;
                    try {
                        value = param.doubleValue();
                    }
                    catch (IllegalStateException exception) {
                        value = Double.NaN;
                    }
                    this.append(name, value);
                } else {
                    this.buffer.append("+" + name);
                    this.buffer.append("=");
                    this.appendObject(param.getValue());
                    this.buffer.append(" ");
                }
            }
        }
    }

    public void append(Unit<?> unit) {
        if (unit != null) {
            this.buffer.append("+units=");
            String symbol = unit.getSymbol();
            if (symbol == null) {
                symbol = unit.toString();
            }
            this.buffer.append(symbol);
        }
    }

    private void appendObject(Object value) {
        if (value == null) {
            this.buffer.append("null");
            return;
        }
        if (value.getClass().isArray()) {
            this.buffer.append('{');
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                if (i != 0) {
                    this.buffer.append(',').append(' ');
                }
                this.appendObject(Array.get(value, i));
            }
            this.buffer.append('}');
            return;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            this.format(number);
        } else {
            this.buffer.append('\"').append(value).append('\"');
        }
    }

    public void append(String key, String value) {
        this.buffer.append(" +").append(key).append("=").append(value).append(" ");
    }

    public void append(String key, double number) {
        this.buffer.append(" +").append(key).append("=");
        this.format(number);
        this.buffer.append(" ");
    }

    public String getName(IdentifiedObject info) {
        ReferenceIdentifier name = info.getName();
        if (Citations.PROJ != name.getAuthority()) {
            String projAlias;
            Collection aliases = info.getAlias();
            if (aliases != null && !aliases.isEmpty()) {
                for (GenericName alias : aliases) {
                    Identifier candidate;
                    if (!(alias instanceof Identifier) || Citations.PROJ != (candidate = (Identifier)alias).getAuthority()) continue;
                    if (info instanceof DefaultOperationMethod) {
                        this.projectedCRS = true;
                    }
                    return candidate.getCode();
                }
                String title = Citations.PROJ.getTitle().toString(null);
                for (GenericName alias : aliases) {
                    GenericName scope = alias.scope().name();
                    if (scope == null || !title.equalsIgnoreCase(scope.toString())) continue;
                    if (info instanceof Datum) {
                        this.datumProvided = true;
                    } else if (info instanceof Ellipsoid) {
                        this.ellipsoidProvided = true;
                    }
                    return alias.tip().toString();
                }
            }
            if (info instanceof Ellipsoid && (projAlias = PROJ_ALIASES.getEllipsoidAlias(info.getName().getCode())) != null) {
                this.ellipsoidProvided = true;
                return projAlias;
            }
            if (info instanceof PrimeMeridian && (projAlias = PROJ_ALIASES.getPrimeMeridianAlias(info.getName().getCode())) != null) {
                this.primeMeridianProvided = true;
                return projAlias;
            }
        }
        return NO_KEYWORD;
    }

    public Identifier getIdentifier(IdentifiedObject info) {
        Set identifiers;
        Identifier first = null;
        if (info != null && (identifiers = info.getIdentifiers()) != null) {
            for (Identifier id : identifiers) {
                if (Citations.PROJ == id.getAuthority()) {
                    return id;
                }
                if (first != null) continue;
                first = id;
            }
        }
        return first;
    }

    public void clear() {
        if (this.buffer != null) {
            this.buffer.setLength(0);
        }
        this.datumProvided = false;
        this.ellipsoidProvided = false;
        this.primeMeridianProvided = false;
        this.projectedCRS = false;
    }

    private void format(Number number) {
        if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
            this.format(number.intValue());
        } else {
            this.format(number.doubleValue());
        }
    }

    private void format(int number) {
        int fraction = this.numberFormat.getMinimumFractionDigits();
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.format(number, this.buffer, FP_ZERO);
        this.numberFormat.setMinimumFractionDigits(fraction);
    }

    private void format(double number) {
        if (number == Math.floor(number)) {
            this.format((int)number);
        } else {
            this.numberFormat.format(number, this.buffer, FP_ZERO);
        }
    }

    public String toPROJ(PROJFormattable formattable) {
        if (formattable instanceof IdentifiedObject) {
            IdentifiedObject identifiedObject = (IdentifiedObject)formattable;
            formattable.formatPROJ(this);
            String refinedString = PROJ_REFINER.refine(this.buffer.toString(), ((ReferenceIdentifier)identifiedObject.getIdentifiers().iterator().next()).getCode());
            this.buffer = new StringBuffer(refinedString);
            return refinedString;
        }
        throw new UnsupportedOperationException("PROJ String is not supported for this type of object: " + String.valueOf(formattable));
    }
}

