/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml4wcs.bindings;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.Position2D;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.gml3.GML;
import org.geotools.xlink.XLINK;
import org.geotools.xsd.Encoder;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;

public class GML3EncodingUtils {
    static Position[] positions(LineString line) {
        CoordinateSequence coordinates = line.getCoordinateSequence();
        Position[] dps = new Position[coordinates.size()];
        for (int i = 0; i < dps.length; ++i) {
            double x = coordinates.getOrdinate(i, 0);
            double y = coordinates.getOrdinate(i, 1);
            dps[i] = new Position2D(x, y);
        }
        return dps;
    }

    static URI toURI(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        try {
            String crsCode = GML2EncodingUtils.toURI((CoordinateReferenceSystem)crs);
            if (crsCode != null) {
                return new URI(crsCode);
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static String getID(Geometry g) {
        return GML2EncodingUtils.getID((Geometry)g);
    }

    static String getName(Geometry g) {
        return GML2EncodingUtils.getName((Geometry)g);
    }

    static String getDescription(Geometry g) {
        return GML2EncodingUtils.getDescription((Geometry)g);
    }

    static Object getProperty(Geometry geometry, QName name) {
        String id;
        if (GML._Geometry.equals(name) || GML.Point.equals(name) || GML.LineString.equals(name) || GML.Polygon.equals(name)) {
            if (GML3EncodingUtils.isEmpty(geometry)) {
                return null;
            }
            return geometry;
        }
        if (XLINK.HREF.equals(name) && GML3EncodingUtils.isEmpty(geometry) && (id = GML3EncodingUtils.getID(geometry)) != null) {
            return "#" + id;
        }
        return null;
    }

    static List getProperties(Geometry geometry) {
        String id = GML3EncodingUtils.getID(geometry);
        if (!GML3EncodingUtils.isEmpty(geometry) && id != null) {
            return Collections.singletonList(new Object[]{Encoder.COMMENT, "#" + id});
        }
        return null;
    }

    static boolean isEmpty(Geometry geometry) {
        if (geometry.isEmpty()) {
            return !(geometry instanceof GeometryCollection) || geometry.getNumGeometries() == 0;
        }
        return false;
    }
}

