/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSRequest;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.style.Style;
import org.geotools.feature.NameImpl;
import org.geotools.util.Converters;

public class GetLegendGraphicRequest
extends WMSRequest {
    public static final String COUNT_MATCHED_KEY = "countMatched";
    public static final String HIDE_EMPTY_RULES = "hideEmptyRules";
    public static final String SLD_VERSION = "1.0.0";
    public static final int DEFAULT_WIDTH = 20;
    public static final int DEFAULT_HEIGHT = 20;
    public static final String DEFAULT_FORMAT = "image/png";
    private List<LegendRequest> legends = new ArrayList<LegendRequest>();
    private String featureType;
    private double scale = -1.0;
    private String format;
    private int width = 20;
    private int height = 20;
    private String exceptionsFormat = "SE_XML";
    private Map<String, Object> legendOptions;
    private boolean transparent;
    private boolean strict = true;
    private Locale locale;
    private Map<String, Object> kvp;
    private WMS wms;
    private Map<String, Object> env = new HashMap<String, Object>();

    public GetLegendGraphicRequest() {
        super("GetLegendGraphic");
        this.wms = WMS.get();
    }

    public GetLegendGraphicRequest(WMS wms) {
        super("GetLegendGraphic");
        this.wms = wms;
    }

    public String getExceptions() {
        return this.exceptionsFormat;
    }

    public void setExceptions(String exceptionsFormat) {
        this.exceptionsFormat = exceptionsFormat;
    }

    public String getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(String featureType) {
        this.featureType = featureType;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public List<LegendRequest> getLegends() {
        return this.legends;
    }

    public List<FeatureType> getLayers() {
        ArrayList<FeatureType> types = new ArrayList<FeatureType>(this.legends.size());
        for (LegendRequest layer : this.legends) {
            FeatureType ft = layer.getFeatureType();
            if (ft == null) continue;
            types.add(ft);
        }
        return types;
    }

    public LegendRequest getLegend(Name featureTypeName) {
        for (LegendRequest legend : this.legends) {
            if (!featureTypeName.equals((Object)legend.getLayerName())) continue;
            return legend;
        }
        return null;
    }

    public void setLayer(FeatureType layer) {
        this.legends.clear();
        if (layer == null) {
            this.legends.add(new LegendRequest());
        } else {
            this.legends.add(new LegendRequest(layer));
        }
    }

    public void setRule(String rule) {
        if (!this.legends.isEmpty()) {
            this.legends.get(0).setRule(rule);
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setStyle(Style style) {
        if (this.legends.isEmpty()) {
            return;
        }
        this.legends.get(0).setStyle(style);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Map<String, Object> getLegendOptions() {
        return this.legendOptions == null ? Collections.emptyMap() : this.legendOptions;
    }

    public void setLegendOptions(Map legendOptions) {
        this.legendOptions = legendOptions;
    }

    public void setTransparent(boolean transparentBackground) {
        this.transparent = transparentBackground;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public Map<String, Object> getEnv() {
        return this.env;
    }

    public void setEnv(Map enviroment) {
        this.env = enviroment;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public <T> T getLegendOption(String key, Class<T> optionClass) {
        if (this.legendOptions == null) {
            return null;
        }
        Object value = this.legendOptions.get(key);
        if (value == null) {
            return null;
        }
        Object converted = Converters.convert((Object)value, optionClass);
        if (converted == null) {
            throw new ServiceException("Invalid syntax for option " + key + ", cannot be convered to a " + optionClass.getSimpleName());
        }
        return (T)converted;
    }

    public Map<String, Object> getKvp() {
        return this.kvp;
    }

    public void setKvp(Map<String, Object> kvp) {
        this.kvp = kvp;
    }

    public WMS getWms() {
        return this.wms;
    }

    public void setWms(WMS wms) {
        this.wms = wms;
    }

    public static class LegendRequest {
        private String layer;
        private Name layerName;
        private FeatureType featureType;
        private String styleName;
        private String title;
        private String rule;
        private Style style;
        private LegendInfo legendInfo;
        private LayerInfo layerInfo;
        private LayerGroupInfo layerGroupInfo;

        public LegendRequest() {
            this.layer = "";
            this.featureType = null;
            this.layerName = new NameImpl("");
        }

        public LegendRequest(FeatureType featureType) {
            if (featureType == null) {
                throw new NullPointerException("FeatureType required for LegendRequest");
            }
            this.featureType = featureType;
            this.layerName = featureType.getName();
        }

        public LegendRequest(FeatureType featureType, Name layerName) {
            if (featureType == null) {
                throw new NullPointerException("FeatureType required for LegendRequest");
            }
            this.featureType = featureType;
            this.layerName = layerName;
        }

        public String getLayer() {
            return this.layer;
        }

        public void setLayer(String layerName) {
            this.layer = layerName;
        }

        public Name getLayerName() {
            return this.layerName;
        }

        public FeatureType getFeatureType() {
            return this.featureType;
        }

        public void setFeatureType(FeatureType featureType) {
            this.featureType = featureType;
        }

        public LayerGroupInfo getLayerGroupInfo() {
            return this.layerGroupInfo;
        }

        public void setLayerGroupInfo(LayerGroupInfo layerGroupInfo) {
            this.layerGroupInfo = layerGroupInfo;
        }

        public LayerInfo getLayerInfo() {
            return this.layerInfo;
        }

        public void setLayerInfo(LayerInfo layerInfo) {
            this.layerInfo = layerInfo;
        }

        public String getRule() {
            if ("".equals(this.rule)) {
                return null;
            }
            return this.rule;
        }

        public void setRule(String rule) {
            this.rule = rule;
        }

        public String getStyleName() {
            return this.styleName;
        }

        public void setStyleName(String styleName) {
            this.styleName = styleName;
        }

        public String getTitle() {
            if (this.title == null || "".equals(this.title)) {
                this.title = this.getLayerName().getLocalPart();
            }
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Style getStyle() {
            return this.style;
        }

        public void setStyle(Style style) {
            this.style = style;
            if (style != null) {
                this.styleName = style.getName();
            }
        }

        public LegendInfo getLegendInfo() {
            return this.legendInfo;
        }

        public void setLegendInfo(LegendInfo legendInfo) {
            this.legendInfo = legendInfo;
        }

        public String toString() {
            return "LegendRequest [layer=" + this.layer + ", name=" + String.valueOf(this.layerName) + " styleName=" + this.styleName + ", title=" + this.title + ", legendInfo=" + String.valueOf(this.legendInfo) + "]";
        }
    }
}

