/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.RenderingHints;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.CachedGridReaderLayer;
import org.geoserver.wms.GetMapCallback;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.RenderingVariables;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.map.MetatileMapOutputFormat;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.FeatureTypeConstraint;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.Filters;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.WebMapServer;
import org.geotools.ows.wms.map.WMSLayer;
import org.geotools.ows.wmts.WebMapTileServer;
import org.geotools.ows.wmts.map.WMTSMapLayer;
import org.geotools.ows.wmts.model.WMTSLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;

public class GetMap {
    private static final Logger LOGGER = Logging.getLogger(GetMap.class);
    private FilterFactory ff;
    private final WMS wms;
    private List<GetMapCallback> callbacks;

    public GetMap(WMS wms) {
        this.wms = wms;
        this.ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        this.callbacks = GeoServerExtensions.extensions(GetMapCallback.class);
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.ff = filterFactory;
    }

    public void setGetMapCallbacks(List<GetMapCallback> callbacks) {
        this.callbacks.clear();
        this.callbacks.addAll(callbacks);
    }

    public WebMap run(GetMapRequest request) throws ServiceException {
        request = this.fireInitRequest(request);
        WMSMapContent mapContent = new WMSMapContent(request);
        mapContent.setGetMapCallbacks(this.callbacks);
        try {
            WebMap map = this.run(request, mapContent);
            map = this.fireFinished(map);
            return map;
        }
        catch (Throwable t) {
            mapContent.dispose();
            this.fireFailed(t);
            if (t instanceof RuntimeException) {
                RuntimeException exception = (RuntimeException)t;
                throw exception;
            }
            if (t instanceof Error) {
                Error error = (Error)t;
                throw error;
            }
            throw new ServiceException("Internal error ", t);
        }
    }

    private GetMapRequest fireInitRequest(GetMapRequest request) {
        for (GetMapCallback callback : this.callbacks) {
            request = callback.initRequest(request);
        }
        return request;
    }

    private void fireMapContentInit(WMSMapContent mapContent) {
        for (GetMapCallback callback : this.callbacks) {
            callback.initMapContent(mapContent);
        }
    }

    private WMSMapContent fireBeforeRender(WMSMapContent mapContent) {
        for (GetMapCallback callback : this.callbacks) {
            mapContent = callback.beforeRender(mapContent);
        }
        return mapContent;
    }

    private WebMap fireFinished(WebMap result) {
        for (GetMapCallback callback : this.callbacks) {
            result = callback.finished(result);
        }
        return result;
    }

    private void fireFailed(Throwable t) {
        for (GetMapCallback callback : this.callbacks) {
            callback.failed(t);
        }
    }

    public WebMap run(GetMapRequest request, WMSMapContent mapContent) throws ServiceException, IOException {
        this.assertMandatory(request);
        String outputFormat = request.getFormat();
        GetMapOutputFormat delegate = this.getDelegate(outputFormat);
        boolean isTiled = MetatileMapOutputFormat.isRequestTiled(request, delegate);
        MapProducerCapabilities cap = delegate.getCapabilities(request.getFormat());
        if (cap != null && !cap.isTiledRequestsSupported() && isTiled) {
            throw new ServiceException("Format " + request.getFormat() + " does not support tiled requests");
        }
        if (MetatileMapOutputFormat.isRequestTiled(request, delegate)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Tiled request detected, activating on the fly meta tiler");
            }
            delegate = new MetatileMapOutputFormat(request, (RenderedImageMapOutputFormat)delegate);
        }
        List<Object> times = request.getTime();
        List<Object> elevations = request.getElevation();
        return this.executeInternal(mapContent, request, delegate, times, elevations);
    }

    WebMap executeInternal(WMSMapContent mapContent, GetMapRequest request, GetMapOutputFormat delegate, List<Object> times, List<Object> elevations) throws IOException {
        Envelope envelope = request.getBbox();
        List<MapLayerInfo> layers = request.getLayers();
        List<Map<String, String>> viewParams = request.getViewParams();
        Style[] styles = request.getStyles().toArray(new Style[0]);
        Filter[] filters = this.buildLayersFilters(request.getFilter(), layers);
        List<SortBy[]> sorts = request.getSortByArrays();
        CoordinateReferenceSystem mapcrs = request.getCrs();
        if (mapcrs != null) {
            mapContent.getViewport().setBounds(new ReferencedEnvelope(envelope, mapcrs));
        } else {
            mapContent.getViewport().setBounds(new ReferencedEnvelope(envelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        }
        mapContent.setMapWidth(request.getWidth());
        mapContent.setMapHeight(request.getHeight());
        mapContent.setAngle(request.getAngle());
        mapContent.setBgColor(request.getBgColor());
        mapContent.setTransparent(request.isTransparent());
        mapContent.setBuffer(request.getBuffer());
        mapContent.setPalette(request.getPalette());
        if (request.getWidth() <= 0 || request.getHeight() <= 0 || mapContent.getRenderingArea().getSpan(0) <= 0.0 || mapContent.getRenderingArea().getSpan(1) <= 0.0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("We are not going to render anything because either the area is null or the dimensions are not positive.");
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up map");
        }
        this.fireMapContentInit(mapContent);
        boolean cachingPossible = request.isGet();
        String featureVersion = request.getFeatureVersion();
        int maxAge = Integer.MAX_VALUE;
        for (int i = 0; i < layers.size(); ++i) {
            MapLayerInfo mapLayerInfo = layers.get(i);
            if (cachingPossible &= mapLayerInfo.isCachingEnabled()) {
                maxAge = Math.min(maxAge, mapLayerInfo.getCacheMaxAge());
            } else {
                cachingPossible = false;
            }
            Style layerStyle = styles[i];
            Filter layerFilter = SimplifyingFilterVisitor.simplify((Filter)filters[i]);
            SortBy[] layerSort = sorts != null ? sorts.get(i) : null;
            int layerType = mapLayerInfo.getType();
            if (layerType == MapLayerInfo.TYPE_REMOTE_VECTOR) {
                this.addRemoteVectorLayer(mapContent, request, featureVersion, mapLayerInfo, layerStyle, layerFilter, layerSort);
                continue;
            }
            if (layerType == MapLayerInfo.TYPE_VECTOR) {
                this.wms.checkMaxDimensions(mapLayerInfo, times, elevations, false);
                this.addLocalVectorLayer(mapContent, request, times, elevations, viewParams, featureVersion, i, mapLayerInfo, layerStyle, layerFilter, layerSort);
                continue;
            }
            if (layerType == MapLayerInfo.TYPE_RASTER) {
                this.wms.checkMaxDimensions(mapLayerInfo, times, elevations, true);
                this.addRasterLayer(mapContent, request, times, elevations, mapLayerInfo, layerStyle, layerFilter, layerSort);
                continue;
            }
            if (layerType == MapLayerInfo.TYPE_WMS) {
                this.addWMSLayer(mapContent, request, i, mapLayerInfo);
                continue;
            }
            if (layerType == MapLayerInfo.TYPE_WMTS) {
                this.addWMTSLayer(mapContent, mapLayerInfo);
                continue;
            }
            throw new IllegalArgumentException("Unknown layer type " + layerType);
        }
        RenderingVariables.setupEnvironmentVariables(mapContent);
        GetMap.setupRenderingBuffer(mapContent, layers);
        mapContent = this.fireBeforeRender(mapContent);
        WebMap map = delegate.produceMap(mapContent);
        if (cachingPossible) {
            map.setResponseHeader("Cache-Control", "max-age=" + maxAge + ", must-revalidate");
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            calendar.add(13, maxAge);
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            map.setResponseHeader("Expires", format.format(calendar.getTime()));
        }
        return map;
    }

    void addWMTSLayer(WMSMapContent mapContent, MapLayerInfo mapLayerInfo) throws IOException {
        WMTSLayerInfo wmtsLayer = (WMTSLayerInfo)mapLayerInfo.getResource();
        WebMapTileServer wmts = wmtsLayer.getStore().getWebMapTileServer(null);
        CoordinateReferenceSystem nativeCRS = wmtsLayer.getNativeCRS();
        WMTSLayer gt2Layer = wmtsLayer.getWMTSLayer(null);
        WMTSMapLayer mapLayer = new WMTSMapLayer(wmts, (Layer)gt2Layer, nativeCRS);
        mapLayer.setTitle(wmtsLayer.prefixedName());
        mapLayer.setRawTime((String)((Request)Dispatcher.REQUEST.get()).getRawKvp().get("time"));
        mapContent.addLayer((org.geotools.map.Layer)mapLayer);
    }

    private void addWMSLayer(WMSMapContent mapContent, GetMapRequest request, int i, MapLayerInfo mapLayerInfo) throws IOException {
        WMSLayer lastWMS;
        WebMapServer otherWMS;
        org.geotools.map.Layer lastLayer;
        boolean isInsideBounnds;
        WMSLayerInfo wmsLayer = (WMSLayerInfo)mapLayerInfo.getResource();
        if (!this.checkWMSLayerMinMaxScale(wmsLayer, mapContent.getScaleDenominator())) {
            return;
        }
        WebMapServer wms = wmsLayer.getStore().getWebMapServer(null);
        Layer gt2Layer = wmsLayer.getWMSLayer(null);
        if (wmsLayer.isMetadataBBoxRespected() && !(isInsideBounnds = this.checkEnvelopOverLapWithNativeBounds(mapContent.getViewport().getBounds(), wmsLayer.getNativeBoundingBox()))) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Get Map Request BBOX is outside Layer " + request.getLayers().get(i).getName() + " metada BoundsIgnoring Layer,Ignoring");
            }
            return;
        }
        boolean merged = false;
        if (!mapContent.layers().isEmpty() && (lastLayer = (org.geotools.map.Layer)mapContent.layers().get(mapContent.layers().size() - 1)) instanceof WMSLayer && (otherWMS = (lastWMS = (WMSLayer)lastLayer).getWebMapServer()).equals(wms)) {
            lastWMS.addLayer(gt2Layer);
            merged = true;
        }
        if (!merged) {
            String style = request.getStyles().get(i).getName();
            style = style == null ? wmsLayer.getForcedRemoteStyle() : style;
            String imageFormat = request.getFormat();
            if (!wmsLayer.isSelectedRemoteStyles(style)) {
                throw new IllegalArgumentException("Unknown remote style " + style + " in cascaded layer " + wmsLayer.getName() + ", , re-configure the layer and WMS Store");
            }
            if (!wmsLayer.isFormatValid(imageFormat)) {
                imageFormat = wmsLayer.getPreferredFormat();
            }
            WMSLayer layer = new WMSLayer(wms, gt2Layer, style, imageFormat);
            gt2Layer.setVendorParameters(wmsLayer.getVendorParameters());
            layer.setTitle(wmsLayer.prefixedName());
            mapContent.addLayer((org.geotools.map.Layer)layer);
        }
    }

    private void addRasterLayer(WMSMapContent mapContent, GetMapRequest request, List<Object> times, List<Object> elevations, MapLayerInfo mapLayerInfo, Style layerStyle, Filter layerFilter, SortBy[] layerSort) throws IOException {
        block6: {
            GridCoverage2DReader reader = (GridCoverage2DReader)mapLayerInfo.getCoverageReader();
            if (reader != null) {
                this.wms.validateRasterDimensions(times, elevations, mapLayerInfo, request);
                GeneralParameterValue[] readParameters = this.wms.getWMSReadParameters(request, mapLayerInfo, layerFilter, layerSort, times, elevations, reader, false);
                try {
                    try {
                        CachedGridReaderLayer layer = new CachedGridReaderLayer(reader, layerStyle, readParameters);
                        layer.setTitle(mapLayerInfo.getCoverage().prefixedName());
                        mapContent.addLayer((org.geotools.map.Layer)layer);
                        break block6;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "Wrapping GC in feature source: " + e.getLocalizedMessage(), e);
                    }
                    throw new ServiceException("Internal error : unable to get reader for this coverage layer " + String.valueOf(mapLayerInfo));
                }
            }
            throw new ServiceException(new StringBuffer("Internal error : unable to get reader for this coverage layer ").append(mapLayerInfo.toString()).toString());
        }
    }

    private void addLocalVectorLayer(WMSMapContent mapContent, GetMapRequest request, List<Object> times, List<Object> elevations, List<Map<String, String>> viewParams, String featureVersion, int i, MapLayerInfo mapLayerInfo, Style layerStyle, Filter layerFilter, SortBy[] layerSort) throws IOException {
        Integer startIndex;
        FeatureSource<? extends FeatureType, ? extends Feature> source;
        try {
            source = mapLayerInfo.getFeatureSource(true, request.getCrs());
            if (layerSort != null) {
                this.validateSort(source, layerSort, mapLayerInfo);
            }
        }
        catch (IOException exp) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, new StringBuffer("Getting feature source: ").append(exp.getMessage()).toString(), exp);
            }
            throw new ServiceException("Internal error", (Throwable)exp);
        }
        FeatureLayer featureLayer = new FeatureLayer(source, layerStyle);
        FeatureTypeInfo featureInfo = mapLayerInfo.getFeature();
        featureLayer.setTitle(featureInfo.prefixedName());
        featureLayer.getUserData().put("abstract", mapLayerInfo.getDescription());
        this.wms.validateVectorDimensions(times, elevations, featureInfo, request);
        Filter dimensionFilter = this.wms.getDimensionFilter(times, elevations, featureInfo, request);
        Filter filter = SimplifyingFilterVisitor.simplify((Filter)Filters.and((FilterFactory)this.ff, (Filter)layerFilter, (Filter)dimensionFilter));
        Query definitionQuery = new Query(source.getSchema().getName().getLocalPart());
        definitionQuery.setVersion(featureVersion);
        definitionQuery.setFilter(filter);
        definitionQuery.setSortBy(layerSort);
        if (viewParams != null) {
            definitionQuery.setHints(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, viewParams.get(i)));
        }
        if ((startIndex = request.getStartIndex()) != null) {
            QueryCapabilities queryCapabilities = source.getQueryCapabilities();
            if (queryCapabilities.isOffsetSupported()) {
                definitionQuery.setStartIndex(startIndex);
            } else {
                throw new ServiceException("startIndex is not supported for the " + mapLayerInfo.getName() + " layer");
            }
        }
        int maxFeatures = request.getMaxFeatures() != null ? request.getMaxFeatures() : Integer.MAX_VALUE;
        definitionQuery.setMaxFeatures(maxFeatures);
        featureLayer.setQuery(definitionQuery);
        mapContent.addLayer((org.geotools.map.Layer)featureLayer);
    }

    private void addRemoteVectorLayer(WMSMapContent mapContent, GetMapRequest request, String featureVersion, MapLayerInfo mapLayerInfo, Style layerStyle, Filter layerFilter, SortBy[] layerSort) {
        SimpleFeatureSource source = mapLayerInfo.getRemoteFeatureSource();
        FeatureLayer featureLayer = new FeatureLayer((FeatureSource)source, layerStyle);
        featureLayer.setTitle(((SimpleFeatureType)mapLayerInfo.getRemoteFeatureSource().getSchema()).getTypeName());
        Query definitionQuery = new Query(((SimpleFeatureType)source.getSchema()).getTypeName());
        definitionQuery.setFilter(layerFilter);
        definitionQuery.setVersion(featureVersion);
        definitionQuery.setSortBy(layerSort);
        int maxFeatures = request.getMaxFeatures() != null ? request.getMaxFeatures() : Integer.MAX_VALUE;
        definitionQuery.setMaxFeatures(maxFeatures);
        featureLayer.setQuery(definitionQuery);
        mapContent.addLayer((org.geotools.map.Layer)featureLayer);
    }

    private void validateSort(FeatureSource<? extends FeatureType, ? extends Feature> source, SortBy[] sort, MapLayerInfo mapLayerInfo) {
        FeatureType ft = source.getSchema();
        for (SortBy sortBy : sort) {
            if (sortBy.getPropertyName().evaluate((Object)ft) != null) continue;
            throw new ServiceException("Sort property '" + sortBy.getPropertyName().getPropertyName() + "' not available in " + mapLayerInfo.getName(), "InvalidParameterValue", "sortBy");
        }
    }

    public static void setupRenderingBuffer(WMSMapContent map, List<MapLayerInfo> layers) {
        if (map.getBuffer() > 0) {
            return;
        }
        int[] layerBuffers = new int[layers.size()];
        boolean computeBuffer = false;
        for (int i = 0; i < layers.size(); ++i) {
            Integer layerBuffer;
            LayerInfo layerInfo = layers.get(i).getLayerInfo();
            if (layerInfo == null || (layerBuffer = (Integer)layerInfo.getMetadata().get("buffer", Integer.class)) == null || layerBuffer <= 0) continue;
            computeBuffer = true;
            layerBuffers[i] = layerBuffer;
        }
        if (computeBuffer) {
            double scaleDenominator = map.getScaleDenominator(true);
            int buffer = 0;
            for (int i = 0; i < layers.size(); ++i) {
                int layerBuffer = layerBuffers[i];
                if (layerBuffer == 0) {
                    layerBuffer = GetMap.computeLayerBuffer(((org.geotools.map.Layer)map.layers().get(i)).getStyle(), scaleDenominator);
                }
                if (layerBuffer <= buffer) continue;
                buffer = layerBuffer;
            }
            map.setBuffer(buffer);
        }
    }

    static int computeLayerBuffer(Style style, double scaleDenominator) {
        double TOLERANCE = 1.0E-6;
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            for (Rule rule : fts.rules()) {
                if (!(rule.getMinScaleDenominator() - 1.0E-6 <= scaleDenominator) || !(rule.getMaxScaleDenominator() + 1.0E-6 > scaleDenominator)) continue;
                estimator.visit(rule);
            }
        }
        return estimator.getBuffer();
    }

    private void assertMandatory(GetMapRequest request) throws ServiceException {
        if (0 >= request.getWidth() || 0 >= request.getHeight()) {
            throw new ServiceException("Missing or invalid requested map size. Parameters WIDTH and HEIGHT shall be present and be integers > 0. Got WIDTH=" + request.getWidth() + ", HEIGHT=" + request.getHeight(), "MissingOrInvalidParameter");
        }
        if (request.getLayers().isEmpty()) {
            throw new ServiceException("No layers have been requested", "LayerNotDefined");
        }
        if (request.getStyles().isEmpty()) {
            throw new ServiceException("No styles have been requested", "StyleNotDefined");
        }
        if (request.getFormat() == null) {
            throw new ServiceException("No output map format requested", "InvalidFormat");
        }
        Envelope env = request.getBbox();
        if (env == null) {
            throw new ServiceException("GetMap requests must include a BBOX parameter.", "MissingBBox");
        }
        if (env.isNull() || env.getWidth() <= 0.0 || env.getHeight() <= 0.0) {
            throw new ServiceException(new StringBuffer("The request bounding box has zero area: ").append(env).toString(), "InvalidBBox");
        }
    }

    private Filter[] buildLayersFilters(List<Filter> requestFilters, List<MapLayerInfo> layers) {
        int nLayers = layers.size();
        if (requestFilters == null || requestFilters.isEmpty()) {
            requestFilters = Collections.nCopies(layers.size(), Filter.INCLUDE);
        } else if (requestFilters.size() != nLayers) {
            throw new IllegalArgumentException("requested filters and number of layers do not match");
        }
        Filter[] combinedList = new Filter[nLayers];
        for (int i = 0; i < nLayers; ++i) {
            MapLayerInfo layer = layers.get(i);
            Filter userRequestedFilter = requestFilters.get(i);
            if (layer.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR || layer.getType() == MapLayerInfo.TYPE_RASTER) {
                combinedList[i] = userRequestedFilter;
                continue;
            }
            if (layer.getType() != MapLayerInfo.TYPE_VECTOR) continue;
            Filter layerDefinitionFilter = layer.getFeature().filter();
            if (layerDefinitionFilter == null) {
                layerDefinitionFilter = Filter.INCLUDE;
            }
            And combined = this.ff.and(layerDefinitionFilter, userRequestedFilter);
            FeatureTypeConstraint[] featureTypeConstraints = layer.getLayerFeatureConstraints();
            if (featureTypeConstraints != null) {
                ArrayList<Filter> filters = new ArrayList<Filter>();
                for (FeatureTypeConstraint featureTypeConstraint : featureTypeConstraints) {
                    filters.add(featureTypeConstraint.getFilter());
                }
                combined = this.ff.and((Filter)combined, (Filter)this.ff.and(filters));
            }
            combinedList[i] = combined;
        }
        return combinedList;
    }

    protected GetMapOutputFormat getDelegate(String outputFormat) throws ServiceException {
        GetMapOutputFormat producer = this.wms.getMapOutputFormat(outputFormat);
        if (producer == null) {
            ServiceException e = new ServiceException("There is no support for creating maps in " + outputFormat + " format", "InvalidFormat");
            e.setCode("InvalidFormat");
            throw e;
        }
        if (!this.wms.isAllowedGetMapFormat(producer)) {
            throw this.wms.unallowedGetMapFormatException(outputFormat);
        }
        return producer;
    }

    private boolean checkWMSLayerMinMaxScale(WMSLayerInfo wmsLayerInfo, double mapScale) {
        if (wmsLayerInfo.getMinScale() == null && wmsLayerInfo.getMaxScale() == null) {
            return true;
        }
        if (wmsLayerInfo.getMinScale() != null && mapScale < wmsLayerInfo.getMinScale()) {
            return false;
        }
        return wmsLayerInfo.getMaxScale() == null || !(mapScale > wmsLayerInfo.getMaxScale());
    }

    private boolean checkEnvelopOverLapWithNativeBounds(ReferencedEnvelope requestEnevelope, ReferencedEnvelope layerEnevelope) {
        try {
            ReferencedEnvelope transformedRequestEnv = requestEnevelope.transform(layerEnevelope.getCoordinateReferenceSystem(), true);
            return !layerEnevelope.intersection((Envelope)transformedRequestEnv).isEmpty();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error in WMSLayerInfo.checkEnvelopOverLapWithNativeBounds", e);
            return false;
        }
    }
}

