/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.RenderedImageAdapter;
import org.eclipse.imagen.RenderedImageList;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.wms.map.RenderedImageTimeDecorator;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.image.util.ImageUtilities;

public class RasterCleaner
extends AbstractDispatcherCallback {
    static final ThreadLocal<List<RenderedImage>> images = new ThreadLocal();
    static final ThreadLocal<List<GridCoverage2D>> coverages = new ThreadLocal();

    public static void addImage(RenderedImage image) {
        if (image == null) {
            return;
        }
        List<RenderedImage> list = images.get();
        if (list == null) {
            list = new ArrayList<RenderedImage>();
            images.set(list);
        }
        list.add(image);
    }

    public static void addCoverage(GridCoverage2D coverage) {
        if (coverage == null) {
            return;
        }
        List<GridCoverage2D> list = coverages.get();
        if (list == null) {
            list = new ArrayList<GridCoverage2D>();
            coverages.set(list);
        }
        list.add(coverage);
    }

    public void finished(Request request) {
        RasterCleaner.cleanup();
    }

    public static void cleanup() {
        RasterCleaner.disposeCoverages();
        RasterCleaner.disposeImages();
    }

    private static void disposeImages() {
        List<RenderedImage> list = images.get();
        if (list != null) {
            images.remove();
            for (RenderedImage image : list) {
                if (image instanceof RenderedImageAdapter) {
                    RenderedImageAdapter adapter = (RenderedImageAdapter)image;
                    image = adapter.getWrappedImage();
                }
                if (image instanceof RenderedImageTimeDecorator) {
                    RenderedImageTimeDecorator decorator = (RenderedImageTimeDecorator)image;
                    image = decorator.getDelegate();
                }
                if (image instanceof RenderedImageList) {
                    RenderedImageList ril = (RenderedImageList)image;
                    for (Object o : ril) {
                        RasterCleaner.disposeImage((RenderedImage)o);
                    }
                    continue;
                }
                RasterCleaner.disposeImage(image);
            }
            list.clear();
        }
    }

    public static void disposeImage(RenderedImage image) {
        if (image instanceof PlanarImage) {
            PlanarImage planarImage = (PlanarImage)image;
            ImageUtilities.disposePlanarImageChain((PlanarImage)planarImage);
        } else if (image instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)image;
            bi.flush();
        }
    }

    private static void disposeCoverages() {
        List<GridCoverage2D> list = coverages.get();
        if (list != null) {
            coverages.remove();
            for (GridCoverage2D coverage : list) {
                coverage.dispose(true);
            }
            list.clear();
        }
    }

    public List<RenderedImage> getImages() {
        return images.get();
    }

    public List<GridCoverage2D> getCoverages() {
        return coverages.get();
    }
}

