/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wms.FeatureInfoRequestParameters;
import org.geoserver.wms.WMSMapContent;
import org.geotools.api.data.Query;
import org.geotools.filter.function.EnvFunction;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class RenderingVariables {
    static final Logger LOGGER = Logging.getLogger(RenderingVariables.class);
    public static final String WMS_BBOX = "wms_bbox";
    public static final String WMS_SRS = "wms_srs";
    public static final String WMS_WIDTH = "wms_width";
    public static final String WMS_HEIGHT = "wms_height";
    public static final String WMS_SCALE_DENOMINATOR = "wms_scale_denominator";
    public static final String WMS_CRS = "wms_crs";

    public static void setupEnvironmentVariables(FeatureInfoRequestParameters params) {
        EnvFunction.setLocalValue((String)WMS_BBOX, (Object)params.getRequestedBounds());
        EnvFunction.setLocalValue((String)WMS_SRS, (Object)params.getGetMapRequest().getSRS());
        EnvFunction.setLocalValue((String)WMS_WIDTH, (Object)params.getWidth());
        EnvFunction.setLocalValue((String)WMS_HEIGHT, (Object)params.getHeight());
        EnvFunction.setLocalValue((String)WMS_SCALE_DENOMINATOR, (Object)params.getScaleDenominator());
    }

    public static void setupEnvironmentVariables(WMSMapContent mapContent) {
        EnvFunction.setLocalValue((String)WMS_BBOX, (Object)mapContent.getRenderingArea());
        EnvFunction.setLocalValue((String)WMS_CRS, (Object)mapContent.getRenderingArea().getCoordinateReferenceSystem());
        EnvFunction.setLocalValue((String)WMS_SRS, (Object)mapContent.getRequest().getSRS());
        EnvFunction.setLocalValue((String)WMS_WIDTH, (Object)mapContent.getMapWidth());
        EnvFunction.setLocalValue((String)WMS_HEIGHT, (Object)mapContent.getMapHeight());
        try {
            double scaleDenominator = mapContent.getScaleDenominator(true);
            EnvFunction.setLocalValue((String)WMS_SCALE_DENOMINATOR, (Object)scaleDenominator);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to compute the scale denominator, wms_scale_denominator env variable is unset", e);
        }
    }

    public static void setQueryHintsFromEnv(FeatureLayer layer) {
        Query query = RenderingVariables.setHintsToQuery(layer.getQuery());
        layer.setQuery(query);
    }

    public static Query setHintsToQuery(Query query) {
        Query resultQuery = new Query(query);
        HashMap<String, String> virtualTableParamsMap = (HashMap<String, String>)resultQuery.getHints().get((Object)Hints.VIRTUAL_TABLE_PARAMETERS);
        if (virtualTableParamsMap == null) {
            virtualTableParamsMap = new HashMap<String, String>();
            resultQuery.getHints().put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, virtualTableParamsMap);
        }
        Map localValues = EnvFunction.getLocalValues();
        RenderingVariables.setValueIfNotPresent(virtualTableParamsMap, localValues, WMS_BBOX, input -> {
            ReferencedEnvelope envelope = (ReferencedEnvelope)input;
            double minX = envelope.getMinX();
            double minY = envelope.getMinY();
            double maxX = envelope.getMaxX();
            double maxY = envelope.getMaxY();
            return String.format(Locale.ENGLISH, "%.6f,%.6f,%.6f,%.6f", minX, minY, maxX, maxY);
        });
        RenderingVariables.setValueIfNotPresent(virtualTableParamsMap, localValues, WMS_SRS);
        RenderingVariables.setValueIfNotPresent(virtualTableParamsMap, localValues, WMS_WIDTH, String::valueOf);
        RenderingVariables.setValueIfNotPresent(virtualTableParamsMap, localValues, WMS_HEIGHT, String::valueOf);
        RenderingVariables.setValueIfNotPresent(virtualTableParamsMap, localValues, WMS_SCALE_DENOMINATOR, String::valueOf);
        return resultQuery;
    }

    private static void setValueIfNotPresent(Map<String, String> virtualTableParamsMap, Map<String, Object> localValues, String key) {
        String uppercasedKey = key.toUpperCase();
        if (!virtualTableParamsMap.containsKey(key) && localValues.containsKey(uppercasedKey)) {
            virtualTableParamsMap.put(key, (String)localValues.get(uppercasedKey));
        }
    }

    private static void setValueIfNotPresent(Map<String, String> virtualTableParamsMap, Map<String, Object> localValues, String key, Function<Object, String> transformer) {
        String uppercasedKey = key.toUpperCase();
        if (!virtualTableParamsMap.containsKey(key) && localValues.containsKey(uppercasedKey)) {
            virtualTableParamsMap.put(key, transformer.apply(localValues.get(uppercasedKey)));
        }
    }
}

