/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.impl.AdvertisedCatalog;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ImageProcessingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.DimensionFilterBuilder;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.DimensionWarning;
import org.geoserver.util.HTTPWarningAppender;
import org.geoserver.util.NearestMatchFinder;
import org.geoserver.wms.CacheConfiguration;
import org.geoserver.wms.CustomDimensionFilterConverter;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetLegendGraphicOutputFormat;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSExtensions;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.capabilities.DimensionHelper;
import org.geoserver.wms.dimension.DimensionDefaultValueSelectionStrategy;
import org.geoserver.wms.dimension.DimensionDefaultValueSelectionStrategyFactory;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.ows.OperationType;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.SrsSyntax;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.WMSCapabilities;
import org.geotools.referencing.CRS;
import org.geotools.util.Converters;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.Version;
import org.geotools.util.decorate.Wrapper;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class WMS
implements ApplicationContextAware {
    public static final Version VERSION_1_0_0 = new Version("1.0.0");
    public static final Version VERSION_1_1_1 = new Version("1.1.1");
    public static final Version VERSION_1_3_0 = new Version("1.3.0");
    public static final String JPEG_COMPRESSION = "jpegCompression";
    public static final int JPEG_COMPRESSION_DEFAULT = 25;
    public static final String PNG_COMPRESSION = "pngCompression";
    public static final int PNG_COMPRESSION_DEFAULT = 25;
    public static final String SCALEHINT_MAPUNITS_PIXEL = "scalehintMapunitsPixel";
    public static final Boolean SCALEHINT_MAPUNITS_PIXEL_DEFAULT = Boolean.FALSE;
    public static final String DYNAMIC_STYLING_DISABLED = "dynamicStylingDisabled";
    public static final String FEATURES_REPROJECTION_DISABLED = "featuresReprojectionDisabled";
    static final Logger LOGGER = Logging.getLogger(WMS.class);
    public static final String WEB_CONTAINER_KEY = "WMS";
    public static final String SVG_SIMPLE = "Simple";
    public static final String SVG_BATIK = "Batik";
    public static final String DIM_ = "dim_";
    public static String KML_REFLECTOR_MODE = "kmlReflectorMode";
    public static final String KML_REFLECTOR_MODE_REFRESH = "refresh";
    public static final String KML_REFLECTOR_MODE_SUPEROVERLAY = "superoverlay";
    public static final String KML_REFLECTOR_MODE_DOWNLOAD = "download";
    public static final String KML_REFLECTOR_MODE_DEFAULT = "refresh";
    public static final String KML_SUPEROVERLAY_MODE = "kmlSuperoverlayMode";
    public static final String KML_SUPEROVERLAY_MODE_AUTO = "auto";
    public static final String KML_SUPEROVERLAY_MODE_RASTER = "raster";
    public static final String KML_SUPEROVERLAY_MODE_OVERVIEW = "overview";
    public static final String KML_SUPEROVERLAY_MODE_HYBRID = "hybrid";
    public static final String KML_SUPEROVERLAY_MODE_CACHED = "cached";
    public static final String KML_SUPEROVERLAY_MODE_DEFAULT = "auto";
    public static final String KML_KMLATTR = "kmlAttr";
    public static final boolean KML_KMLATTR_DEFAULT = true;
    public static final String KML_KMLPLACEMARK = "kmlPlacemark";
    public static final boolean KML_KMLPLACEMARK_DEFAULT = false;
    public static final String KML_KMSCORE = "kmlKmscore";
    public static final int KML_KMSCORE_DEFAULT = 40;
    public static Boolean ENABLE_MAP_WRAPPING = null;
    public static String MAP_WRAPPING_KEY = "mapWrapping";
    public static Boolean ENABLE_ADVANCED_PROJECTION = null;
    public static String ADVANCED_PROJECTION_KEY = "advancedProjectionHandling";
    public static Boolean ENABLE_ADVANCED_PROJECTION_DENSIFICATION = false;
    public static String ADVANCED_PROJECTION_DENSIFICATION_KEY = "advancedProjectionDensification";
    public static Boolean DISABLE_DATELINE_WRAPPING_HEURISTIC = false;
    public static String DATELINE_WRAPPING_HEURISTIC_KEY = "disableDatelineWrappingHeuristic";
    public static Boolean ROOT_LAYER_IN_CAPABILITIES_DEFAULT = true;
    public static String ROOT_LAYER_IN_CAPABILITIES_KEY = "rootLayerInCapabilities";
    public static final String DISPOSAL_METHOD_NONE = "none";
    public static final String DISPOSAL_METHOD_NOT_DISPOSE = "doNotDispose";
    public static final String DISPOSAL_METHOD_BACKGROUND = "backgroundColor";
    public static final String DISPOSAL_METHOD_PREVIOUS = "previous";
    public static final String DISPOSAL_METHOD_DEFAULT = "none";
    public static final String[] DISPOSAL_METHODS = new String[]{"none", "doNotDispose", "backgroundColor", "previous"};
    private static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    private final GeoServer geoserver;
    private ApplicationContext applicationContext;
    private DimensionDefaultValueSelectionStrategyFactory defaultDimensionValueFactory;

    public WMS(GeoServer geoserver) {
        this.geoserver = geoserver;
    }

    public Catalog getCatalog() {
        return this.geoserver.getCatalog();
    }

    public WMSInfo getServiceInfo() {
        return (WMSInfo)this.geoserver.getService(WMSInfo.class);
    }

    public Style getStyleByName(String styleName) throws IOException {
        StyleInfo styleInfo = this.getCatalog().getStyleByName(styleName);
        return styleInfo == null ? null : styleInfo.getStyle();
    }

    public LayerInfo getLayerByName(String layerName) {
        return this.getCatalog().getLayerByName(layerName);
    }

    public LayerGroupInfo getLayerGroupByName(String layerGroupName) {
        return this.getCatalog().getLayerGroupByName(layerGroupName);
    }

    public boolean isEnabled() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return serviceInfo.isEnabled();
    }

    public boolean exceptionOnInvalidDimension() {
        return this.getServiceInfo().exceptionOnInvalidDimension();
    }

    public static Version negotiateVersion(String requestedVersion) {
        return WMS.negotiateVersion(requestedVersion != null ? new Version(requestedVersion) : null);
    }

    public static Version negotiateVersion(Version requestedVersion) {
        if (null == requestedVersion) {
            return VERSION_1_3_0;
        }
        if (VERSION_1_1_1.equals((Object)requestedVersion)) {
            return VERSION_1_1_1;
        }
        if (VERSION_1_3_0.equals((Object)requestedVersion)) {
            return VERSION_1_3_0;
        }
        if (requestedVersion.compareTo(VERSION_1_3_0) < 0) {
            return VERSION_1_1_1;
        }
        return VERSION_1_3_0;
    }

    public String getVersion() {
        WMSInfo serviceInfo = this.getServiceInfo();
        List versions = serviceInfo.getVersions();
        String version = versions.isEmpty() ? "1.1.1" : ((Version)versions.get(0)).toString();
        return version;
    }

    public void checkMaxDimensions(MapLayerInfo mapLayerInfo, List<Object> times, List<Object> elevations, boolean isCoverage) throws IOException {
        if (this.getServiceInfo() == null || this.getServiceInfo().getMaxRequestedDimensionValues() == 100) {
            return;
        }
        TreeSet<Object> treeSet = new TreeSet<Object>();
        int maxDimensionsToTest = this.getServiceInfo().getMaxRequestedDimensionValues();
        if (times != null && !times.isEmpty() && times.get(0) != null) {
            ListIterator<Object> timesIterator = times.listIterator();
            while (timesIterator.hasNext()) {
                Object time = timesIterator.next();
                if (time instanceof DateRange) {
                    DateRange range = (DateRange)times.get(timesIterator.previousIndex());
                    if (isCoverage) {
                        treeSet.addAll(this.queryCoverageTimes(mapLayerInfo.getCoverage(), range, maxDimensionsToTest + 1));
                    } else {
                        treeSet.addAll(this.queryFeatureTypeTimes(mapLayerInfo.getFeature(), range, maxDimensionsToTest + 1));
                    }
                } else {
                    treeSet.add(time);
                }
                WMS.checkDimensions(treeSet, maxDimensionsToTest, "time");
            }
        }
        if (elevations != null && !elevations.isEmpty() && elevations.get(0) != null) {
            ListIterator<Object> elevationsIterator = elevations.listIterator();
            while (elevationsIterator.hasNext()) {
                Object elevation = elevationsIterator.next();
                if (elevation instanceof NumberRange) {
                    NumberRange range = (NumberRange)elevations.get(elevationsIterator.previousIndex());
                    if (isCoverage) {
                        treeSet.addAll(this.queryCoverageElevations(mapLayerInfo.getCoverage(), range, maxDimensionsToTest + 1));
                    } else {
                        treeSet.addAll(this.queryFeatureTypeElevations(mapLayerInfo.getFeature(), range, maxDimensionsToTest + 1));
                    }
                } else if (elevation instanceof Double) {
                    Double elevationSingle = (Double)elevation;
                    treeSet.add(elevationSingle.intValue());
                } else {
                    treeSet.add(elevation);
                }
                WMS.checkDimensions(treeSet, maxDimensionsToTest, "elevation");
            }
        }
    }

    private static void checkDimensions(TreeSet<Object> treeSet, int maxDimensionsToTest, String dimensionName) {
        if (treeSet.size() > maxDimensionsToTest) {
            throw new ServiceException("This request would process more " + dimensionName + " than the maximum allowed: " + maxDimensionsToTest + ". Please reduce the size of the requested " + dimensionName + " range.", "InvalidParameterValue", dimensionName);
        }
    }

    public GeoServer getGeoServer() {
        return this.geoserver;
    }

    public WMSInfo.WMSInterpolation getInterpolation() {
        return this.getServiceInfo().getInterpolation();
    }

    public boolean isDynamicStylingDisabled() {
        return this.getServiceInfo().isDynamicStylingDisabled();
    }

    public boolean isFeaturesReprojectionDisabled() {
        return this.getServiceInfo().isFeaturesReprojectionDisabled();
    }

    public ImageProcessingInfo.PngEncoderType getPNGEncoderType() {
        ImageProcessingInfo ImageProcessingInfo2 = this.getImageProcessingInfo();
        return ImageProcessingInfo2.getPngEncoderType();
    }

    private ImageProcessingInfo getImageProcessingInfo() {
        GeoServer geoServer = this.getGeoServer();
        GeoServerInfo global = geoServer.getGlobal();
        return global.getImageProcessing();
    }

    public Charset getCharSet() {
        GeoServer geoServer2 = this.getGeoServer();
        String charset = geoServer2.getSettings().getCharset();
        return Charset.forName(charset);
    }

    public String getProxyBaseUrl() {
        GeoServer geoServer = this.getGeoServer();
        return geoServer.getSettings().getProxyBaseUrl();
    }

    public long getUpdateSequence() {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        return global.getUpdateSequence();
    }

    public int getWatermarkTransparency() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        return watermark.getTransparency();
    }

    public int getWatermarkPosition() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        WatermarkInfo.Position position = watermark.getPosition();
        return position.getCode();
    }

    public boolean isGlobalWatermarking() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        return watermark.isEnabled();
    }

    public String getGlobalWatermarkingURL() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        return watermark.getURL();
    }

    public boolean isRemoteStylesCacheEnabled() {
        CacheConfiguration cache = this.getServiceInfo().getCacheConfiguration();
        return cache != null && cache.isEnabled();
    }

    public CacheConfiguration getRemoteResourcesCacheConfiguration() {
        return this.getServiceInfo().getCacheConfiguration();
    }

    public void setRemoteResourcesCacheConfiguration(CacheConfiguration cacheCfg) {
        this.getServiceInfo().setCacheConfiguration(cacheCfg);
    }

    public FeatureTypeInfo getFeatureTypeInfo(Name name) {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo resource = (FeatureTypeInfo)catalog.getResourceByName(name, FeatureTypeInfo.class);
        return resource;
    }

    public CoverageInfo getCoverageInfo(Name name) {
        Catalog catalog = this.getCatalog();
        CoverageInfo resource = (CoverageInfo)catalog.getResourceByName(name, CoverageInfo.class);
        return resource;
    }

    public WMSLayerInfo getWMSLayerInfo(Name name) {
        Catalog catalog = this.getCatalog();
        WMSLayerInfo resource = (WMSLayerInfo)catalog.getResourceByName(name, WMSLayerInfo.class);
        return resource;
    }

    public ResourceInfo getResourceInfo(Name name) {
        Catalog catalog = this.getCatalog();
        ResourceInfo resource = catalog.getResourceByName(name, ResourceInfo.class);
        return resource;
    }

    public List<LayerInfo> getLayers() {
        Catalog catalog = this.getCatalog();
        return catalog.getLayers();
    }

    public String getNamespaceByPrefix(String prefix) {
        Catalog catalog = this.getCatalog();
        NamespaceInfo namespaceInfo = catalog.getNamespaceByPrefix(prefix);
        return namespaceInfo == null ? null : namespaceInfo.getURI();
    }

    public List<LayerGroupInfo> getLayerGroups() {
        Catalog catalog = this.getCatalog();
        List layerGroups = catalog.getLayerGroups();
        return layerGroups;
    }

    public boolean supportsSLD() {
        return true;
    }

    public boolean supportsUserLayer() {
        return true;
    }

    public boolean supportsUserStyle() {
        return true;
    }

    public boolean supportsRemoteWFS() {
        return true;
    }

    public void setSvgRenderer(String svgRendererHint) {
        WMSInfo serviceInfo = this.getServiceInfo();
        serviceInfo.getMetadata().put("svgRenderer", (Serializable)((Object)svgRendererHint));
        this.getGeoServer().save((ServiceInfo)serviceInfo);
    }

    public String getSvgRenderer() {
        WMSInfo serviceInfo = this.getServiceInfo();
        String svgRendererHint = (String)((Object)serviceInfo.getMetadata().get((Object)"svgRenderer"));
        return svgRendererHint;
    }

    public boolean isSvgAntiAlias() {
        WMSInfo serviceInfo = this.getServiceInfo();
        Boolean svgAntiAlias = (Boolean)Converters.convert((Object)serviceInfo.getMetadata().get((Object)"svgAntiAlias"), Boolean.class);
        return svgAntiAlias == null ? true : svgAntiAlias;
    }

    public int getPngCompression() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return this.getMetadataPercentage(serviceInfo.getMetadata(), PNG_COMPRESSION, 25);
    }

    public int getJpegCompression() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return this.getMetadataPercentage(serviceInfo.getMetadata(), JPEG_COMPRESSION, 25);
    }

    public boolean isContinuousMapWrappingEnabled() {
        Boolean enabled = this.getMetadataValue(MAP_WRAPPING_KEY, ENABLE_MAP_WRAPPING, Boolean.class);
        return enabled;
    }

    public boolean isAdvancedProjectionHandlingEnabled() {
        Boolean enabled = this.getMetadataValue(ADVANCED_PROJECTION_KEY, ENABLE_ADVANCED_PROJECTION, Boolean.class);
        return enabled;
    }

    public boolean isAdvancedProjectionDensificationEnabled() {
        Boolean enabled = this.getMetadataValue(ADVANCED_PROJECTION_DENSIFICATION_KEY, ENABLE_ADVANCED_PROJECTION_DENSIFICATION, Boolean.class);
        return enabled;
    }

    public boolean isDateLineWrappingHeuristicDisabled() {
        Boolean disabled = this.getMetadataValue(DATELINE_WRAPPING_HEURISTIC_KEY, DISABLE_DATELINE_WRAPPING_HEURISTIC, Boolean.class);
        return disabled;
    }

    public boolean isRootLayerInCapabilitesEnabled() {
        return this.getMetadataValue(ROOT_LAYER_IN_CAPABILITIES_KEY, ROOT_LAYER_IN_CAPABILITIES_DEFAULT, Boolean.class);
    }

    public Boolean getScalehintUnitPixel() {
        return this.getMetadataValue(SCALEHINT_MAPUNITS_PIXEL, SCALEHINT_MAPUNITS_PIXEL_DEFAULT, Boolean.class);
    }

    int getMetadataPercentage(MetadataMap metadata, String key, int defaultValue) {
        Integer parsedValue = (Integer)Converters.convert((Object)metadata.get((Object)key), Integer.class);
        if (parsedValue == null) {
            return defaultValue;
        }
        int value = parsedValue;
        if (value < 0 || value > 100) {
            LOGGER.warning("Invalid percertage value for '" + key + "', it should be between 0 and 100");
            return defaultValue;
        }
        return value;
    }

    <T> T getMetadataValue(String key, T defaultValue, Class<T> clazz) {
        if (this.getServiceInfo() == null) {
            return defaultValue;
        }
        MetadataMap metadata = this.getServiceInfo().getMetadata();
        Object parsedValue = Converters.convert((Object)metadata.get((Object)key), clazz);
        if (parsedValue == null) {
            return defaultValue;
        }
        return (T)parsedValue;
    }

    public int getNumDecimals() {
        return this.getGeoServer().getSettings().getNumDecimals();
    }

    public String getNameSpacePrefix(String nsUri) {
        Catalog catalog = this.getCatalog();
        NamespaceInfo ns = catalog.getNamespaceByURI(nsUri);
        return ns == null ? null : ns.getPrefix();
    }

    public int getMaxBuffer() {
        return this.getServiceInfo().getMaxBuffer();
    }

    public int getMaxRequestMemory() {
        return this.getServiceInfo().getMaxRequestMemory();
    }

    public int getMaxRenderingTime() {
        return this.getServiceInfo().getMaxRenderingTime();
    }

    public int getMaxRenderingErrors() {
        return this.getServiceInfo().getMaxRenderingErrors();
    }

    public int getMaxRequestedDimensionValues() {
        return this.getServiceInfo().getMaxRequestedDimensionValues();
    }

    public String getKmlReflectorMode() {
        String value = (String)((Object)this.getServiceInfo().getMetadata().get((Object)KML_REFLECTOR_MODE));
        return value != null ? value : "refresh";
    }

    public String getKmlSuperoverlayMode() {
        String value = (String)((Object)this.getServiceInfo().getMetadata().get((Object)KML_SUPEROVERLAY_MODE));
        return value != null ? value : "auto";
    }

    public boolean getKmlKmAttr() {
        Boolean kmAttr = (Boolean)Converters.convert((Object)this.getServiceInfo().getMetadata().get((Object)KML_KMLATTR), Boolean.class);
        return kmAttr == null ? true : kmAttr;
    }

    public boolean getKmlPlacemark() {
        Boolean kmAttr = (Boolean)Converters.convert((Object)this.getServiceInfo().getMetadata().get((Object)KML_KMLPLACEMARK), Boolean.class);
        return kmAttr == null ? false : kmAttr;
    }

    public int getKmScore() {
        return this.getMetadataPercentage(this.getServiceInfo().getMetadata(), KML_KMSCORE, 40);
    }

    public Collection<GetMapOutputFormat> getAllowedMapFormats() {
        ArrayList<GetMapOutputFormat> result = new ArrayList<GetMapOutputFormat>();
        for (GetMapOutputFormat producer : WMSExtensions.findMapProducers(this.applicationContext)) {
            if (!this.isAllowedGetMapFormat(producer)) continue;
            result.add(producer);
        }
        return result;
    }

    public Collection<GetMapOutputFormat> getAvailableMapFormats() {
        return WMSExtensions.findMapProducers(this.applicationContext);
    }

    public Set<String> getAvailableMapFormatNames() {
        List<GetMapOutputFormat> producers = WMSExtensions.findMapProducers(this.applicationContext);
        HashSet<String> formats = new HashSet<String>();
        for (GetMapOutputFormat producer : producers) {
            formats.addAll(producer.getOutputFormatNames());
        }
        return formats;
    }

    public Set<String> getAllowedMapFormatNames() {
        List<GetMapOutputFormat> producers = WMSExtensions.findMapProducers(this.applicationContext);
        HashSet<String> formats = new HashSet<String>();
        for (GetMapOutputFormat producer : producers) {
            if (!this.isAllowedGetMapFormat(producer)) continue;
            formats.addAll(producer.getOutputFormatNames());
        }
        return formats;
    }

    public boolean isAllowedGetMapFormat(GetMapOutputFormat format) {
        if (!this.getServiceInfo().isGetMapMimeTypeCheckingEnabled()) {
            return true;
        }
        Set<String> mimeTypes = this.getServiceInfo().getGetMapMimeTypes();
        return mimeTypes.contains(format.getMimeType());
    }

    public boolean isAllowedGetFeatureInfoFormat(GetFeatureInfoOutputFormat format) {
        if (!this.getServiceInfo().isGetFeatureInfoMimeTypeCheckingEnabled()) {
            return true;
        }
        Set<String> mimeTypes = this.getServiceInfo().getGetFeatureInfoMimeTypes();
        return mimeTypes.contains(format.getContentType());
    }

    public ServiceException unallowedGetFeatureInfoFormatException(String requestFormat) {
        ServiceException e = new ServiceException("Getting feature info using " + requestFormat + " is not allowed", "ForbiddenFormat");
        e.setCode("ForbiddenFormat");
        return e;
    }

    public ServiceException unallowedGetMapFormatException(String requestFormat) {
        ServiceException e = new ServiceException("Creating maps using " + requestFormat + " is not allowed", "ForbiddenFormat");
        e.setCode("ForbiddenFormat");
        return e;
    }

    public Set<String> getAvailableLegendGraphicsFormats() {
        List<GetLegendGraphicOutputFormat> formats = WMSExtensions.findLegendGraphicFormats(this.applicationContext);
        HashSet<String> mimeTypes = new HashSet<String>();
        for (GetLegendGraphicOutputFormat format : formats) {
            mimeTypes.add(format.getContentType());
        }
        return mimeTypes;
    }

    public List<ExtendedCapabilitiesProvider> getAvailableExtendedCapabilitiesProviders() {
        return WMSExtensions.findExtendedCapabilitiesProviders(this.applicationContext);
    }

    @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC"})
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.defaultDimensionValueFactory = (DimensionDefaultValueSelectionStrategyFactory)GeoServerExtensions.extensions(DimensionDefaultValueSelectionStrategyFactory.class).get(0);
        if (ENABLE_MAP_WRAPPING == null) {
            String wrapping = GeoServerExtensions.getProperty((String)"ENABLE_MAP_WRAPPING", (ApplicationContext)applicationContext);
            ENABLE_MAP_WRAPPING = wrapping == null ? Boolean.valueOf(true) : Boolean.valueOf(wrapping);
        }
        if (ENABLE_ADVANCED_PROJECTION == null) {
            String projection = GeoServerExtensions.getProperty((String)"ENABLE_ADVANCED_PROJECTION", (ApplicationContext)applicationContext);
            ENABLE_ADVANCED_PROJECTION = projection == null ? Boolean.valueOf(true) : Boolean.valueOf(projection);
        }
    }

    public GetFeatureInfoOutputFormat getFeatureInfoOutputFormat(String requestFormat) {
        List<GetFeatureInfoOutputFormat> outputFormats = WMSExtensions.findFeatureInfoFormats(this.applicationContext);
        for (GetFeatureInfoOutputFormat format : outputFormats) {
            if (!format.canProduce(requestFormat)) continue;
            return format;
        }
        return null;
    }

    public List<String> getAvailableFeatureInfoFormats() {
        ArrayList<String> mimeTypes = new ArrayList<String>();
        for (GetFeatureInfoOutputFormat format : WMSExtensions.findFeatureInfoFormats(this.applicationContext)) {
            mimeTypes.add(format.getContentType());
        }
        return mimeTypes;
    }

    public List<String> getAllowedFeatureInfoFormats() {
        ArrayList<String> mimeTypes = new ArrayList<String>();
        for (GetFeatureInfoOutputFormat format : WMSExtensions.findFeatureInfoFormats(this.applicationContext)) {
            if (!this.isAllowedGetFeatureInfoFormat(format)) continue;
            mimeTypes.add(format.getContentType());
        }
        return mimeTypes;
    }

    public List<String> getAllowedURLsForAuthForwarding() {
        return this.getServiceInfo().getAllowedURLsForAuthForwarding();
    }

    public GetMapOutputFormat getMapOutputFormat(String mimeType) {
        GetMapOutputFormat outputFormat = WMSExtensions.findMapProducer(mimeType, this.applicationContext);
        return outputFormat;
    }

    public GetLegendGraphicOutputFormat getLegendGraphicOutputFormat(String outputFormat) {
        GetLegendGraphicOutputFormat format = WMSExtensions.findLegendGraphicFormat(outputFormat, this.applicationContext);
        return format;
    }

    public static Version version(String version, Version defaultVersion) {
        Version result = WMS.version(version, false);
        if (result == null) {
            result = defaultVersion;
        }
        return result;
    }

    public static Version version(String version) {
        return WMS.version(version, false);
    }

    public static Version version(String version, boolean exact) {
        if (version == null || version.trim().isEmpty()) {
            return null;
        }
        if (VERSION_1_1_1.toString().equals(version)) {
            return VERSION_1_1_1;
        }
        if (VERSION_1_3_0.toString().equals(version)) {
            return VERSION_1_3_0;
        }
        return exact ? null : new Version(version);
    }

    public static String toInternalSRS(String srs, Version version) {
        if (srs != null && VERSION_1_3_0.equals((Object)version)) {
            if (srs.startsWith("CRS:") || srs.startsWith("MapML:")) {
                return srs;
            }
            try {
                CoordinateReferenceSystem crs = CRS.decode((String)srs);
                if (crs != null) {
                    return GML2EncodingUtils.toURI((CoordinateReferenceSystem)crs, (SrsSyntax)SrsSyntax.OGC_URN, (boolean)false);
                }
            }
            catch (FactoryException e) {
                throw new ServiceException("Could not decode CRS: " + srs, (Throwable)e, ServiceException.InvalidCRS, "crs");
            }
        }
        return srs;
    }

    public boolean isQueryable(LayerInfo layer) {
        try {
            if (layer.getResource() instanceof WMSLayerInfo) {
                WMSLayerInfo info = (WMSLayerInfo)layer.getResource();
                Layer wl = info.getWMSLayer(null);
                if (!wl.isQueryable()) {
                    return false;
                }
                WMSCapabilities caps = info.getStore().getWebMapServer(null).getCapabilities();
                OperationType featureInfo = caps.getRequest().getGetFeatureInfo();
                if (featureInfo == null || !featureInfo.getFormats().contains("application/vnd.ogc.gml")) {
                    return false;
                }
            } else if (layer.getResource() instanceof WMTSLayerInfo) {
                return false;
            }
            return layer.isQueryable();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Failed to determine if the layer is queryable, assuming it's not", e);
            return false;
        }
    }

    public boolean isOpaque(LayerInfo layer) {
        return layer.isOpaque();
    }

    public Integer getCascadedHopCount(LayerInfo layer) {
        if (!(layer.getResource() instanceof WMSLayerInfo)) {
            return null;
        }
        WMSLayerInfo wmsLayerInfo = (WMSLayerInfo)layer.getResource();
        int cascaded = 1;
        try {
            Layer wmsLayer = wmsLayerInfo.getWMSLayer(null);
            cascaded = 1 + wmsLayer.getCascaded();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Unable to determina WMSLayer cascaded hop count", e);
        }
        return cascaded;
    }

    public boolean isQueryable(LayerGroupInfo layerGroup) {
        if (layerGroup.isQueryDisabled()) {
            return false;
        }
        boolean queryable = false;
        List<PublishedInfo> layers = this.getLayersForQueryableChecks(layerGroup);
        for (PublishedInfo published : layers) {
            if (published instanceof LayerInfo) {
                LayerInfo info1 = (LayerInfo)published;
                queryable |= this.isQueryable(info1);
                continue;
            }
            if (!(published instanceof LayerGroupInfo)) continue;
            LayerGroupInfo info = (LayerGroupInfo)published;
            queryable |= this.isQueryable(info);
        }
        return queryable;
    }

    private List<PublishedInfo> getLayersForQueryableChecks(LayerGroupInfo layerGroup) {
        Wrapper wrapper;
        if (layerGroup instanceof AdvertisedCatalog.AdvertisedLayerGroup) {
            AdvertisedCatalog.AdvertisedLayerGroup wrapper2 = (AdvertisedCatalog.AdvertisedLayerGroup)layerGroup;
            layerGroup = wrapper2.unwrap();
        } else if (layerGroup instanceof Wrapper && (wrapper = (Wrapper)layerGroup).isWrapperFor(AdvertisedCatalog.AdvertisedLayerGroup.class)) {
            wrapper.unwrap(AdvertisedCatalog.AdvertisedLayerGroup.class);
            AdvertisedCatalog.AdvertisedLayerGroup alg = (AdvertisedCatalog.AdvertisedLayerGroup)layerGroup;
            layerGroup = alg.unwrap();
        }
        return new LayerGroupHelper(layerGroup).allPublished();
    }

    public GeneralParameterValue[] getWMSReadParameters(GetMapRequest request, MapLayerInfo mapLayerInfo, Filter layerFilter, SortBy[] sortBy, List<Object> times, List<Object> elevations, GridCoverage2DReader reader, boolean readGeom) throws IOException {
        ParameterValue pv;
        GeneralParameterDescriptor pd;
        DimensionInfo elevationInfo;
        int i;
        ParameterValueGroup readParametersDescriptor = reader.getFormat().getReadParameters();
        CoverageInfo coverage = mapLayerInfo.getCoverage();
        MetadataMap metadata = coverage.getMetadata();
        GeneralParameterValue[] readParameters = CoverageUtils.getParameters((ParameterValueGroup)readParametersDescriptor, (Map)coverage.getParameters(), (boolean)readGeom);
        ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
        DimensionInfo timeInfo = (DimensionInfo)metadata.get("time", DimensionInfo.class);
        ArrayList parameterDescriptors = new ArrayList(readParametersDescriptor.getDescriptor().descriptors());
        Set dynamicParameters = reader.getDynamicParameters();
        parameterDescriptors.addAll(dynamicParameters);
        if (timeInfo != null && timeInfo.isEnabled()) {
            List<Object> fixedTimes = new ArrayList<Object>(times);
            for (i = 0; i < fixedTimes.size(); ++i) {
                if (fixedTimes.get(i) == null) {
                    Object defaultTime = this.getDefaultTime((ResourceInfo)coverage);
                    fixedTimes.set(i, defaultTime);
                    HTTPWarningAppender.addWarning((DimensionWarning)DimensionWarning.defaultValue((ResourceInfo)mapLayerInfo.getResource(), (String)"time", (Object)defaultTime));
                }
                if (!timeInfo.isNearestMatchEnabled()) continue;
                fixedTimes = WMS.getNearestTimeMatch((ResourceInfo)coverage, timeInfo, fixedTimes, this.getMaxRenderingTime());
            }
            readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, fixedTimes, (String[])new String[]{"TIME", "Time"});
        }
        if ((elevationInfo = (DimensionInfo)metadata.get("elevation", DimensionInfo.class)) != null && elevationInfo.isEnabled()) {
            ArrayList<Object> fixedElevations = new ArrayList<Object>(elevations);
            for (int i2 = 0; i2 < fixedElevations.size(); ++i2) {
                if (fixedElevations.get(i2) != null) continue;
                Object defaultElevation = this.getDefaultElevation((ResourceInfo)coverage);
                fixedElevations.set(i2, defaultElevation);
                HTTPWarningAppender.addWarning((DimensionWarning)DimensionWarning.defaultValue((ResourceInfo)mapLayerInfo.getResource(), (String)"elevation", (Object)defaultElevation));
            }
            readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, fixedElevations, (String[])new String[]{"ELEVATION", "Elevation"});
        }
        if (layerFilter != null && readParameters != null) {
            for (i = 0; i < readParameters.length; ++i) {
                GeneralParameterValue param = readParameters[i];
                pd = param.getDescriptor();
                if (!pd.getName().getCode().equalsIgnoreCase("FILTER")) continue;
                pv = (ParameterValue)pd.createValue();
                if (layerFilter == Filter.INCLUDE) break;
                pv.setValue((Object)layerFilter);
                readParameters[i] = pv;
                break;
            }
        }
        if (sortBy != null && readParameters != null) {
            for (i = 0; i < readParameters.length; ++i) {
                ParameterDescriptor descriptor;
                GeneralParameterValue param = readParameters[i];
                pd = param.getDescriptor();
                if (!pd.getName().getCode().equalsIgnoreCase("SORTING")) continue;
                pv = (ParameterValue)pd.createValue();
                if (pd instanceof ParameterDescriptor && String.class.equals((Object)(descriptor = (ParameterDescriptor)pd).getValueClass())) {
                    String sortBySpec = Arrays.stream(sortBy).map(this::sortSpecification).collect(Collectors.joining(","));
                    pv.setValue((Object)sortBySpec);
                } else {
                    pv.setValue((Object)sortBy);
                }
                readParameters[i] = pv;
                break;
            }
        }
        ArrayList customDomains = new ArrayList(dimensions.getCustomDomains());
        for (String domain : new ArrayList(customDomains)) {
            List<String> values = request.getCustomDimension(domain);
            if (values == null) continue;
            int maxValues = this.getMaxRequestedDimensionValues();
            if (maxValues > 0 && maxValues < values.size()) {
                throw new ServiceException("More than " + maxValues + " dimension values specified in the request, bailing out.", "InvalidParameterValue", DimensionInfo.getDimensionKey((String)domain));
            }
            readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, (Object)dimensions.convertDimensionValue(domain, values), (String[])new String[]{domain});
            customDomains.remove(domain);
        }
        if (!customDomains.isEmpty()) {
            for (String dimensionName : customDomains) {
                DimensionInfo customInfo = (DimensionInfo)metadata.get("custom_dimension_" + dimensionName, DimensionInfo.class);
                if (customInfo == null || !customInfo.isEnabled()) continue;
                Collection val = dimensions.convertDimensionValue(dimensionName, this.getDefaultCustomDimensionValue(dimensionName, (ResourceInfo)coverage, String.class));
                HTTPWarningAppender.addWarning((DimensionWarning)DimensionWarning.defaultValue((ResourceInfo)mapLayerInfo.getResource(), (String)dimensionName, (Object)val));
                readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, (Object)val, (String[])new String[]{dimensionName});
            }
        }
        return readParameters;
    }

    private String sortSpecification(SortBy sb) {
        return sb.getPropertyName().getPropertyName() + " " + sb.getSortOrder().name().charAt(0);
    }

    public Collection<RenderedImageMapResponse> getAvailableMapResponses() {
        return WMSExtensions.findMapResponses(this.applicationContext);
    }

    public TreeSet<Object> queryCoverageTimes(CoverageInfo coverage, DateRange queryRange, int maxAnimationSteps) throws IOException {
        DimensionInfo time = (DimensionInfo)coverage.getMetadata().get("time", DimensionInfo.class);
        if (time == null || !time.isEnabled()) {
            throw new ServiceException("Layer " + coverage.prefixedName() + " does not have time support enabled");
        }
        GridCoverage2DReader reader = null;
        try {
            reader = (GridCoverage2DReader)coverage.getGridCoverageReader(null, null);
        }
        catch (Throwable t) {
            throw new ServiceException("Unable to acquire a reader for this coverage " + coverage.prefixedName(), t);
        }
        if (reader == null) {
            throw new ServiceException("Unable to acquire a reader for this coverage " + coverage.prefixedName());
        }
        ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
        return dimensions.getTimeDomain(queryRange, maxAnimationSteps);
    }

    public TreeSet<Date> queryCoverageNearestMatchTimes(CoverageInfo coverage, List<Object> queryRanges) throws IOException {
        DimensionInfo time = (DimensionInfo)coverage.getMetadata().get("time", DimensionInfo.class);
        TreeSet<Date> foundDates = new TreeSet<Date>();
        if (time == null || !time.isEnabled()) {
            throw new ServiceException("Coverage " + coverage.prefixedName() + " does not have time support enabled");
        }
        List<Object> dates = WMS.getNearestTimeMatch((ResourceInfo)coverage, time, queryRanges, this.getMaxRenderingTime());
        dates.stream().filter(d -> d instanceof Date).forEach(d -> {
            Date date = (Date)d;
            foundDates.add(date);
        });
        return foundDates;
    }

    private static List<Object> getNearestTimeMatch(ResourceInfo coverage, DimensionInfo dimension, List<Object> queryRanges, int maxRenderingTime) throws IOException {
        NearestMatchFinder finder = NearestMatchFinder.get((ResourceInfo)coverage, (DimensionInfo)dimension, (String)"time");
        if (finder != null) {
            return finder.getMatches(coverage, "time", queryRanges, maxRenderingTime);
        }
        return Collections.emptyList();
    }

    public TreeSet<Object> queryFeatureTypeTimes(FeatureTypeInfo typeInfo, DateRange range, int maxItems) throws IOException {
        return this.queryFeatureTypeDimension(typeInfo, (Range)range, maxItems, "time");
    }

    public TreeSet<Date> getFeatureTypeTimes(FeatureTypeInfo typeInfo) throws IOException {
        DimensionInfo time = (DimensionInfo)typeInfo.getMetadata().get("time", DimensionInfo.class);
        if (time == null || !time.isEnabled()) {
            throw new ServiceException("Layer " + typeInfo.prefixedName() + " does not have time support enabled");
        }
        FeatureCollection collection = this.getDimensionCollection(typeInfo, time);
        TreeSet<Date> result = new TreeSet<Date>();
        String startValue = time.getStartValue();
        String endValue = time.getEndValue();
        if (!StringUtils.isEmpty((String)startValue) && !StringUtils.isEmpty((String)endValue) && time.getPresentation() != DimensionPresentation.LIST) {
            result.add(DimensionHelper.parseTimeRangeValue(startValue));
            result.add(DimensionHelper.parseTimeRangeValue(endValue));
            return result;
        }
        if (time.getPresentation() == DimensionPresentation.LIST) {
            UniqueVisitor visitor = new UniqueVisitor(new String[]{time.getAttribute()});
            collection.accepts((FeatureVisitor)visitor, null);
            Set values = visitor.getUnique();
            if (values.isEmpty()) {
                result = null;
            } else {
                values.remove(null);
                result.addAll(values);
            }
        } else {
            MinVisitor min = new MinVisitor(time.getAttribute());
            collection.accepts((FeatureVisitor)min, null);
            CalcResult minResult = min.getResult();
            if (minResult != CalcResult.NULL_RESULT) {
                result.add((Date)min.getMin());
                MaxVisitor max = new MaxVisitor(time.getEndAttribute() != null ? time.getEndAttribute() : time.getAttribute());
                collection.accepts((FeatureVisitor)max, null);
                result.add((Date)max.getMax());
            }
        }
        return result;
    }

    public TreeSet<Object> queryCoverageElevations(CoverageInfo coverage, NumberRange queryRange, int maxAnimationSteps) throws IOException {
        DimensionInfo elevation = (DimensionInfo)coverage.getMetadata().get("elevation", DimensionInfo.class);
        if (elevation == null || !elevation.isEnabled()) {
            throw new ServiceException("Layer " + coverage.prefixedName() + " does not have elevation support enabled");
        }
        GridCoverage2DReader reader = null;
        try {
            reader = (GridCoverage2DReader)coverage.getGridCoverageReader(null, null);
        }
        catch (Throwable t) {
            throw new ServiceException("Unable to acquire a reader for this coverage " + coverage.prefixedName(), t);
        }
        if (reader == null) {
            throw new ServiceException("Unable to acquire a reader for this coverage " + coverage.prefixedName());
        }
        ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
        return dimensions.getElevationDomain(queryRange, maxAnimationSteps);
    }

    public TreeSet<Double> getFeatureTypeElevations(FeatureTypeInfo typeInfo) throws IOException {
        DimensionInfo elevation = (DimensionInfo)typeInfo.getMetadata().get("elevation", DimensionInfo.class);
        if (elevation == null || !elevation.isEnabled()) {
            throw new ServiceException("Layer " + typeInfo.prefixedName() + " does not have elevation support enabled");
        }
        FeatureCollection collection = this.getDimensionCollection(typeInfo, elevation);
        TreeSet<Double> result = new TreeSet<Double>();
        String startValue = elevation.getStartValue();
        String endValue = elevation.getEndValue();
        if (!StringUtils.isEmpty((String)startValue) && !StringUtils.isEmpty((String)endValue) && elevation.getPresentation() != DimensionPresentation.LIST) {
            result.add(Double.parseDouble(startValue));
            result.add(Double.parseDouble(endValue));
            return result;
        }
        if (elevation.getPresentation() == DimensionPresentation.LIST || elevation.getPresentation() == DimensionPresentation.DISCRETE_INTERVAL && elevation.getResolution() == null) {
            UniqueVisitor visitor = new UniqueVisitor(new String[]{elevation.getAttribute()});
            collection.accepts((FeatureVisitor)visitor, null);
            Set values = visitor.getUnique();
            if (values.isEmpty()) {
                result = null;
            } else {
                for (Object value : values) {
                    result.add(((Number)value).doubleValue());
                }
            }
        } else {
            MinVisitor min = new MinVisitor(elevation.getAttribute());
            collection.accepts((FeatureVisitor)min, null);
            CalcResult calcResult = min.getResult();
            if (calcResult != CalcResult.NULL_RESULT) {
                result.add(((Number)((Object)min.getMin())).doubleValue());
                MaxVisitor max = new MaxVisitor(elevation.getEndAttribute() != null ? elevation.getEndAttribute() : elevation.getAttribute());
                collection.accepts((FeatureVisitor)max, null);
                result.add(((Number)((Object)max.getMax())).doubleValue());
            }
        }
        return result;
    }

    public TreeSet<Object> queryFeatureTypeElevations(FeatureTypeInfo typeInfo, NumberRange range, int maxItems) throws IOException {
        return this.queryFeatureTypeDimension(typeInfo, (Range)range, maxItems, "elevation");
    }

    TreeSet<Object> queryFeatureTypeDimension(FeatureTypeInfo typeInfo, Range range, int maxItems, String dimensionName) throws IOException {
        DimensionInfo di = (DimensionInfo)typeInfo.getMetadata().get(dimensionName, DimensionInfo.class);
        if (di == null || !di.isEnabled()) {
            throw new ServiceException("Layer " + typeInfo.prefixedName() + " does not have " + dimensionName + " support enabled");
        }
        FeatureSource fs = this.getFeatureSource(typeInfo);
        Query query = new Query(fs.getSchema().getName().getLocalPart());
        query.setPropertyNames(Arrays.asList(di.getAttribute()));
        PropertyName attribute = ff.property(di.getAttribute());
        PropertyIsBetween rangeFilter = ff.between((Expression)attribute, (Expression)ff.literal((Object)range.getMinValue()), (Expression)ff.literal((Object)range.getMaxValue()));
        query.setFilter((Filter)rangeFilter);
        query.setMaxFeatures(maxItems);
        FeatureCollection collection = fs.getFeatures(query);
        UniqueVisitor visitor = new UniqueVisitor(new Expression[]{attribute});
        collection.accepts((FeatureVisitor)visitor, null);
        Set uniques = visitor.getUnique();
        TreeSet<Object> result = new TreeSet<Object>(uniques);
        return result;
    }

    public Object getDefaultTime(ResourceInfo resourceInfo) {
        DimensionInfo time = (DimensionInfo)resourceInfo.getMetadata().get("time", DimensionInfo.class);
        if (time == null || !time.isEnabled()) {
            throw new ServiceException("Layer " + resourceInfo.prefixedName() + " does not have time support enabled");
        }
        DimensionDefaultValueSelectionStrategy strategy = this.getDefaultValueStrategy(resourceInfo, "time", time);
        return strategy.getDefaultValue(resourceInfo, "time", time, Date.class);
    }

    public Object getDefaultElevation(ResourceInfo resourceInfo) {
        DimensionInfo elevation = this.getDimensionInfo(resourceInfo, "elevation");
        DimensionDefaultValueSelectionStrategy strategy = this.getDefaultValueStrategy(resourceInfo, "elevation", elevation);
        return strategy.getDefaultValue(resourceInfo, "elevation", elevation, Double.class);
    }

    public DimensionInfo getDimensionInfo(ResourceInfo resourceInfo, String dimensionName) {
        DimensionInfo info = (DimensionInfo)resourceInfo.getMetadata().get(dimensionName, DimensionInfo.class);
        if (info == null || !info.isEnabled()) {
            throw new ServiceException("Layer " + resourceInfo.prefixedName() + " does not have " + dimensionName + " support enabled");
        }
        return info;
    }

    public <T> T getDefaultCustomDimensionValue(String dimensionName, ResourceInfo resourceInfo, Class<T> clz) {
        DimensionInfo customDim = (DimensionInfo)resourceInfo.getMetadata().get("custom_dimension_" + dimensionName, DimensionInfo.class);
        if (customDim == null || !customDim.isEnabled()) {
            throw new ServiceException("Layer " + resourceInfo.prefixedName() + " does not have support enabled for dimension " + dimensionName);
        }
        DimensionDefaultValueSelectionStrategy strategy = this.getDefaultValueStrategy(resourceInfo, "custom_dimension_" + dimensionName, customDim);
        Object result = strategy.getDefaultValue(resourceInfo, "custom_dimension_" + dimensionName, customDim, clz);
        return (T)result;
    }

    public DimensionDefaultValueSelectionStrategy getDefaultValueStrategy(ResourceInfo resource, String dimensionName, DimensionInfo dimensionInfo) {
        if (this.defaultDimensionValueFactory != null) {
            return this.defaultDimensionValueFactory.getStrategy(resource, dimensionName, dimensionInfo);
        }
        return null;
    }

    FeatureCollection getDimensionCollection(FeatureTypeInfo typeInfo, DimensionInfo dimension) throws IOException {
        FeatureSource source = this.getFeatureSource(typeInfo);
        Query dimQuery = new Query(source.getSchema().getName().getLocalPart());
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(dimension.getAttribute());
        if (dimension.getEndAttribute() != null && dimension.getPresentation() != DimensionPresentation.LIST) {
            propertyNames.add(dimension.getEndAttribute());
        }
        dimQuery.setPropertyNames(propertyNames);
        return source.getFeatures(dimQuery);
    }

    FeatureSource getFeatureSource(FeatureTypeInfo typeInfo) {
        FeatureSource source = null;
        try {
            source = typeInfo.getFeatureSource(null, GeoTools.getDefaultHints());
        }
        catch (IOException e) {
            throw new ServiceException("Could not get the feauture source to list time info for layer " + typeInfo.prefixedName(), (Throwable)e);
        }
        return source;
    }

    public Filter getTimeFilter(List<Object> times, FeatureTypeInfo typeInfo, DimensionFilterBuilder builder) throws IOException {
        DimensionInfo timeInfo = (DimensionInfo)typeInfo.getMetadata().get("time", DimensionInfo.class);
        if (timeInfo != null && timeInfo.isEnabled() && times != null) {
            ArrayList<Object> defaultedTimes = new ArrayList<Object>(times.size());
            for (Object datetime : times) {
                if (datetime == null) {
                    datetime = this.getDefaultTime((ResourceInfo)typeInfo);
                    HTTPWarningAppender.addWarning((DimensionWarning)DimensionWarning.defaultValue((ResourceInfo)typeInfo, (String)"time", (Object)datetime));
                }
                defaultedTimes.add(datetime);
            }
            if (timeInfo.isNearestMatchEnabled()) {
                List<Object> nearestMatchedTimes = WMS.getNearestTimeMatch((ResourceInfo)typeInfo, timeInfo, defaultedTimes, this.getMaxRenderingTime());
                builder.appendFilters(timeInfo.getAttribute(), timeInfo.getEndAttribute(), nearestMatchedTimes);
            } else {
                builder.appendFilters(timeInfo.getAttribute(), timeInfo.getEndAttribute(), defaultedTimes);
            }
        }
        return builder.getFilter();
    }

    public Filter getElevationFilter(List<Object> elevations, FeatureTypeInfo typeInfo, DimensionFilterBuilder builder) throws IOException {
        DimensionInfo elevationInfo = (DimensionInfo)typeInfo.getMetadata().get("elevation", DimensionInfo.class);
        if (elevationInfo != null && elevationInfo.isEnabled() && elevations != null) {
            ArrayList<Object> defaultedElevations = new ArrayList<Object>(elevations.size());
            for (Object elevation : elevations) {
                if (elevation == null) {
                    elevation = this.getDefaultElevation((ResourceInfo)typeInfo);
                    HTTPWarningAppender.addWarning((DimensionWarning)DimensionWarning.defaultValue((ResourceInfo)typeInfo, (String)"elevation", (Object)elevation));
                }
                defaultedElevations.add(elevation);
            }
            builder.appendFilters(elevationInfo.getAttribute(), elevationInfo.getEndAttribute(), defaultedElevations);
        }
        return builder.getFilter();
    }

    public void validateVectorDimensions(List<Object> times, List<Object> elevations, FeatureTypeInfo typeInfo, GetMapRequest request) throws IOException {
        if (!this.exceptionOnInvalidDimension()) {
            return;
        }
        FeatureSource fs = typeInfo.getFeatureSource(null, null);
        this.validateTimes(times, typeInfo, (FeatureSource<? extends FeatureType, ? extends Feature>)fs, request);
        this.validateElevations(elevations, typeInfo, (FeatureSource<? extends FeatureType, ? extends Feature>)fs, request);
        this.validateCustomDimensions(typeInfo, (FeatureSource<? extends FeatureType, ? extends Feature>)fs, request);
    }

    private void validateCustomDimensions(FeatureTypeInfo typeInfo, FeatureSource<? extends FeatureType, ? extends Feature> fs, GetMapRequest request) throws IOException {
        CustomDimensionFilterConverter converter = this.getCustomDimensionFilterConverter(typeInfo);
        Map<String, DimensionInfo> dimensions = converter.getCustomDimensions();
        for (String dimension : dimensions.keySet()) {
            DimensionFilterBuilder filterBuilder = new DimensionFilterBuilder(ff);
            converter.getDimensionsToFilter(request.getRawKvp(), filterBuilder);
            Query dimensionQuery = WMS.getDimensionQuery(filterBuilder.getFilter(), dimensions.get(dimension), typeInfo.getFeatureType().getName().getLocalPart());
            if (DataUtilities.first((FeatureCollection)fs.getFeatures(dimensionQuery)) != null) continue;
            String key = (DIM_ + dimension).toUpperCase();
            WMS.throwInvalidDimensionValue(request, dimension, key);
        }
    }

    private void validateTimes(List<Object> times, FeatureTypeInfo typeInfo, FeatureSource<? extends FeatureType, ? extends Feature> fs, GetMapRequest request) throws IOException {
        DimensionInfo timeInfo = (DimensionInfo)typeInfo.getMetadata().get("time", DimensionInfo.class);
        if (timeInfo == null || !timeInfo.isEnabled() || timeInfo.isNearestMatchEnabled()) {
            return;
        }
        if (times != null) {
            DimensionFilterBuilder builder = new DimensionFilterBuilder(ff);
            List<Object> explicitTimes = times.stream().filter(Objects::nonNull).collect(Collectors.toList());
            Query dimensionQuery = WMS.getDimensionQuery(this.getTimeFilter(explicitTimes, typeInfo, builder), timeInfo, typeInfo.getFeatureType().getName().getLocalPart());
            if (DataUtilities.first((FeatureCollection)fs.getFeatures(dimensionQuery)) == null) {
                WMS.throwInvalidDimensionValue(request, "time", "time");
            }
        }
    }

    private void validateElevations(List<Object> elevations, FeatureTypeInfo typeInfo, FeatureSource<? extends FeatureType, ? extends Feature> fs, GetMapRequest request) throws IOException {
        DimensionInfo elevationInfo = (DimensionInfo)typeInfo.getMetadata().get("elevation", DimensionInfo.class);
        if (elevationInfo == null || !elevationInfo.isEnabled()) {
            return;
        }
        if (elevations != null) {
            DimensionFilterBuilder builder = new DimensionFilterBuilder(ff);
            List<Object> explicitElevations = elevations.stream().filter(Objects::nonNull).collect(Collectors.toList());
            Query dimensionQuery = WMS.getDimensionQuery(this.getElevationFilter(explicitElevations, typeInfo, builder), elevationInfo, typeInfo.getFeatureType().getName().getLocalPart());
            if (DataUtilities.first((FeatureCollection)fs.getFeatures(dimensionQuery)) == null) {
                WMS.throwInvalidDimensionValue(request, "elevation", "elevation");
            }
        }
    }

    private static Query getDimensionQuery(Filter filter, DimensionInfo dimensionInfo, String typeName) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(dimensionInfo.getAttribute());
        if (dimensionInfo.getEndAttribute() != null && dimensionInfo.getPresentation() != DimensionPresentation.LIST) {
            propertyNames.add(dimensionInfo.getEndAttribute());
        }
        Query query = new Query(typeName, filter);
        query.setPropertyNames(propertyNames);
        query.setMaxFeatures(1);
        return query;
    }

    public Filter getDimensionFilter(List<Object> times, List<Object> elevations, FeatureTypeInfo featureTypeInfo, GetMapRequest request) throws IOException {
        DimensionFilterBuilder builder = new DimensionFilterBuilder(ff);
        this.getTimeFilter(times, featureTypeInfo, builder);
        this.getElevationFilter(elevations, featureTypeInfo, builder);
        if (request != null) {
            this.getCustomDimensionFilter(request.getRawKvp(), featureTypeInfo, builder);
        }
        return builder.getFilter();
    }

    @Deprecated
    public Filter getTimeElevationToFilter(List<Object> times, List<Object> elevations, FeatureTypeInfo typeInfo) throws IOException {
        DimensionFilterBuilder builder = new DimensionFilterBuilder(ff);
        this.getTimeFilter(times, typeInfo, builder);
        this.getElevationFilter(elevations, typeInfo, builder);
        return builder.getFilter();
    }

    @Deprecated
    public Filter getDimensionsToFilter(Map<String, String> rawKVP, FeatureTypeInfo typeInfo) {
        DimensionFilterBuilder builder = new DimensionFilterBuilder(ff);
        return this.getCustomDimensionFilter(rawKVP, typeInfo, builder);
    }

    public Filter getCustomDimensionFilter(Map<String, String> rawKVP, FeatureTypeInfo typeInfo, DimensionFilterBuilder builder) {
        CustomDimensionFilterConverter converter = this.getCustomDimensionFilterConverter(typeInfo);
        return converter.getDimensionsToFilter(rawKVP, builder);
    }

    private CustomDimensionFilterConverter getCustomDimensionFilterConverter(FeatureTypeInfo typeInfo) {
        CustomDimensionFilterConverter.DefaultValueStrategyFactory defaultValueStrategyFactory = (resource, dimensionName, dimensionInfo) -> this.getDefaultValueStrategy(resource, dimensionName, dimensionInfo);
        CustomDimensionFilterConverter converter = new CustomDimensionFilterConverter(typeInfo, defaultValueStrategyFactory);
        return converter;
    }

    public void validateRasterDimensions(List<Object> times, List<Object> elevations, MapLayerInfo mapLayerInfo, GetMapRequest request) throws IOException {
        if (!this.exceptionOnInvalidDimension()) {
            return;
        }
        CoverageInfo coverage = mapLayerInfo.getCoverage();
        Map<String, DimensionInfo> dimensions = coverage.getMetadata().entrySet().stream().filter(e -> e.getValue() instanceof DimensionInfo).filter(e -> ((DimensionInfo)e.getValue()).isEnabled()).filter(e -> !((DimensionInfo)e.getValue()).isNearestMatchEnabled()).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (DimensionInfo)e.getValue()));
        ReaderDimensionsAccessor accessor = new ReaderDimensionsAccessor((GridCoverage2DReader)mapLayerInfo.getCoverageReader());
        for (Map.Entry<String, DimensionInfo> entry : dimensions.entrySet()) {
            String key = entry.getKey().replaceFirst(DIM_, "");
            if (key.equalsIgnoreCase("time")) {
                List nonDefaultTimes = times.stream().filter(t -> t != null).collect(Collectors.toList());
                if (nonDefaultTimes.isEmpty() || accessor.hasAnyTime(nonDefaultTimes)) continue;
                WMS.throwInvalidDimensionValue(request, "time", key);
                continue;
            }
            if (key.equalsIgnoreCase("elevation")) {
                List nonDefaultElevations = elevations.stream().filter(e -> e != null).collect(Collectors.toList());
                if (nonDefaultElevations.isEmpty() || accessor.hasAnyElevation(nonDefaultElevations)) continue;
                WMS.throwInvalidDimensionValue(request, "elevation", key);
                continue;
            }
            List<String> values = request.getCustomDimension(key = key.replaceFirst("custom_dimension_", ""));
            if (values == null || accessor.hasAnyCustomDimension(key, values)) continue;
            WMS.throwInvalidDimensionValue(request, key, (DIM_ + key).toUpperCase());
        }
    }

    private static void throwInvalidDimensionValue(GetMapRequest request, String dimension, String key) {
        throw new ServiceException("Could not find a match for '%s' value: '%s'".formatted(dimension, request.getRawKvp().get(key)), "InvalidDimensionValue", key);
    }

    public int getMaxRenderingTime(GetMapRequest request) {
        int localMaxRenderingTime = 0;
        Object timeoutOption = request.getFormatOptions().get("timeout");
        if (timeoutOption != null) {
            try {
                localMaxRenderingTime = Integer.parseInt(timeoutOption.toString());
            }
            catch (NumberFormatException e) {
                RenderedImageMapOutputFormat.LOGGER.log(Level.WARNING, "Could not parse format_option \"timeout\": " + String.valueOf(timeoutOption), e);
            }
        }
        int maxRenderingTime = this.getMaxRenderingTime(localMaxRenderingTime);
        return maxRenderingTime;
    }

    private int getMaxRenderingTime(int localMaxRenderingTime) {
        int maxRenderingTime = this.getMaxRenderingTime() * 1000;
        if (maxRenderingTime == 0) {
            maxRenderingTime = localMaxRenderingTime;
        } else if (localMaxRenderingTime != 0) {
            maxRenderingTime = Math.min(maxRenderingTime, localMaxRenderingTime);
        }
        return maxRenderingTime;
    }

    public static Coordinate pixelToWorld(double x, double y, ReferencedEnvelope map, double width, double height) {
        AffineTransform at = WMS.worldToScreenTransform(map, width, height);
        Point2D result = null;
        try {
            result = at.inverseTransform(new Point2D.Double(x, y), new Point2D.Double());
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
        Coordinate c = new Coordinate(result.getX(), result.getY());
        return c;
    }

    public static AffineTransform worldToScreenTransform(ReferencedEnvelope mapExtent, double width, double height) {
        boolean swap;
        CoordinateReferenceSystem crs = mapExtent.getCoordinateReferenceSystem();
        boolean bl = swap = crs != null && CRS.getAxisOrder((CoordinateReferenceSystem)crs) == CRS.AxisOrder.NORTH_EAST;
        if (swap) {
            mapExtent = new ReferencedEnvelope(mapExtent.getMinY(), mapExtent.getMaxY(), mapExtent.getMinX(), mapExtent.getMaxX(), null);
        }
        double scaleX = width / mapExtent.getWidth();
        double scaleY = height / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + height;
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
        if (swap) {
            at.concatenate(new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
        }
        return at;
    }

    public static WMS get() {
        return (WMS)GeoServerExtensions.bean(WMS.class);
    }

    public static boolean isWmsExposable(LayerInfo lyr) {
        if (lyr.getType() == PublishedType.RASTER || lyr.getType() == PublishedType.WMS || lyr.getType() == PublishedType.WMTS) {
            return true;
        }
        if (lyr.getType() == PublishedType.VECTOR) {
            ResourceInfo resource = lyr.getResource();
            try {
                for (AttributeTypeInfo att : ((FeatureTypeInfo)resource).attributes()) {
                    if (att.getBinding() == null || !Geometry.class.isAssignableFrom(att.getBinding())) continue;
                    return true;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "An error occurred trying to determine if the layer is geometryless", e);
            }
        }
        return false;
    }

    public TreeSet<Object> getDimensionValues(FeatureTypeInfo typeInfo, DimensionInfo dimensionInfo) throws IOException {
        FeatureCollection fcollection = this.getDimensionCollection(typeInfo, dimensionInfo);
        TreeSet<Object> result = new TreeSet<Object>();
        String startValue = dimensionInfo.getStartValue();
        String endValue = dimensionInfo.getEndValue();
        if (dimensionInfo.getPresentation() != DimensionPresentation.LIST && !StringUtils.isEmpty((String)startValue) && !StringUtils.isEmpty((String)endValue)) {
            try {
                result.add(Double.parseDouble(startValue));
                result.add(Double.parseDouble(endValue));
            }
            catch (NumberFormatException e) {
                result.add(DimensionHelper.parseTimeRangeValue(startValue));
                result.add(DimensionHelper.parseTimeRangeValue(endValue));
            }
        } else if (dimensionInfo.getPresentation() == DimensionPresentation.LIST || dimensionInfo.getPresentation() == DimensionPresentation.DISCRETE_INTERVAL && dimensionInfo.getResolution() == null) {
            UniqueVisitor uniqueVisitor = new UniqueVisitor(new String[]{dimensionInfo.getAttribute()});
            fcollection.accepts((FeatureVisitor)uniqueVisitor, null);
            Set uniqueValues = uniqueVisitor.getUnique();
            for (Object obj : uniqueValues) {
                result.add(obj);
            }
        } else {
            MinVisitor minVisitor = new MinVisitor(dimensionInfo.getAttribute());
            fcollection.accepts((FeatureVisitor)minVisitor, null);
            CalcResult minResult = minVisitor.getResult();
            if (minResult != CalcResult.NULL_RESULT) {
                result.add(minResult.getValue());
                MaxVisitor maxVisitor = new MaxVisitor(dimensionInfo.getEndAttribute() != null ? dimensionInfo.getEndAttribute() : dimensionInfo.getAttribute());
                fcollection.accepts((FeatureVisitor)maxVisitor, null);
                result.add(maxVisitor.getMax());
            }
        }
        return result;
    }

    public boolean isDefaultGroupStyleEnabled() {
        return this.getServiceInfo().isDefaultGroupStyleEnabled();
    }

    public boolean isTransformFeatureInfo() {
        return !this.getServiceInfo().isTransformFeatureInfoDisabled();
    }

    public boolean isAutoEscapeTemplateValues() {
        return this.getServiceInfo().isAutoEscapeTemplateValues();
    }
}

