/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.wms.WMS;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.UserLayer;
import org.geotools.util.NumberRange;
import org.xml.sax.helpers.AttributesImpl;

public final class CapabilityUtil {
    public static final String LAYER_GROUP_STYLE_NAME = "default-style";
    protected static final String LAYER_GROUP_STYLE_TITLE_PREFIX = "";
    protected static final String LAYER_GROUP_STYLE_TITLE_SUFFIX = " style";
    protected static final String LAYER_GROUP_STYLE_ABSTRACT_PREFIX = "Default style for ";
    protected static final String LAYER_GROUP_STYLE_ABSTRACT_SUFFIX = " layer";

    private CapabilityUtil() {
    }

    public static NumberRange<Double> searchMinMaxScaleDenominator(Set<StyleInfo> styles) throws IOException {
        MinMaxDenominator minMaxDenominator = new MinMaxDenominator(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (StyleInfo styleInfo : styles) {
            Optional<StyledLayer[]> styledLayers = Optional.ofNullable(styleInfo.getSLD()).map(StyledLayerDescriptor::getStyledLayers);
            if (styledLayers.isPresent()) {
                for (StyledLayer styledLayer : styledLayers.get()) {
                    List stylesList = Collections.emptyList();
                    if (styledLayer instanceof NamedLayer) {
                        NamedLayer namedLayer = (NamedLayer)styledLayer;
                        stylesList = namedLayer.styles();
                    } else if (styledLayer instanceof UserLayer) {
                        UserLayer userLayer = (UserLayer)styledLayer;
                        stylesList = userLayer.userStyles();
                    }
                    for (Style style : stylesList) {
                        CapabilityUtil.populateMinMaxScaleDenominator(style, minMaxDenominator);
                    }
                }
                continue;
            }
            if (styleInfo.getStyle() == null) continue;
            CapabilityUtil.populateMinMaxScaleDenominator(styleInfo.getStyle(), minMaxDenominator);
        }
        if (minMaxDenominator.getMin() == Double.POSITIVE_INFINITY) {
            minMaxDenominator.setMin(0.0);
        }
        if (minMaxDenominator.getMax() == Double.NEGATIVE_INFINITY) {
            minMaxDenominator.setMax(Double.POSITIVE_INFINITY);
        }
        assert (minMaxDenominator.getMin() <= minMaxDenominator.getMax()) : "Min <= Max scale is expected";
        return new NumberRange(Double.class, (Number)minMaxDenominator.getMin(), (Number)minMaxDenominator.getMax());
    }

    private static void populateMinMaxScaleDenominator(Style style, MinMaxDenominator minMaxDenominator) {
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            for (Rule rule : fts.rules()) {
                if (rule.getMinScaleDenominator() < minMaxDenominator.getMin()) {
                    minMaxDenominator.setMin(rule.getMinScaleDenominator());
                }
                if (!(rule.getMaxScaleDenominator() > minMaxDenominator.getMax())) continue;
                minMaxDenominator.setMax(rule.getMaxScaleDenominator());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NumberRange<Double> searchMinMaxScaleDenominator(LayerInfo layer) throws IOException {
        StyleInfo defaultStyle;
        HashSet<StyleInfo> stylesCopy;
        LayerInfo layerInfo = layer;
        synchronized (layerInfo) {
            stylesCopy = new HashSet<StyleInfo>(layer.getStyles());
            defaultStyle = layer.getDefaultStyle();
        }
        if (!stylesCopy.contains(defaultStyle)) {
            stylesCopy.add(defaultStyle);
        }
        return CapabilityUtil.searchMinMaxScaleDenominator(stylesCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findLayerGroupStyles(LayerGroupInfo layerGroup, Set<StyleInfo> stylesCopy) {
        LayerGroupInfo layerGroupInfo = layerGroup;
        synchronized (layerGroupInfo) {
            for (int i = 0; i < layerGroup.getLayers().size(); ++i) {
                StyleInfo styleInfo = (StyleInfo)layerGroup.getStyles().get(i);
                if (styleInfo == null) {
                    PublishedInfo publishedInfo = (PublishedInfo)layerGroup.getLayers().get(i);
                    if (publishedInfo instanceof LayerInfo) {
                        LayerInfo info1 = (LayerInfo)publishedInfo;
                        styleInfo = info1.getDefaultStyle();
                        stylesCopy.add(styleInfo);
                        continue;
                    }
                    if (!(publishedInfo instanceof LayerGroupInfo)) continue;
                    LayerGroupInfo info = (LayerGroupInfo)publishedInfo;
                    CapabilityUtil.findLayerGroupStyles(info, stylesCopy);
                    continue;
                }
                stylesCopy.add(styleInfo);
            }
        }
    }

    public static NumberRange<Double> searchMinMaxScaleDenominator(LayerGroupInfo layerGroup) throws IOException {
        HashSet<StyleInfo> stylesCopy = new HashSet<StyleInfo>();
        CapabilityUtil.findLayerGroupStyles(layerGroup, stylesCopy);
        return CapabilityUtil.searchMinMaxScaleDenominator(stylesCopy);
    }

    public static NumberRange<Double> searchMinMaxScaleDenominator(PublishedInfo publishedInfo) throws IOException {
        if (publishedInfo instanceof LayerInfo) {
            LayerInfo info1 = (LayerInfo)publishedInfo;
            return CapabilityUtil.searchMinMaxScaleDenominator(info1);
        }
        if (publishedInfo instanceof LayerGroupInfo) {
            LayerGroupInfo info = (LayerGroupInfo)publishedInfo;
            return CapabilityUtil.searchMinMaxScaleDenominator(info);
        }
        throw new UnsupportedOperationException("PublishedInfo must be either Layer or Layergroup");
    }

    public static Double computeScaleHint(Double scaleDenominator) {
        Double sizeStandardRenderPixel = 2.8E-4;
        Double scaleHint = Math.sqrt(Math.pow(scaleDenominator * sizeStandardRenderPixel, 2.0) * 2.0);
        return scaleHint;
    }

    public static boolean validateLegendInfo(LegendInfo legend) {
        return legend != null && legend.getOnlineResource() != null && legend.getHeight() > 0 && legend.getWidth() > 0;
    }

    public static AttributesImpl addGetLegendAttributes(AttributesImpl attrs, String legendURL, String XLINK_NS) {
        attrs.addAttribute(LAYER_GROUP_STYLE_TITLE_PREFIX, "xmlns:xlink", "xmlns:xlink", LAYER_GROUP_STYLE_TITLE_PREFIX, XLINK_NS);
        attrs.addAttribute(XLINK_NS, "type", "xlink:type", LAYER_GROUP_STYLE_TITLE_PREFIX, "simple");
        attrs.addAttribute(XLINK_NS, "href", "xlink:href", LAYER_GROUP_STYLE_TITLE_PREFIX, legendURL);
        return attrs;
    }

    public static boolean encodeGroupDefaultStyle(WMS wms, LayerGroupInfo lgi) {
        boolean opaqueOrSingle = LayerGroupHelper.isSingleOrOpaque((LayerGroupInfo)lgi);
        return opaqueOrSingle || wms.isDefaultGroupStyleEnabled();
    }

    public static String getGroupDefaultStyleName(String groupName) {
        return LAYER_GROUP_STYLE_NAME.concat("-").concat(groupName);
    }

    public static String getGroupDefaultStyleName(LayerGroupInfo groupName) {
        return CapabilityUtil.getGroupDefaultStyleName(groupName.prefixedName());
    }

    private static class MinMaxDenominator {
        private Double min;
        private Double max;

        public MinMaxDenominator(Double minScaleDenominator, Double maxScaleDenominator) {
            this.min = minScaleDenominator;
            this.max = maxScaleDenominator;
        }

        public Double getMax() {
            return this.max;
        }

        public Double getMin() {
            return this.min;
        }

        public void setMax(Double max) {
            this.max = max;
        }

        public void setMin(Double min) {
            this.min = min;
        }
    }
}

