/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.clip;

import java.util.logging.Logger;
import org.geoserver.wms.clip.ClippedFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.vector.ClipProcess;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;

public class ClippedFeatureCollection<T extends FeatureType, F extends Feature>
extends DecoratingFeatureCollection<T, F> {
    static final Logger LOGGER = Logging.getLogger(ClippedFeatureCollection.class);
    Geometry clip;

    public ClippedFeatureCollection(FeatureCollection<T, F> delegate, Geometry clipGeometry) {
        super(delegate);
        this.clip = ClippedFeatureSource.reproject(delegate.getSchema().getCoordinateReferenceSystem(), clipGeometry);
    }

    public FeatureIterator<F> features() {
        return this.getClippedCollection(this.delegate, this.clip);
    }

    public ReferencedEnvelope getBounds() {
        ReferencedEnvelope orignalBounds = super.getBounds();
        return JTS.toEnvelope((Geometry)this.clip.intersection((Geometry)JTS.toGeometry((ReferencedEnvelope)orignalBounds)));
    }

    private FeatureIterator<F> getClippedCollection(FeatureCollection<T, F> fc, Geometry clipGeom) {
        if (fc instanceof SimpleFeatureCollection) {
            SimpleFeatureCollection collection = (SimpleFeatureCollection)fc;
            return new ClipProcess().execute(collection, clipGeom, Boolean.valueOf(false)).features();
        }
        return fc.features();
    }
}

