/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.decoration.MapDecoration;
import org.geoserver.wms.decoration.MapDecorationLayout;
import org.geotools.api.filter.expression.Expression;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.URLs;

public class WatermarkDecoration
implements MapDecoration {
    private static final Logger LOGGER = Logger.getLogger("org.geoserver.wms.responses");
    public static final Color TRANSPARENT = new Color(255, 255, 255, 0);
    private String imageURL;
    private float opacity = 1.0f;
    private static final Map<URI, LogoCacheEntry> logoCache = new SoftValueHashMap();

    @Override
    public void loadOptions(Map<String, Expression> options) {
        this.imageURL = MapDecorationLayout.getOption(options, "url");
        if (options.containsKey("opacity")) {
            try {
                this.opacity = MapDecorationLayout.getOption(options, "opacity", Float.class).floatValue() / 100.0f;
                this.opacity = Math.max(Math.min(this.opacity, 1.0f), 0.0f);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Invalid opacity value: " + String.valueOf(options.get("opacity")), e);
            }
        }
    }

    @Override
    public Dimension findOptimalSize(Graphics2D g2d, WMSMapContent mapContent) {
        try {
            BufferedImage logo = this.getLogo();
            return new Dimension(logo.getWidth(), logo.getHeight());
        }
        catch (Exception e) {
            return new Dimension(20, 20);
        }
    }

    @Override
    public void paint(Graphics2D g2D, Rectangle paintArea, WMSMapContent mapContent) throws MalformedURLException, ClassCastException, IOException {
        BufferedImage logo = this.getLogo();
        if (logo != null) {
            Composite oldComposite = g2D.getComposite();
            g2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
            AffineTransform tx = AffineTransform.getTranslateInstance(paintArea.getX(), paintArea.getY());
            tx.scale(paintArea.getWidth() / (double)logo.getWidth(), paintArea.getHeight() / (double)logo.getHeight());
            g2D.drawImage(logo, tx, null);
            g2D.setComposite(oldComposite);
        }
    }

    protected BufferedImage getLogo() throws IOException {
        URI key;
        URL url;
        BufferedImage logo;
        block10: {
            logo = null;
            GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
            url = null;
            try {
                File file;
                url = new URL(this.imageURL);
                if ((url.getProtocol() == null || url.getProtocol().equals("file")) && (file = Resources.find((Resource)Resources.fromURL((Resource)Files.asResource((File)loader.getBaseDirectory()), (String)this.imageURL), (boolean)true)).exists()) {
                    url = URLs.fileToUrl((File)file);
                }
            }
            catch (MalformedURLException e) {
                Resource image;
                Resource layouts = loader.get("layouts");
                if (layouts.getType() == Resource.Type.DIRECTORY && (image = layouts.get(this.imageURL)).getType() == Resource.Type.RESOURCE) {
                    url = URLs.fileToUrl((File)image.file());
                }
                if (url != null || (image = loader.get(this.imageURL)).getType() != Resource.Type.RESOURCE) break block10;
                url = URLs.fileToUrl((File)image.file());
            }
        }
        if (url == null) {
            return null;
        }
        try {
            key = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        LogoCacheEntry entry = logoCache.get(key);
        if (entry == null || entry.isExpired()) {
            logo = ImageIO.read(url);
            if (url.getProtocol().equals("file")) {
                entry = new LogoCacheEntry(logo, new File(url.getFile()));
                logoCache.put(key, entry);
            }
        } else {
            logo = entry.getLogo();
        }
        return logo;
    }

    private static class LogoCacheEntry {
        private BufferedImage logo;
        private long lastModified;
        private File file;

        public LogoCacheEntry(BufferedImage logo, File file) {
            this.logo = logo;
            this.file = file;
            this.lastModified = file.lastModified();
        }

        public boolean isExpired() {
            return this.file.lastModified() > this.lastModified;
        }

        public BufferedImage getLogo() {
            return this.logo;
        }
    }
}

