/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.wms.FeatureInfoRequestParameters;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.clip.ClippedFeatureSource;
import org.geoserver.wms.featureinfo.LayerIdentifier;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.locationtech.jts.geom.Geometry;

abstract class AbstractVectorLayerIdentifier
implements LayerIdentifier<FeatureSource<? extends FeatureType, ? extends Feature>> {
    private static final double TOLERANCE = 1.0E-6;

    AbstractVectorLayerIdentifier() {
    }

    @Override
    public boolean canHandle(MapLayerInfo layer) {
        int type = layer.getType();
        return type == MapLayerInfo.TYPE_VECTOR || type == MapLayerInfo.TYPE_REMOTE_VECTOR;
    }

    protected List<Rule> getActiveRules(Style style, double scaleDenominator) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            for (Rule r : fts.rules()) {
                if (!(r.getMinScaleDenominator() - 1.0E-6 <= scaleDenominator) || !(r.getMaxScaleDenominator() + 1.0E-6 > scaleDenominator) || r.symbolizers() == null || r.symbolizers().isEmpty()) continue;
                result.add(r);
            }
        }
        return result;
    }

    @Override
    public FeatureSource<? extends FeatureType, ? extends Feature> handleClipParam(FeatureInfoRequestParameters params, FeatureSource<? extends FeatureType, ? extends Feature> featureSource) {
        Geometry clipGeom = params.getGetMapRequest().getClip();
        if (clipGeom == null) {
            return featureSource;
        }
        return new ClippedFeatureSource<FeatureType, Feature>(featureSource, clipGeom);
    }
}

