/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import freemarker.cache.CacheStorage;
import freemarker.cache.NullCacheStorage;
import freemarker.cache.TemplateLoader;
import freemarker.core.HTMLOutputFormat;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.MemberAccessPolicy;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wfs.FeatureCollectionType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.ServiceException;
import org.geoserver.template.DirectTemplateFeatureCollectionFactory;
import org.geoserver.template.FeatureWrapper;
import org.geoserver.template.GeoServerMemberAccessPolicy;
import org.geoserver.template.GeoServerTemplateLoader;
import org.geoserver.template.TemplateUtils;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.EnvironmentVariablesTemplateModel;
import org.geoserver.wms.featureinfo.FeatureCollectionDecorator;
import org.geoserver.wms.featureinfo.FreemarkerStaticsAccessRule;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.logging.Logging;

public abstract class FreeMarkerTemplateManager {
    public static final String FORCE_FREEMARKER_ESCAPING = "GEOSERVER_FORCE_FREEMARKER_ESCAPING";
    static final String KEY_STATIC_MEMBER_ACCESS = "org.geoserver.htmlTemplates.staticMemberAccess";
    private static final Configuration templateConfig;
    private static DirectTemplateFeatureCollectionFactory tfcFactory;
    private static final Logger logger;
    private static FreemarkerStaticsAccessRule staticsAccessRule;
    private GeoServerResourceLoader resourceLoader;
    protected WMS wms;
    private GeoServerTemplateLoader templateLoader;
    private OutputFormat format;

    static void initStaticsAccessRule() {
        String tmpAccessPattern = GeoServerExtensions.getProperty((String)KEY_STATIC_MEMBER_ACCESS);
        FreemarkerStaticsAccessRule tmpRule = FreemarkerStaticsAccessRule.fromPattern(tmpAccessPattern);
        logger.fine("Initializing with " + String.valueOf(tmpRule));
        for (FreemarkerStaticsAccessRule.RuleItem tmpItem : tmpRule.getAllowedItems()) {
            if (tmpItem.isNumberedAlias()) {
                logger.warning("Granting access to static members of " + tmpItem.getClassName() + " using the variable name " + tmpItem.getAlias() + " to keep names unique.");
                continue;
            }
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer("Granting access to static members of " + tmpItem.getClassName() + " using the variable name " + tmpItem.getAlias() + ".");
        }
        staticsAccessRule = tmpRule;
    }

    public FreeMarkerTemplateManager(OutputFormat format, WMS wms, GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.wms = wms;
        this.format = format;
    }

    @Deprecated
    public boolean write(FeatureCollectionType results, GetFeatureInfoRequest request, OutputStream out) throws ServiceException, IOException {
        return this.write((List<FeatureCollection>)results.getFeature(), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(List<FeatureCollection> collections, OutputStream out) throws ServiceException, IOException {
        Charset charSet = this.wms.getCharSet();
        OutputStreamWriter osw = new OutputStreamWriter(out, charSet);
        try {
            Template footer;
            Template header;
            ResourceInfo ri = null;
            if (collections.size() == 1) {
                ri = this.wms.getResourceInfo(FeatureCollectionDecorator.getName(collections.get(0)));
            }
            if (ri != null) {
                header = this.getTemplate(ri, charSet, "header");
                footer = this.getTemplate(ri, charSet, "footer");
            } else {
                header = this.getTemplate(null, charSet, "header");
                footer = this.getTemplate(null, charSet, "footer");
            }
            if (!this.templatesExist(header, footer, collections)) {
                boolean bl = false;
                return bl;
            }
            this.processTemplate("header", null, header, osw);
            this.handleContent(collections, osw);
            if (footer != null) {
                this.processTemplate("footer", null, footer, osw);
            }
            osw.flush();
            boolean bl = true;
            return bl;
        }
        finally {
            this.cleanup();
        }
    }

    public void cleanup() {
        tfcFactory.purge();
    }

    protected void processTemplate(String templateType, FeatureCollection fc, Template template, OutputStreamWriter osw) throws IOException {
        try {
            template.process((Object)fc, (Writer)osw);
        }
        catch (TemplateException e) {
            String msg = "Error occurred processing " + templateType + " template " + template.getName();
            if (fc != null) {
                Name name = FeatureCollectionDecorator.getName(fc);
                msg = msg + " for featureType " + (name == null ? null : name.getLocalPart());
            }
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    protected Template getContentTemplate(FeatureCollection fc, Charset charset) throws IOException {
        Template content = null;
        if (fc != null && fc.size() > 0) {
            ResourceInfo ri = this.wms.getResourceInfo(FeatureCollectionDecorator.getName(fc));
            if (!(fc.getSchema() instanceof SimpleFeatureType)) {
                content = this.getTemplate(ri, charset, "complex_content");
            }
            if (content == null) {
                content = this.getTemplate(ri, charset, "content");
            }
        }
        return content;
    }

    protected Template getTemplate(ResourceInfo ri, Charset charset, String name) throws IOException {
        String templateName = this.getTemplateFileName(name);
        return this.getTemplate(ri, templateName, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template getTemplate(ResourceInfo ri, String templateFileName, Charset charset) throws IOException {
        Configuration configuration = templateConfig;
        synchronized (configuration) {
            Template t;
            block7: {
                String prop;
                if (this.templateLoader == null) {
                    this.templateLoader = new GeoServerTemplateLoader(this.getClass(), this.resourceLoader);
                }
                this.templateLoader.setResource(ri);
                templateConfig.setTemplateLoader((TemplateLoader)this.templateLoader);
                templateConfig.unsetOutputFormat();
                if (this.format.equals((Object)OutputFormat.HTML) && (!"false".equalsIgnoreCase(prop = GeoServerExtensions.getProperty((String)FORCE_FREEMARKER_ESCAPING)) || this.wms.isAutoEscapeTemplateValues())) {
                    templateConfig.setOutputFormat((freemarker.core.OutputFormat)HTMLOutputFormat.INSTANCE);
                }
                t = null;
                try {
                    t = templateConfig.getTemplate(templateFileName);
                }
                catch (FileNotFoundException ex) {
                    if (!this.format.equals((Object)OutputFormat.HTML)) break block7;
                    throw ex;
                }
            }
            return t;
        }
    }

    protected abstract String getTemplateFileName(String var1);

    protected abstract boolean templatesExist(Template var1, Template var2, List<FeatureCollection> var3) throws IOException;

    protected abstract void handleContent(List<FeatureCollection> var1, OutputStreamWriter var2) throws IOException;

    public void setTemplateLoader(GeoServerTemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
    }

    public static void clearClassIntrospectionCache() {
        ((FeatureWrapper)templateConfig.getObjectWrapper()).clearClassIntrospectionCache();
    }

    static {
        tfcFactory = new DirectTemplateFeatureCollectionFactory();
        logger = Logging.getLogger(FreeMarkerTemplateManager.class);
        FreeMarkerTemplateManager.initStaticsAccessRule();
        FeatureWrapper wrapper = new FeatureWrapper((FeatureWrapper.TemplateFeatureCollectionFactory)tfcFactory){

            public TemplateModel wrap(Object object) throws TemplateModelException {
                if (object instanceof FeatureCollection) {
                    SimpleHash map = (SimpleHash)super.wrap(object);
                    map.put("request", (Object)((Request)Dispatcher.REQUEST.get()).getKvp());
                    map.put("environment", (Object)new EnvironmentVariablesTemplateModel());
                    map.put("Math", (Object)this.getStaticModel("java.lang.Math"));
                    map.put("geoJSON", (Object)this.getStaticModel("org.geoserver.wms.featureinfo.GeoJSONTemplateManager"));
                    this.addConfiguredStatics(map);
                    return map;
                }
                return super.wrap(object);
            }

            private void addConfiguredStatics(SimpleHash aMap) throws TemplateModelException {
                if (staticsAccessRule.isUnrestricted()) {
                    aMap.put("statics", (Object)this.getStaticModels());
                } else {
                    for (FreemarkerStaticsAccessRule.RuleItem tmpItem : staticsAccessRule.getAllowedItems()) {
                        aMap.put(tmpItem.getAlias(), (Object)this.getStaticModel(tmpItem.getClassName()));
                    }
                }
            }

            private TemplateHashModel getStaticModel(String path) throws TemplateModelException {
                return (TemplateHashModel)this.getStaticModels().get(path);
            }
        };
        Predicate<Class> staticAccess = clazz -> {
            String name = clazz.getName();
            return name.equals("java.lang.Math") || name.equals("org.geoserver.wms.featureinfo.GeoJSONTemplateManager") || staticsAccessRule.isUnrestricted() || staticsAccessRule.getAllowedItems().stream().anyMatch(r -> r.getClassName().equals(name));
        };
        GeoServerMemberAccessPolicy policy = GeoServerMemberAccessPolicy.DEFAULT_ACCESS.withStaticAccess(staticAccess);
        templateConfig = TemplateUtils.getSafeConfiguration((BeansWrapper)wrapper, (MemberAccessPolicy)policy, null);
        templateConfig.setCacheStorage((CacheStorage)new NullCacheStorage());
    }

    public static enum OutputFormat {
        JSON("application/json"),
        HTML("text/html");

        private String format;

        private OutputFormat(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

