/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.geometry.Bounds;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.BaseFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;

class ListComplexFeatureCollection
extends BaseFeatureCollection {
    private List<? extends Feature> list;
    private ReferencedEnvelope bounds = null;

    public ListComplexFeatureCollection(FeatureType schema, List<? extends Feature> list) {
        super(schema);
        this.list = list;
    }

    public int size() {
        return this.list.size();
    }

    public FeatureIterator features() {
        return new ListComplexFeatureIterator(this.list);
    }

    public synchronized ReferencedEnvelope getBounds() {
        if (this.bounds == null) {
            this.bounds = this.calculateBounds();
        }
        return this.bounds;
    }

    private ReferencedEnvelope calculateBounds() {
        ReferencedEnvelope extent = new ReferencedEnvelope();
        for (Feature feature : this.list) {
            ReferencedEnvelope bbox;
            if (feature == null || (bbox = ReferencedEnvelope.reference((Bounds)feature.getBounds())) == null || bbox.isEmpty() || bbox.isNull()) continue;
            extent.expandToInclude((Envelope)bbox);
        }
        return new ReferencedEnvelope((Envelope)extent, this.schema.getCoordinateReferenceSystem());
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    private static class ListComplexFeatureIterator
    implements FeatureIterator {
        private Iterator<? extends Feature> iter;

        public ListComplexFeatureIterator(List<? extends Feature> features) {
            this.iter = features.iterator();
        }

        public void close() {
            Iterator<? extends Feature> iterator = this.iter;
            if (iterator instanceof FeatureIterator) {
                FeatureIterator iterator2 = (FeatureIterator)iterator;
                iterator2.close();
            }
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Feature next() throws NoSuchElementException {
            return this.iter.next();
        }
    }
}

