/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import it.geosolutions.imageio.pam.PAMDataset;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.geoserver.wms.featureinfo.AttributeTableEnricher;
import org.geoserver.wms.map.RasterSymbolizerVisitor;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.SelectedChannelType;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.PAMResourceInfo;
import org.geotools.util.logging.Logging;

class RasterAttributeTableVisitor
extends RasterSymbolizerVisitor {
    static final Logger LOGGER = Logging.getLogger(RasterAttributeTableVisitor.class);
    private final GridCoverage2DReader reader;
    private final String coverageName;

    public RasterAttributeTableVisitor(double scaleDenominator, String nativeName, GridCoverage2DReader reader) {
        super(scaleDenominator, null);
        this.reader = reader;
        this.coverageName = nativeName;
    }

    public AttributeTableEnricher getAttributeTableEnricher() {
        return Optional.ofNullable(this.getAttributeTableBand()).map(b -> new AttributeTableEnricher((PAMDataset.PAMRasterBand)b)).orElse(null);
    }

    private PAMDataset.PAMRasterBand getAttributeTableBand() {
        List pamRasterBands = null;
        for (RasterSymbolizer rs : this.getRasterSymbolizers()) {
            ChannelSelection cs;
            boolean addAttributeTable = Boolean.valueOf(rs.getOptions().getOrDefault("addAttributeTable", "false"));
            if (!addAttributeTable) continue;
            if (pamRasterBands == null) {
                ResourceInfo info = this.reader.getInfo(this.coverageName);
                if (!(info instanceof PAMResourceInfo)) {
                    LOGGER.fine("No PAM dataset found in raster attribute table, even if addAttributeTable is set to true.");
                    return null;
                }
                PAMResourceInfo pamInfo = (PAMResourceInfo)info;
                PAMDataset pam = pamInfo.getPAMDataset();
                if (pam == null || pam.getPAMRasterBand() == null || pam.getPAMRasterBand().isEmpty()) {
                    LOGGER.fine("No Raster bands found in PAM dataset, even if addAttributeTable is set to true.");
                    return null;
                }
                pamRasterBands = pam.getPAMRasterBand();
            }
            if ((cs = rs.getChannelSelection()) == null || cs.getGrayChannel() == null && cs.getRGBChannels() == null) {
                PAMDataset.PAMRasterBand band = (PAMDataset.PAMRasterBand)pamRasterBands.get(0);
                if (band.getGdalRasterAttributeTable() == null) continue;
                return band;
            }
            if (cs.getGrayChannel() != null) {
                Expression channelName = cs.getGrayChannel().getChannelName();
                PAMDataset.PAMRasterBand band = RasterAttributeTableVisitor.getBandWithRAT(channelName, pamRasterBands);
                if (band != null && band.getGdalRasterAttributeTable() != null) {
                    return band;
                }
                LOGGER.fine("No RAT found in PAM dataset for the gray channel even if addAttributeTable is set to true.");
                continue;
            }
            if (cs.getRGBChannels() == null || cs.getRGBChannels().length <= 0) continue;
            for (SelectedChannelType sct : cs.getRGBChannels()) {
                Expression channelName = sct.getChannelName();
                PAMDataset.PAMRasterBand band = RasterAttributeTableVisitor.getBandWithRAT(channelName, pamRasterBands);
                if (band == null || band.getGdalRasterAttributeTable() == null) continue;
                return band;
            }
            LOGGER.fine("No RAT found in PAM dataset for any of the RGB channels even if addAttributeTable is set to true.");
        }
        return null;
    }

    private static PAMDataset.PAMRasterBand getBandWithRAT(Expression channelName, List<PAMDataset.PAMRasterBand> pamRasterBands) {
        Integer bandIdx = (Integer)channelName.evaluate(null, Integer.class);
        if (bandIdx != null) {
            Integer n = bandIdx;
            bandIdx = bandIdx - 1;
            if (bandIdx >= 0 && bandIdx < pamRasterBands.size() && pamRasterBands.get(bandIdx).getGdalRasterAttributeTable() != null) {
                PAMDataset.PAMRasterBand band = pamRasterBands.get(bandIdx);
                if (band.getBand() == null) {
                    band.setBand(bandIdx);
                }
                return band;
            }
        }
        return null;
    }
}

