/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import net.opengis.wfs.FeatureCollectionType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.data.util.TemporalUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Geometry;

public class TextFeatureInfoOutputFormat
extends GetFeatureInfoOutputFormat {
    private WMS wms;

    public TextFeatureInfoOutputFormat(WMS wms) {
        super("text/plain");
        this.wms = wms;
    }

    @Override
    public void write(FeatureCollectionType results, GetFeatureInfoRequest request, OutputStream out) throws ServiceException, IOException {
        Charset charSet = this.wms.getCharSet();
        OutputStreamWriter osw = new OutputStreamWriter(out, charSet);
        PrintWriter writer = new PrintWriter(osw);
        int featuresPrinted = 0;
        int maxfeatures = request.getFeatureCount();
        try {
            EList collections = results.getFeature();
            for (Object collection : collections) {
                FeatureCollection fr = (FeatureCollection)collection;
                FeatureIterator reader = fr.features();
                try {
                    boolean startFeat = true;
                    while (reader.hasNext()) {
                        Feature feature = reader.next();
                        if (startFeat) {
                            writer.println("Results for FeatureType '" + String.valueOf(fr.getSchema().getName()) + "':");
                            startFeat = false;
                        }
                        if (featuresPrinted < maxfeatures) {
                            writer.println("--------------------------------------------");
                            if (feature instanceof SimpleFeature) {
                                SimpleFeature f = (SimpleFeature)feature;
                                this.writeSimpleFeature(writer, f);
                            } else {
                                writer.println(feature.toString());
                            }
                        }
                        writer.println("--------------------------------------------");
                        ++featuresPrinted;
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
        catch (Exception ife) {
            LOGGER.log(Level.WARNING, "Error generating getFeaturInfo, HTML format", ife);
            writer.println("Unable to generate information " + String.valueOf(ife));
        }
        if (featuresPrinted == 0) {
            writer.println("no features were found");
        }
        writer.flush();
    }

    private void writeSimpleFeature(PrintWriter writer, SimpleFeature f) {
        SimpleFeatureType schema = f.getType();
        List types = schema.getAttributeDescriptors();
        for (AttributeDescriptor descriptor : types) {
            Name name = descriptor.getName();
            Class binding = descriptor.getType().getBinding();
            if (Geometry.class.isAssignableFrom(binding)) {
                Geometry g = (Geometry)f.getAttribute(name);
                if (g != null) {
                    writer.println(String.valueOf(name) + " = [GEOMETRY (" + g.getGeometryType() + ") with " + g.getNumPoints() + " points]");
                    continue;
                }
                writer.println(String.valueOf(name) + " = null");
                continue;
            }
            if (Date.class.isAssignableFrom(binding) && TemporalUtils.isDateTimeFormatEnabled()) {
                String printValue = TemporalUtils.printDate((Date)((Date)f.getAttribute(name)));
                writer.println(String.valueOf(name) + " = " + printValue);
                continue;
            }
            writer.println(String.valueOf(name) + " = " + String.valueOf(f.getAttribute(name)));
        }
    }

    @Override
    public String getCharset() {
        return this.wms.getGeoServer().getSettings().getCharset();
    }
}

