/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.FeatureInfoRequestParameters;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.RenderingVariables;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.AbstractVectorLayerIdentifier;
import org.geoserver.wms.featureinfo.LayerIdentifier;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.data.store.FilteringFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.Filters;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Polygon;

public class VectorBasicLayerIdentifier
extends AbstractVectorLayerIdentifier {
    static final Logger LOGGER = Logging.getLogger(VectorBasicLayerIdentifier.class);
    public static final String FEATUREINFO_DEFAULT_BUFFER = "org.geoserver.wms.featureinfo.minBuffer";
    public static final int MIN_BUFFER_SIZE = Integer.getInteger("org.geoserver.wms.featureinfo.minBuffer", 5);
    private WMS wms;

    public VectorBasicLayerIdentifier(WMS wms) {
        this.wms = wms;
    }

    @Override
    public List<FeatureCollection> identify(FeatureInfoRequestParameters params, int maxFeatures) throws Exception {
        Or or;
        LOGGER.log(Level.FINER, "Appliying bbox based feature info identifier");
        MapLayerInfo layer = params.getLayer();
        Filter filter = params.getFilter();
        Style style = params.getStyle();
        List<Rule> rules = this.getActiveRules(style, params.getScaleDenominator());
        if (rules.isEmpty()) {
            return null;
        }
        double radius = this.getSearchRadius(params, layer, rules);
        Object queryEnvelope = LayerIdentifier.getEnvelopeFilter(params, radius);
        CoordinateReferenceSystem requestedCRS = params.getRequestedCRS();
        CoordinateReferenceSystem dataCRS = layer.getCoordinateReferenceSystem();
        if (requestedCRS != null && !CRS.equalsIgnoreMetadata((Object)dataCRS, (Object)requestedCRS)) {
            queryEnvelope = dataCRS.getCoordinateSystem().getDimension() == 3 && requestedCRS.getCoordinateSystem().getDimension() == 2 ? JTS.transformTo3D((ReferencedEnvelope)queryEnvelope, (CoordinateReferenceSystem)dataCRS, (boolean)true, (int)10) : queryEnvelope.transform(dataCRS, true);
        }
        FeatureSource<? extends FeatureType, ? extends Feature> featureSource = super.handleClipParam(params, layer.getFeatureSource(false, requestedCRS));
        FeatureType schema = featureSource.getSchema();
        Intersects getFInfoFilter = null;
        FilterFactory ff = params.getFilterFactory();
        try {
            GeometryDescriptor geometryDescriptor = schema.getGeometryDescriptor();
            Name name = geometryDescriptor.getName();
            Polygon queryPolygon = JTS.toGeometry((ReferencedEnvelope)queryEnvelope);
            getFInfoFilter = ff.intersects((Expression)ff.property(name), (Expression)ff.literal((Object)queryPolygon));
        }
        catch (IllegalFilterException e) {
            LOGGER.log(Level.FINE, "", e);
            throw new ServiceException("Internal error : " + e.getMessage(), (Throwable)e);
        }
        if (filter != null) {
            getFInfoFilter = ff.and((Filter)getFInfoFilter, filter);
        }
        IncludeFilter postFilter = Filter.INCLUDE;
        Filter rulesFilters = this.buildRulesFilter(ff, rules);
        if (!(featureSource.getSchema() instanceof SimpleFeatureType) || !(rulesFilters instanceof Or) || rulesFilters instanceof Or && (or = (Or)rulesFilters).getChildren().size() <= 20) {
            getFInfoFilter = ff.and((Filter)getFInfoFilter, rulesFilters);
        } else {
            postFilter = rulesFilters;
        }
        List<Object> times = params.getTimes();
        List<Object> elevations = params.getElevations();
        FeatureTypeInfo featureInfo = layer.getFeature();
        GetMapRequest getMapRequest = params.getGetMapRequest();
        this.wms.validateVectorDimensions(times, elevations, featureInfo, getMapRequest);
        Filter dimensionFilter = this.wms.getDimensionFilter(times, elevations, featureInfo, getMapRequest);
        getFInfoFilter = Filters.and((FilterFactory)ff, (Filter)getFInfoFilter, (Filter)dimensionFilter);
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        getFInfoFilter = (Filter)getFInfoFilter.accept((FilterVisitor)simplifier, null);
        String typeName = schema.getName().getLocalPart();
        Query query = new Query(typeName, null, (Filter)getFInfoFilter, maxFeatures, params.getPropertyNames(), null);
        query.setSortBy(params.getSort());
        RenderingVariables.setupEnvironmentVariables(params);
        query = RenderingVariables.setHintsToQuery(query);
        Map<String, String> viewParams = params.getViewParams();
        if (viewParams != null && !viewParams.isEmpty()) {
            query.setHints(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, viewParams));
        }
        LOGGER.log(Level.FINE, query.toString());
        if (!this.wms.isFeaturesReprojectionDisabled()) {
            query.setCoordinateSystemReproject(requestedCRS);
        }
        FeatureCollection match = featureSource.getFeatures(query);
        if (!Filter.INCLUDE.equals(postFilter)) {
            match = new FilteringFeatureCollection(match, (Filter)postFilter);
        }
        return Collections.singletonList(match);
    }

    private double getSearchRadius(FeatureInfoRequestParameters params, MapLayerInfo layer, List<Rule> rules) {
        double radius;
        int buffer = params.getBuffer();
        if (buffer <= 0) {
            Integer layerBuffer = null;
            LayerInfo layerInfo = layer.getLayerInfo();
            if (layerInfo != null) {
                layerBuffer = (Integer)layerInfo.getMetadata().get("buffer", Integer.class);
            }
            if (layerBuffer != null && layerBuffer > 0) {
                radius = layerBuffer.intValue();
            } else {
                MetaBufferEstimator estimator = new MetaBufferEstimator();
                for (Rule rule : rules) {
                    rule.accept((StyleVisitor)estimator);
                }
                int estimatedRadius = estimator.getBuffer() / 2;
                radius = estimatedRadius < MIN_BUFFER_SIZE ? (double)MIN_BUFFER_SIZE : (double)estimatedRadius;
            }
        } else {
            radius = buffer;
        }
        int maxRadius = this.wms.getMaxBuffer();
        if (maxRadius > 0 && radius > (double)maxRadius) {
            radius = maxRadius;
        }
        return radius;
    }

    private Filter buildRulesFilter(FilterFactory ff, List<Rule> rules) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (Rule rule : rules) {
            if (rule.getFilter() == null || rule.isElseFilter()) {
                return Filter.INCLUDE;
            }
            filters.add(rule.getFilter());
        }
        Or or = ff.or(filters);
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        return (Filter)or.accept((FilterVisitor)simplifier, null);
    }
}

