/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wfs.FeatureCollectionType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wms.FeatureInfoRequestParameters;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.clip.ClippedFeatureCollection;
import org.geoserver.wms.featureinfo.LayerIdentifier;
import org.geoserver.wms.featureinfo.LayerIdentifierUtils;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.WebMapServer;
import org.geotools.ows.wms.map.WMSLayer;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.v1_0.WFSConfiguration_1_0;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.locationtech.jts.geom.Geometry;

public class WMSLayerIdentifier
implements LayerIdentifier<SimpleFeatureCollection> {
    static final Logger LOGGER = Logging.getLogger(WMSLayerIdentifier.class);
    private EntityResolverProvider resolverProvider;
    private WMS wms;

    public WMSLayerIdentifier(EntityResolverProvider resolverProvider, WMS wms) {
        this.resolverProvider = resolverProvider;
        this.wms = wms;
    }

    @Override
    public List<FeatureCollection> identify(FeatureInfoRequestParameters params, int maxFeatures) throws IOException {
        int x = params.getX();
        int y = params.getY();
        WMSLayerInfo info = (WMSLayerInfo)params.getLayer().getResource();
        WebMapServer wms = info.getStore().getWebMapServer(null);
        Layer layer = info.getWMSLayer(null);
        CoordinateReferenceSystem crs = params.getRequestedCRS();
        if (crs == null) {
            crs = info.getCRS();
        }
        ReferencedEnvelope bbox = params.getRequestedBounds();
        int width = params.getWidth();
        int height = params.getHeight();
        if (!layer.isQueryable()) {
            return null;
        }
        List infoFormats = wms.getCapabilities().getRequest().getGetFeatureInfo().getFormats();
        if (!infoFormats.contains("application/vnd.ogc.gml")) {
            return null;
        }
        WMSLayer ml = new WMSLayer(wms, layer);
        ArrayList<FeatureCollection> results = new ArrayList<FeatureCollection>();
        try (InputStream is = ml.getFeatureInfo(bbox, width, height, x, y, "application/vnd.ogc.gml", maxFeatures);){
            Parser parser = new Parser((Configuration)new WFSConfiguration_1_0());
            parser.setStrict(false);
            parser.setEntityResolver(this.resolverProvider.getEntityResolver());
            Object result = parser.parse(is);
            if (result instanceof FeatureCollectionType) {
                FeatureCollectionType fcList = (FeatureCollectionType)result;
                EList rawResults = fcList.getFeature();
                for (SimpleFeatureCollection fc : rawResults) {
                    SimpleFeatureType ft = (SimpleFeatureType)fc.getSchema();
                    SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
                    builder.init(ft);
                    builder.setName(info.getName());
                    builder.setNamespaceURI(info.getNamespace().getURI());
                    SimpleFeatureType targetFeatureType = builder.buildFeatureType();
                    SimpleFeatureCollection rfc = DataUtilities.simple((FeatureCollection)this.handleClipParam(params, (SimpleFeatureCollection)new ReTypingFeatureCollection(fc, targetFeatureType)));
                    results.add(this.forceCrs((FeatureCollection<SimpleFeatureType, SimpleFeature>)rfc));
                }
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Tried to parse GML2 response, but failed", t);
        }
        if (!this.getWms().isFeaturesReprojectionDisabled()) {
            return LayerIdentifierUtils.reproject(results, params.getRequestedCRS());
        }
        return results;
    }

    @Override
    public boolean canHandle(MapLayerInfo layer) {
        return layer.getType() == MapLayerInfo.TYPE_WMS;
    }

    private FeatureCollection forceCrs(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        if (((SimpleFeatureType)featureCollection.getSchema()).getCoordinateReferenceSystem() != null) {
            return featureCollection;
        }
        CoordinateReferenceSystem crs = LayerIdentifierUtils.getCrs(featureCollection);
        if (crs == null) {
            return featureCollection;
        }
        try {
            return new ForceCoordinateSystemFeatureResults(featureCollection, crs);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error forcing feature collection to use SRS '%s'.".formatted(CRS.toSRS((CoordinateReferenceSystem)crs)), exception);
        }
    }

    private WMS getWms() {
        if (this.wms == null) {
            this.wms = (WMS)GeoServerExtensions.bean(WMS.class);
        }
        return this.wms;
    }

    @Override
    public SimpleFeatureCollection handleClipParam(FeatureInfoRequestParameters params, SimpleFeatureCollection fc) {
        Geometry clipGeometry = params.getGetMapRequest().getClip();
        if (clipGeometry == null) {
            return fc;
        }
        return DataUtilities.simple(new ClippedFeatureCollection(fc, clipGeometry));
    }
}

