/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.georss;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.feature.ReprojectingFeatureCollection;
import org.geoserver.wms.WMSMapContent;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class GeoRSSTransformerBase
extends TransformerBase {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.georss");
    static final Configuration GML_CONFIGURATION = new GMLConfiguration();
    protected GeometryEncoding geometryEncoding = GeometryEncoding.LATLONG;

    public void setGeometryEncoding(GeometryEncoding geometryEncoding) {
        this.geometryEncoding = geometryEncoding;
    }

    public static class GeometryEncoding {
        public static GeometryEncoding SIMPLE = new GeometryEncoding(){

            @Override
            public String getPrefix() {
                return "georss";
            }

            @Override
            public String getNamespaceURI() {
                return "http://www.georss.org/georss";
            }

            @Override
            public void encode(Geometry g, GeoRSSTranslatorSupport t) {
                Point p;
                if (g instanceof Point) {
                    p = (Point)g;
                    t.element("georss:point", p.getY() + " " + p.getX());
                }
                if (g instanceof LineString) {
                    LineString l = (LineString)g;
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < l.getNumPoints(); ++i) {
                        Coordinate c = l.getCoordinateN(i);
                        sb.append(c.y).append(" ").append(c.x).append(" ");
                    }
                    sb.setLength(sb.length() - 1);
                    t.element("georss:line", sb.toString());
                }
                if (g instanceof Polygon) {
                    p = (Polygon)g;
                    LinearRing line = p.getExteriorRing();
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < line.getNumPoints(); ++i) {
                        Coordinate c = line.getCoordinateN(i);
                        sb.append(c.y).append(" ").append(c.x).append(" ");
                    }
                    sb.setLength(sb.length() - 1);
                    t.element("georss:polygon", sb.toString());
                }
            }
        };
        public static GeometryEncoding GML = new GeometryEncoding(){

            @Override
            public String getPrefix() {
                return "gml";
            }

            @Override
            public String getNamespaceURI() {
                return "http://www.opengis.net/gml";
            }

            @Override
            public void encode(Geometry g, GeoRSSTranslatorSupport translator) {
                try {
                    QName elementName = null;
                    elementName = g instanceof Point ? org.geotools.gml2.GML.Point : (g instanceof LineString ? org.geotools.gml2.GML.LineString : (g instanceof Polygon ? org.geotools.gml2.GML.Polygon : (g instanceof MultiPoint ? org.geotools.gml2.GML.MultiPoint : (g instanceof MultiLineString ? org.geotools.gml2.GML.MultiLineString : (g instanceof MultiPolygon ? org.geotools.gml2.GML.MultiPolygon : org.geotools.gml2.GML._Geometry)))));
                    Encoder encoder = new Encoder(GML_CONFIGURATION);
                    encoder.encode((Object)g, elementName, (ContentHandler)translator);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot transform the specified geometry in GML", e);
                }
            }
        };
        public static GeometryEncoding LATLONG = new GeometryEncoding(){

            @Override
            public String getPrefix() {
                return "geo";
            }

            @Override
            public String getNamespaceURI() {
                return "http://www.w3.org/2003/01/geo/wgs84_pos#";
            }

            @Override
            public void encode(Geometry g, GeoRSSTranslatorSupport t) {
                Point p = g.getCentroid();
                t.element("geo:lat", "" + p.getY());
                t.element("geo:long", "" + p.getX());
            }
        };

        private GeometryEncoding() {
        }

        public String getPrefix() {
            return null;
        }

        public String getNamespaceURI() {
            return null;
        }

        public void encode(Geometry g, GeoRSSTranslatorSupport translator) {
        }
    }

    abstract class GeoRSSTranslatorSupport
    extends TransformerBase.TranslatorSupport
    implements ContentHandler {
        public GeoRSSTranslatorSupport(ContentHandler contentHandler, String prefix, String nsURI) {
            super(contentHandler, prefix, nsURI);
            this.nsSupport.declarePrefix(GeoRSSTransformerBase.this.geometryEncoding.getPrefix(), GeoRSSTransformerBase.this.geometryEncoding.getNamespaceURI());
        }

        protected void encodeGeometry(SimpleFeature feature) {
            if (feature.getDefaultGeometry() != null) {
                GeometryCollection mg;
                Geometry g = (Geometry)feature.getDefaultGeometry();
                if (g instanceof GeometryCollection && (mg = (GeometryCollection)g).getNumGeometries() == 1) {
                    g = mg.getGeometryN(0);
                }
                GeoRSSTransformerBase.this.geometryEncoding.encode(g, this);
            }
        }

        public void start(String element) {
            super.start(element);
        }

        public void element(String element, String content) {
            super.element(element, content);
        }

        protected List loadFeatureCollections(WMSMapContent map) throws IOException {
            ReferencedEnvelope mapArea = map.getRenderingArea();
            CoordinateReferenceSystem wgs84 = null;
            FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
            try {
                wgs84 = CRS.decode((String)"EPSG:4326");
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unable to decode WGS84...").initCause(e);
            }
            ArrayList<SimpleFeatureCollection> featureCollections = new ArrayList<SimpleFeatureCollection>();
            for (Layer layer : map.layers()) {
                Query query = layer.getQuery();
                SimpleFeatureCollection features = null;
                try {
                    SimpleFeatureSource source = (SimpleFeatureSource)layer.getFeatureSource();
                    GeometryDescriptor gd = ((SimpleFeatureType)source.getSchema()).getGeometryDescriptor();
                    if (gd == null) {
                        features = source.getFeatures(query);
                        continue;
                    }
                    ReferencedEnvelope env = new ReferencedEnvelope(mapArea);
                    CoordinateReferenceSystem sourceCRS = gd.getCoordinateReferenceSystem();
                    if (sourceCRS != null && !CRS.equalsIgnoreMetadata((Object)mapArea.getCoordinateReferenceSystem(), (Object)sourceCRS)) {
                        env = env.transform(sourceCRS, true);
                    }
                    Query mixed = new Query(query);
                    Filter original = query.getFilter();
                    BBOX bbox = ff.bbox(gd.getLocalName(), env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY(), null);
                    mixed.setFilter((Filter)ff.and(original, (Filter)bbox));
                    features = source.getFeatures(mixed);
                    if (sourceCRS != null && !CRS.equalsIgnoreMetadata((Object)wgs84, (Object)sourceCRS)) {
                        ReprojectingFeatureCollection coll = new ReprojectingFeatureCollection(features, wgs84);
                        coll.setDefaultSource(sourceCRS);
                        features = coll;
                    }
                    if (features == null) {
                        throw new NullPointerException();
                    }
                    featureCollections.add(features);
                }
                catch (Exception e) {
                    String msg = "Unable to encode map layer: " + String.valueOf(layer);
                    LOGGER.log(Level.SEVERE, msg, e);
                }
            }
            return featureCollections;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String string = new String(ch, start, length);
            this.chars(string);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.end("gml:" + localName);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.start(qName, atts);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (GeoRSSTransformerBase.this.getIndentation() > 0) {
                this.characters(ch, start, length);
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

