/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.icons;

import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wms.icons.IconPropertyInjector;
import org.geotools.api.style.Style;
import org.geotools.util.URLs;

public abstract class IconProperties {
    private IconProperties() {
    }

    public abstract Double getOpacity();

    public abstract Double getScale();

    public abstract Double getHeading();

    public abstract String href(String var1, WorkspaceInfo var2, String var3);

    public abstract Style inject(Style var1);

    public abstract Map<String, String> getProperties();

    public abstract String getIconName(Style var1);

    public abstract boolean isExternal();

    public static IconProperties generator(final Double opacity, final Double scale, final Double heading, final Map<String, String> styleProperties) {
        return new IconProperties(){

            @Override
            public Double getOpacity() {
                return opacity;
            }

            @Override
            public Double getScale() {
                return scale;
            }

            @Override
            public Double getHeading() {
                return heading;
            }

            @Override
            public boolean isExternal() {
                return false;
            }

            @Override
            public String href(String baseURL, WorkspaceInfo workspace, String styleName) {
                Object stylePathFragment = workspace != null ? ResponseUtils.urlEncode((String)workspace.getName(), (char[])new char[0]) + "/" + ResponseUtils.urlEncode((String)styleName, (char[])new char[0]) : ResponseUtils.urlEncode((String)styleName, (char[])new char[0]);
                return ResponseUtils.buildURL((String)baseURL, (String)("kml/icon/" + (String)stylePathFragment), (Map)styleProperties, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
            }

            @Override
            public Style inject(Style base) {
                return IconPropertyInjector.injectProperties(base, styleProperties);
            }

            @Override
            public Map<String, String> getProperties() {
                return styleProperties;
            }

            @Override
            public String getIconName(Style style) {
                try {
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    digest.update(style.getName().getBytes(StandardCharsets.UTF_8));
                    for (Map.Entry property : styleProperties.entrySet()) {
                        digest.update(((String)property.getKey()).getBytes(StandardCharsets.UTF_8));
                        digest.update(((String)property.getValue()).getBytes(StandardCharsets.UTF_8));
                    }
                    byte[] hash = digest.digest();
                    StringBuilder builder = new StringBuilder();
                    for (byte b : hash) {
                        builder.append("%02x".formatted(b));
                    }
                    return builder.toString();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static IconProperties externalReference(final Double opacity, final Double scale, final Double heading, final String url) {
        return new IconProperties(){

            @Override
            public Double getOpacity() {
                return opacity;
            }

            @Override
            public Double getScale() {
                return scale;
            }

            @Override
            public Double getHeading() {
                return heading;
            }

            @Override
            public String href(String baseURL, WorkspaceInfo workspace, String styleName) {
                try {
                    URL target = new URL(url);
                    String graphicProtocol = target.getProtocol();
                    if ("file".equals(graphicProtocol)) {
                        File file = URLs.urlToFile((URL)target);
                        File workspaceStyles = null;
                        if (file.isAbsolute()) {
                            GeoServerDataDirectory dataDir = (GeoServerDataDirectory)GeoServerExtensions.bean((String)"dataDirectory");
                            File styles = dataDir.getStyles(new String[0]).dir().getCanonicalFile();
                            if (workspace != null) {
                                workspaceStyles = dataDir.getStyles(workspace, new String[0]).dir().getCanonicalFile();
                            }
                            if ((file = file.getCanonicalFile()).getAbsolutePath().startsWith(styles.getAbsolutePath())) {
                                return this.buildGraphicURL(baseURL, "styles", styles, file);
                            }
                            if (workspaceStyles != null && file.getAbsolutePath().startsWith(workspaceStyles.getAbsolutePath())) {
                                return this.buildGraphicURL(baseURL, "styles/" + workspace.getName(), workspaceStyles, file);
                            }
                            return null;
                        }
                        return ResponseUtils.buildURL((String)baseURL, (String)("styles/" + target.getPath()), Collections.emptyMap(), (URLMangler.URLType)URLMangler.URLType.RESOURCE);
                    }
                    if (!"http".equals(graphicProtocol) && !"https".equals(graphicProtocol)) {
                        return null;
                    }
                    return url;
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }

            @Override
            public boolean isExternal() {
                return true;
            }

            @Override
            public Style inject(Style base) {
                return IconPropertyInjector.injectProperties(base, Collections.emptyMap());
            }

            @Override
            public Map<String, String> getProperties() {
                return Collections.emptyMap();
            }

            @Override
            public String getIconName(Style style) {
                throw new RuntimeException("An implementation is missing");
            }

            private String buildGraphicURL(String baseURL, String styleRelativeUrl, File styleDir, File graphicFile) {
                String relativePath = styleDir.toURI().relativize(graphicFile.toURI()).toString();
                return ResponseUtils.buildURL((String)baseURL, (String)(styleRelativeUrl + "/" + relativePath), null, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
            }
        };
    }
}

