/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.icons;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import org.geoserver.wms.icons.Icons;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.Symbolizer;
import org.geotools.data.memory.MemoryFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public final class IconRenderer {
    private static final ReferencedEnvelope sampleArea = new ReferencedEnvelope(-1.0, 1.0, -1.0, 1.0, null);
    private static final SimpleFeatureCollection sampleData;
    static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage renderIcon(Style style) {
        int size = IconRenderer.findIconSize(style) + 2;
        MapContent mapContent = new MapContent();
        mapContent.addLayer((Layer)new FeatureLayer((FeatureCollection)sampleData, style));
        BufferedImage image = new BufferedImage(size * 4, size * 4, 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.scale(4.0, 4.0);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mapContent);
        try {
            try {
                renderer.paint(graphics, new Rectangle(size, size), sampleArea);
            }
            finally {
                graphics.dispose();
            }
        }
        finally {
            mapContent.dispose();
        }
        return image;
    }

    private static int findIconSize(Style style) {
        int size = 0;
        if (style.featureTypeStyles().isEmpty()) {
            throw new IllegalArgumentException("Feature type style list was empty");
        }
        for (FeatureTypeStyle ftStyle : style.featureTypeStyles()) {
            if (ftStyle.rules().isEmpty()) {
                throw new IllegalArgumentException("Rule list was empty");
            }
            for (Rule rule : ftStyle.rules()) {
                if (rule.symbolizers().isEmpty()) {
                    throw new IllegalArgumentException("Symbolizer list was empty");
                }
                for (Symbolizer symbolizer : rule.symbolizers()) {
                    if (symbolizer instanceof PointSymbolizer) {
                        PointSymbolizer pointSymbolizer = (PointSymbolizer)symbolizer;
                        Graphic g = pointSymbolizer.getGraphic();
                        if (g == null) continue;
                        Double rotation = g.getRotation() != null ? (Double)g.getRotation().evaluate(null, Double.class) : null;
                        size = Math.max(size, IconRenderer.getGraphicSize(g, rotation));
                        continue;
                    }
                    throw new IllegalArgumentException("IconRenderer only supports PointSymbolizer");
                }
            }
        }
        return size;
    }

    private static int getGraphicSize(Graphic g, Double rotation) {
        Double result = Icons.graphicSize(g, rotation, null);
        if (result == null) {
            return 16;
        }
        return (int)Math.ceil(result);
    }

    static {
        LOGGER = Logging.getLogger((String)"org.geoserver.wms.icons");
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("example");
        typeBuilder.setNamespaceURI("http://example.com/");
        typeBuilder.setSRS("EPSG:4326");
        typeBuilder.add("the_geom", Point.class);
        GeometryFactory geomFactory = new GeometryFactory();
        SimpleFeatureType featureType = typeBuilder.buildFeatureType();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        featureBuilder.set("the_geom", (Object)geomFactory.createPoint(new Coordinate(0.0, 0.0)));
        MemoryFeatureCollection temp = new MemoryFeatureCollection(featureType);
        temp.add(featureBuilder.buildFeature(null));
        sampleData = temp;
    }
}

