/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.kvp;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.ows.FlatKvpParser;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;

public class MapLayerInfoKvpParser
extends KvpParser {
    private FlatKvpParser rawNamesParser;
    private final WMS wms;
    private List<String> styles;

    public MapLayerInfoKvpParser(String key, WMS wms) {
        super(key, MapLayerInfo.class);
        this.wms = wms;
        this.rawNamesParser = new FlatKvpParser(key, String.class);
    }

    public MapLayerInfoKvpParser(String key, WMS wms, String styles) {
        this(key, wms);
        this.styles = KvpUtils.readFlat((String)styles);
    }

    protected boolean skipResource(Object theResource) {
        return false;
    }

    public List<MapLayerInfo> parse(String paramValue) throws Exception {
        List layerNames = (List)this.rawNamesParser.parse(paramValue);
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>(layerNames.size());
        MapLayerInfo layer = null;
        for (int i = 0; i < layerNames.size(); ++i) {
            String layerName = (String)layerNames.get(i);
            LayerInfo layerInfo = this.wms.getLayerByName(layerName);
            if (layerInfo == null) {
                String styleName;
                LayerGroupInfo groupInfo = this.wms.getLayerGroupByName(layerName);
                if (groupInfo == null || LayerGroupInfo.Mode.CONTAINER.equals((Object)groupInfo.getMode())) {
                    throw new ServiceException(layerName + ": no such layer on this server", "LayerNotDefined", ((Object)((Object)this)).getClass().getSimpleName());
                }
                if (this.skipResource(groupInfo)) continue;
                List groupLayers = this.styles != null && i < this.styles.size() && LayerGroupHelper.isSingleOrOpaque((LayerGroupInfo)groupInfo) ? ((styleName = this.styles.get(i)) != null && !"".equals(styleName) ? groupInfo.layers(styleName) : groupInfo.layers()) : groupInfo.layers();
                for (LayerInfo li : groupLayers) {
                    if (this.skipResource(li)) continue;
                    layer = new MapLayerInfo(li, groupInfo.getMetadata());
                    layers.add(layer);
                }
                continue;
            }
            if (this.skipResource(layerInfo)) continue;
            layer = new MapLayerInfo(layerInfo);
            layers.add(layer);
        }
        return layers;
    }
}

