/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.kvp;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.wms.kvp.PALFileLoader;
import org.geotools.image.palette.InverseColorMapOp;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;

public class PaletteManager {
    private static final Logger LOG = Logging.getLogger((String)"PaletteManager");
    public static final String QUANTIZER = "quantizer";
    public static final String SAFE = "SAFE";
    public static final IndexColorModel safePalette = PaletteManager.buildDefaultPalette();
    static SoftValueHashMap<String, PaletteCacheEntry> paletteCache = new SoftValueHashMap();
    static SoftValueHashMap<IndexColorModelKey, InverseColorMapOp> opCache = new SoftValueHashMap();

    private PaletteManager() {
    }

    public static IndexColorModel getPalette(String name) throws Exception {
        if (SAFE.equals(name.toUpperCase())) {
            return safePalette;
        }
        PaletteCacheEntry entry = (PaletteCacheEntry)paletteCache.get((Object)name);
        if (entry != null) {
            if (entry.isStale()) {
                paletteCache.remove((Object)name);
            } else {
                return entry.icm;
            }
        }
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        Resource palettes = loader.get("palettes");
        HashSet<String> names = new HashSet<String>();
        names.addAll(Arrays.asList(name + ".gif", name + ".png", name + ".pal", name + ".tif"));
        ArrayList<Resource> paletteFiles = new ArrayList<Resource>();
        for (Resource item : palettes.list()) {
            if (!names.contains(item.name().toLowerCase())) continue;
            paletteFiles.add(item);
        }
        for (Resource resource : paletteFiles) {
            String fileName = resource.name();
            if (fileName.endsWith("pal")) {
                IndexColorModel icm = new PALFileLoader(resource).getIndexColorModel();
                if (icm != null) {
                    paletteCache.put((Object)name, (Object)new PaletteCacheEntry(resource, icm));
                    return icm;
                }
            } else {
                try (ImageInputStream iis = ImageIO.createImageInputStream(resource.in());){
                    Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
                    if (it.hasNext()) {
                        ImageReader reader = it.next();
                        reader.setInput(iis);
                        ColorModel cm = reader.getImageTypes(0).next().getColorModel();
                        if (cm instanceof IndexColorModel) {
                            IndexColorModel icm = (IndexColorModel)cm;
                            paletteCache.put((Object)name, (Object)new PaletteCacheEntry(resource, icm));
                            IndexColorModel indexColorModel = icm;
                            return indexColorModel;
                        }
                    }
                }
            }
            LOG.warning("Skipping paletteInverter file " + fileName + " since color model is not indexed (no 256 colors paletteInverter)");
        }
        return null;
    }

    public static InverseColorMapOp getInverseColorMapOp(IndexColorModel icm) {
        IndexColorModelKey key = new IndexColorModelKey(icm);
        InverseColorMapOp op = (InverseColorMapOp)opCache.get((Object)key);
        if (op != null) {
            return op;
        }
        op = new InverseColorMapOp(icm);
        opCache.put((Object)key, (Object)op);
        return op;
    }

    static IndexColorModel buildDefaultPalette() {
        int[] cmap = new int[256];
        int i = 0;
        int opaqueAlpha = -16777216;
        for (int r = 0; r < 256; r += 51) {
            for (int g = 0; g < 256; g += 51) {
                for (int b = 0; b < 256; b += 51) {
                    cmap[i] = opaqueAlpha | r << 16 | g << 8 | b;
                    ++i;
                }
            }
        }
        int grayIncr = 256 / (255 - i);
        int gray = 255 - (255 - i - 1) * grayIncr;
        while (i < 255) {
            cmap[i] = opaqueAlpha | gray << 16 | gray << 8 | gray;
            gray += grayIncr;
            ++i;
        }
        cmap[255] = 0xFFFFFF;
        return new IndexColorModel(8, 256, cmap, 0, true, 255, 0);
    }

    private static class PaletteCacheEntry {
        Resource file;
        long lastModified;
        IndexColorModel icm;

        public PaletteCacheEntry(Resource file, IndexColorModel icm) {
            this.file = file;
            this.icm = icm;
            this.lastModified = file.lastmodified();
        }

        public boolean isStale() {
            return !Resources.exists((Resource)this.file) || this.file.lastmodified() != this.lastModified;
        }
    }

    private static class IndexColorModelKey {
        IndexColorModel icm;

        public IndexColorModelKey(IndexColorModel icm) {
            this.icm = icm;
        }

        public int hashCode() {
            return System.identityHashCode(this.icm);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexColorModelKey other = (IndexColorModelKey)obj;
            return this.icm == other.icm;
        }
    }
}

