/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.GetMap;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geoserver.wms.legendgraphic.NoOpGraphics2D;
import org.geoserver.wms.map.GetMapKvpRequestReader;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.type.Name;
import org.geotools.api.style.Description;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.api.util.InternationalString;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.AbstractStyleVisitor;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.util.Converters;
import org.geotools.util.SimpleInternationalString;

class FeatureCountProcessor {
    static final StyleFactory SF = CommonFactoryFinder.getStyleFactory();
    public static final String WIDTH = "WIDTH";
    public static final String HEIGHT = "HEIGHT";
    private GetLegendGraphicRequest request;
    private GetMapKvpRequestReader getMapReader;
    private boolean hideEmptyRules;
    private boolean countMatched;

    public FeatureCountProcessor(GetLegendGraphicRequest request) {
        this.request = request;
        this.getMapReader = new GetMapKvpRequestReader(request.getWms());
        if (Boolean.TRUE.equals(request.getLegendOption("countMatched", Boolean.class))) {
            this.countMatched = true;
        }
        if (Boolean.TRUE.equals(request.getLegendOption("hideEmptyRules", Boolean.class))) {
            this.hideEmptyRules = true;
        }
    }

    public Rule[] preProcessRules(GetLegendGraphicRequest.LegendRequest legend, Rule[] rules) {
        if (rules == null || rules.length == 0) {
            return rules;
        }
        MatchFirstVisitor matchFirstVisitor = new MatchFirstVisitor();
        legend.getStyle().accept((StyleVisitor)matchFirstVisitor);
        boolean matchFirst = matchFirstVisitor.matchFirst;
        try {
            GetMapRequest getMapRequest = this.parseAssociatedGetMap(legend, rules);
            Map<Rule, AtomicInteger> counters = this.renderAndCountFeatures(rules, getMapRequest, matchFirst);
            Rule[] result = this.updateRuleTitles(rules, counters);
            return result;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    private Rule[] updateRuleTitles(Rule[] rules, Map<Rule, AtomicInteger> counters) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (Rule rule : rules) {
            AtomicInteger counter = counters.get(rule);
            if (counter.get() == 0 && this.hideEmptyRules) continue;
            Object label = LegendUtils.getRuleLabel(rule, this.request);
            if (this.countMatched) {
                label = StringUtils.isEmpty((CharSequence)label) ? "(" + counter.get() + ")" : (String)label + " (" + counter.get() + ")";
            }
            TargetLabelUpdater duplicatingVisitor = new TargetLabelUpdater((String)label);
            rule.accept((StyleVisitor)duplicatingVisitor);
            Rule clone = (Rule)duplicatingVisitor.getCopy();
            result.add(clone);
        }
        return result.toArray(new Rule[result.size()]);
    }

    private Map<Rule, AtomicInteger> renderAndCountFeatures(final Rule[] rules, GetMapRequest getMapRequest, final boolean matchFirst) {
        final WMS wms = this.request.getWms();
        final Map<Rule, AtomicInteger> counters = Arrays.stream(rules).collect(Collectors.toMap(Function.identity(), r -> new AtomicInteger(0)));
        GetMap getMap = new GetMap(wms){

            @Override
            protected GetMapOutputFormat getDelegate(String outputFormat) throws ServiceException {
                return new FeatureRenderSpyFormat(wms, f -> {
                    boolean matched = false;
                    for (Rule rule : rules) {
                        AtomicInteger counter;
                        if (rule.isElseFilter()) {
                            if (matched) continue;
                            counter = (AtomicInteger)counters.get(rule);
                            counter.incrementAndGet();
                            continue;
                        }
                        if (rule.getFilter() != null && !rule.getFilter().evaluate(f)) continue;
                        counter = (AtomicInteger)counters.get(rule);
                        counter.incrementAndGet();
                        matched = true;
                        if (matchFirst) break;
                    }
                });
            }
        };
        getMap.run(getMapRequest);
        return counters;
    }

    private GetMapRequest parseAssociatedGetMap(GetLegendGraphicRequest.LegendRequest legend, Rule[] rules) throws Exception {
        Map formatOptions;
        CaseInsensitiveMap kvp = new CaseInsensitiveMap(this.request.getKvp());
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(new HashMap());
        this.request.getRawKvp().forEach((arg_0, arg_1) -> FeatureCountProcessor.lambda$parseAssociatedGetMap$1((Map)rawKvp, arg_0, arg_1));
        kvp.remove(WIDTH);
        kvp.remove(HEIGHT);
        rawKvp.remove(WIDTH);
        rawKvp.remove(HEIGHT);
        String layerName = this.getLayerName(legend);
        kvp.put("LAYERS", layerName);
        rawKvp.put("LAYERS", layerName);
        kvp.put("STYLES", "");
        rawKvp.put("STYLES", "");
        String srcWidth = (String)rawKvp.get("SRCWIDTH");
        String srcHeight = (String)rawKvp.get("SRCHEIGHT");
        rawKvp.put(WIDTH, srcWidth);
        rawKvp.put(HEIGHT, srcHeight);
        if (srcWidth != null) {
            kvp.put(WIDTH, Converters.convert((Object)srcWidth, Integer.class));
        }
        if (srcHeight != null) {
            kvp.put(HEIGHT, Converters.convert((Object)srcHeight, Integer.class));
        }
        if ((formatOptions = (Map)kvp.get("FORMAT_OPTIONS")) != null) {
            formatOptions.remove("layout");
        }
        Object getMap = this.getMapReader.read((Object)this.getMapReader.createRequest(), (Map)kvp, (Map)rawKvp);
        DefaultWebMapService.autoSetBoundsAndSize((GetMapRequest)getMap);
        Style style = this.buildStyleFromRules(rules);
        ((GetMapRequest)getMap).setStyles(Arrays.asList(style));
        return getMap;
    }

    private String getLayerName(GetLegendGraphicRequest.LegendRequest legend) {
        if (legend.getLayer() != null) {
            return legend.getLayer();
        }
        if (legend.getLayerInfo() != null) {
            return legend.getLayerInfo().prefixedName();
        }
        if (legend.getFeatureType() != null) {
            Name name = legend.getFeatureType().getName();
            NamespaceInfo ns = this.request.getWms().getCatalog().getNamespaceByURI(name.getNamespaceURI());
            String localName = name.getLocalPart();
            if (ns != null) {
                return ns.getPrefix() + ":" + localName;
            }
            return localName;
        }
        throw new ServiceException("Could not get the layer name out of " + String.valueOf(legend));
    }

    private Style buildStyleFromRules(Rule[] rules) {
        FeatureTypeStyle fts = SF.createFeatureTypeStyle();
        fts.rules().addAll(Arrays.asList(rules));
        Style style = SF.createStyle();
        style.featureTypeStyles().add(fts);
        LabelReplacer replacer = new LabelReplacer();
        style.accept((StyleVisitor)replacer);
        return (Style)replacer.getCopy();
    }

    private static /* synthetic */ void lambda$parseAssociatedGetMap$1(Map rawKvp, String k, String v) {
        rawKvp.put(k, v);
    }

    private static class MatchFirstVisitor
    extends AbstractStyleVisitor {
        boolean matchFirst = false;

        private MatchFirstVisitor() {
        }

        public void visit(FeatureTypeStyle fts) {
            this.matchFirst |= "first".equals(fts.getOptions().get("ruleEvaluation"));
        }
    }

    private static final class TargetLabelUpdater
    extends DuplicatingStyleVisitor {
        private String targetLabel;

        public TargetLabelUpdater(String targetLabel) {
            this.targetLabel = targetLabel;
        }

        public void visit(Rule rule) {
            super.visit(rule);
            Rule copy = (Rule)this.pages.peek();
            Description description = this.sf.description((InternationalString)new SimpleInternationalString(this.targetLabel), copy.getDescription() != null ? copy.getDescription().getAbstract() : null);
            copy.setDescription(description);
        }
    }

    private static class LabelReplacer
    extends DuplicatingStyleVisitor {
        PointSymbolizer ps;

        LabelReplacer() {
            this.ps = this.sf.createPointSymbolizer();
            this.ps.getGraphic().graphicalSymbols().add(this.sf.createMark());
        }

        public void visit(TextSymbolizer text) {
            this.pages.push(this.ps);
        }
    }

    private static final class FeatureRenderSpyFormat
    extends RenderedImageMapOutputFormat {
        private Consumer<Feature> consumer;

        private FeatureRenderSpyFormat(WMS wms, Consumer<Feature> consumer) {
            super(wms);
            this.consumer = consumer;
        }

        @Override
        protected RenderedImage prepareImage(int width, int height, IndexColorModel palette, boolean transparent) {
            return null;
        }

        @Override
        protected Graphics2D getGraphics(boolean transparent, Color bgColor, RenderedImage preparedImage, Map<RenderingHints.Key, Object> hintsMap) {
            return new NoOpGraphics2D();
        }

        @Override
        protected void onBeforeRender(StreamingRenderer renderer) {
            super.onBeforeRender(renderer);
            renderer.setGeneralizationDistance(0.0);
            renderer.addRenderListener(new RenderListener(){

                public void featureRenderer(SimpleFeature feature) {
                    consumer.accept((Feature)feature);
                }

                public void errorOccurred(Exception e) {
                }
            });
        }
    }
}

