/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.Queue;
import org.geoserver.wms.legendgraphic.Tally;

class ImageQueue {
    private final Queue<BufferedImage> queue = new LinkedList<BufferedImage>();
    private final Tally tally;

    public ImageQueue(Tally tally) {
        this.tally = tally;
    }

    public void add(BufferedImage image) {
        this.tally.addImage(image);
        this.queue.add(image);
    }

    public void addAll(ImageQueue imageQueue) {
        for (int i = 0; i < imageQueue.size(); ++i) {
            BufferedImage item = imageQueue.poll();
            this.queue.add(item);
        }
    }

    public BufferedImage remove() {
        return this.queue.remove();
    }

    public BufferedImage poll() {
        return this.queue.poll();
    }

    public int size() {
        return this.queue.size();
    }

    public Queue<BufferedImage> get() {
        return this.queue;
    }
}

