/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.legendgraphic.DisabledRulesRemover;
import org.geoserver.wms.legendgraphic.FeatureCountProcessor;
import org.geoserver.wms.legendgraphic.TransformationFunctionTranslator;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.process.Processors;
import org.geotools.process.function.ProcessFunction;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.styling.visitor.DpiRescaleStyleVisitor;
import org.geotools.styling.visitor.LegendRenderingSelectorStyleVisitor;
import org.geotools.styling.visitor.RescaleStyleVisitor;
import org.geotools.styling.visitor.UomRescaleStyleVisitor;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public abstract class LegendGraphicBuilder {
    public static final String MEMORY_USAGE_EXCEEDED = "Max legend graphic memory usage exceeded.";
    Logger LOGGER = Logger.getLogger("org.geoserver.wms.legendgraphic");
    public static final double TOLERANCE = 1.0E-6;
    protected static final GeometryFactory geomFac = new GeometryFactory();
    private LiteShape2 sampleLine;
    protected LiteShape2 samplePoint;
    protected final double MINIMUM_SYMBOL_SIZE = 3.0;
    double dpiScaleFactor;
    protected int w;
    protected int h;
    boolean forceLabelsOn = false;
    boolean forceLabelsOff = false;
    boolean forceTitlesOff = false;
    FeatureCountProcessor countProcessor = null;
    List<GetLegendGraphicRequest.LegendRequest> layers;
    boolean hasVectorTransformation = false;
    boolean hasRasterTransformation = false;

    public void setup(GetLegendGraphicRequest request) {
        Style style;
        String forceTitlesOpt;
        this.w = request.getWidth();
        this.h = request.getHeight();
        double dpi = RendererUtilities.getDpi(request.getLegendOptions());
        double standardDpi = RendererUtilities.getDpi(Collections.emptyMap());
        this.dpiScaleFactor = dpi / standardDpi;
        if (this.dpiScaleFactor != 1.0) {
            this.w = (int)Math.round((double)request.getWidth() * this.dpiScaleFactor);
            this.h = (int)Math.round((double)request.getHeight() * this.dpiScaleFactor);
        }
        if (request.getLegendOptions().get("forceLabels") instanceof String) {
            String forceLabelsOpt = (String)request.getLegendOptions().get("forceLabels");
            if (forceLabelsOpt.equalsIgnoreCase("on")) {
                this.forceLabelsOn = true;
            } else if (forceLabelsOpt.equalsIgnoreCase("off")) {
                this.forceLabelsOff = true;
            }
        }
        if (request.getLegendOptions().get("forceTitles") instanceof String && (forceTitlesOpt = (String)request.getLegendOptions().get("forceTitles")).equalsIgnoreCase("off")) {
            this.forceTitlesOff = true;
        }
        if (Boolean.TRUE.equals(request.getLegendOption("countMatched", Boolean.class)) || Boolean.TRUE.equals(request.getLegendOption("hideEmptyRules", Boolean.class))) {
            this.countProcessor = new FeatureCountProcessor(request);
        }
        this.layers = request.getLegends();
        if (Boolean.TRUE.equals(request.getLegendOption("hideEmptyRules", Boolean.class))) {
            for (GetLegendGraphicRequest.LegendRequest legend : request.getLegends()) {
                style = legend.getStyle();
                DisabledRulesRemover remover = new DisabledRulesRemover();
                style.accept((StyleVisitor)remover);
                legend.setStyle((Style)remover.getCopy());
            }
        }
        for (GetLegendGraphicRequest.LegendRequest legend : request.getLegends()) {
            style = legend.getStyle();
            Style translated = TransformationFunctionTranslator.translate(style);
            legend.setStyle(translated);
        }
    }

    public Symbolizer rescaleSymbolizer(Symbolizer symbolizer, double size, double newSize) {
        final double scaleFactor = newSize / size;
        RescaleStyleVisitor rescaleVisitor = new RescaleStyleVisitor(scaleFactor){

            protected Expression rescale(Expression expr) {
                if (expr == null) {
                    return null;
                }
                if (expr instanceof Literal) {
                    Double value = (Double)expr.evaluate(null, Double.class);
                    return this.ff.literal(value * scaleFactor);
                }
                return this.ff.multiply(expr, (Expression)this.ff.literal(scaleFactor));
            }
        };
        symbolizer.accept((StyleVisitor)rescaleVisitor);
        symbolizer = (Symbolizer)rescaleVisitor.getCopy();
        return symbolizer;
    }

    protected Style resizeForDPI(GetLegendGraphicRequest request, Style gt2Style) {
        if (this.dpiScaleFactor != 1.0) {
            DpiRescaleStyleVisitor dpiVisitor = new DpiRescaleStyleVisitor(this.dpiScaleFactor);
            dpiVisitor.visit(gt2Style);
            gt2Style = (Style)dpiVisitor.getCopy();
        }
        if (request.getScale() > 0.0) {
            double pixelsPerMeters = RendererUtilities.calculatePixelsPerMeterRatio((double)request.getScale(), request.getLegendOptions());
            UomRescaleStyleVisitor rescaleVisitor = new UomRescaleStyleVisitor(pixelsPerMeters);
            rescaleVisitor.visit(gt2Style);
            gt2Style = (Style)rescaleVisitor.getCopy();
        }
        return gt2Style;
    }

    protected double[] calcSymbolSize(double defaultMaxSize, double defaultMinSize, FeatureType featureType, Feature feature, Rule[] rules) {
        double minSize = defaultMaxSize;
        double maxSize = defaultMinSize;
        for (Rule rule : rules) {
            Feature sample = this.getSampleFeatureForRule(featureType, feature, rule);
            MetaBufferEstimator estimator = new MetaBufferEstimator(sample);
            for (Symbolizer symbolizer : rule.symbolizers()) {
                if (!(symbolizer instanceof PointSymbolizer) && !(symbolizer instanceof LineSymbolizer)) continue;
                double size = this.getSymbolizerSize(estimator, symbolizer, defaultMaxSize);
                if (size < minSize && !(symbolizer instanceof LineSymbolizer)) {
                    minSize = size;
                }
                if (!(size > maxSize)) continue;
                maxSize = size;
            }
        }
        return new double[]{minSize, maxSize};
    }

    protected double getSymbolizerSize(MetaBufferEstimator estimator, Symbolizer symbolizer, double defaultSize) {
        estimator.reset();
        symbolizer.accept((StyleVisitor)estimator);
        int buffer = estimator.getBuffer();
        if (buffer > 0) {
            return buffer;
        }
        return defaultSize;
    }

    protected Feature getSampleFeatureForRule(FeatureType featureType, Feature sample, Rule rule) {
        if (sample == null) {
            int dimensionality = 1;
            for (Symbolizer symbolizer : rule.symbolizers()) {
                if (LineSymbolizer.class.isAssignableFrom(symbolizer.getClass())) {
                    dimensionality = 2;
                }
                if (!PolygonSymbolizer.class.isAssignableFrom(symbolizer.getClass())) continue;
                dimensionality = 3;
            }
            return this.createSampleFeature(featureType, dimensionality);
        }
        return sample;
    }

    protected LiteShape2 getSampleShape(Symbolizer symbolizer, int legendWidth, int legendHeight, int areaWidth, int areaHeight) {
        LiteShape2 sampleShape;
        float hpad = (float)areaWidth * 0.15f + (float)(areaWidth - legendWidth) / 2.0f;
        float vpad = (float)areaHeight * 0.15f + (float)(areaHeight - legendHeight) / 2.0f;
        if (symbolizer instanceof LineSymbolizer) {
            if (this.sampleLine == null) {
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)((float)legendHeight - vpad - 1.0f)), new Coordinate((double)((float)legendWidth - hpad - 1.0f), (double)vpad)};
                LineString geom = geomFac.createLineString(coords);
                try {
                    this.sampleLine = new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    this.sampleLine = null;
                }
            }
            sampleShape = this.sampleLine;
        } else {
            if (symbolizer instanceof PolygonSymbolizer || symbolizer instanceof RasterSymbolizer) {
                float w = (float)areaWidth - 2.0f * hpad - 1.0f;
                float h = (float)areaHeight - 2.0f * vpad - 1.0f;
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)vpad), new Coordinate((double)hpad, (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)vpad), new Coordinate((double)hpad, (double)vpad)};
                LinearRing shell = geomFac.createLinearRing(coords);
                Polygon geom = geomFac.createPolygon(shell, null);
                try {
                    return new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (symbolizer instanceof PointSymbolizer || symbolizer instanceof TextSymbolizer) {
                if (this.samplePoint == null) {
                    Coordinate coord = new Coordinate((double)legendWidth / 2.0, (double)legendHeight / 2.0);
                    try {
                        this.samplePoint = new LiteShape2((Geometry)geomFac.createPoint(coord), null, null, false);
                    }
                    catch (Exception e) {
                        this.samplePoint = null;
                    }
                }
                sampleShape = this.samplePoint;
            } else {
                throw new IllegalArgumentException("Unknown symbolizer: " + String.valueOf(symbolizer));
            }
        }
        return sampleShape;
    }

    protected SimpleFeature createSampleFeature() {
        SimpleFeatureType type;
        try {
            type = DataUtilities.createType((String)"Sample", (String)"the_geom:Geometry");
        }
        catch (SchemaException e) {
            throw new RuntimeException(e);
        }
        return SimpleFeatureBuilder.template((SimpleFeatureType)type, null);
    }

    private Feature createSampleFeature(FeatureType schema, int dimensionality) throws ServiceException {
        if (schema instanceof SimpleFeatureType) {
            schema = this.cloneWithDimensionality(schema, dimensionality);
        }
        return this.createSampleFeature(schema);
    }

    private FeatureType cloneWithDimensionality(FeatureType schema, int dimensionality) {
        SimpleFeatureType simpleFt = (SimpleFeatureType)schema;
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(schema.getName());
        builder.setCRS(schema.getCoordinateReferenceSystem());
        for (AttributeDescriptor desc : simpleFt.getAttributeDescriptors()) {
            if (this.isMixedGeometry(desc)) {
                GeometryDescriptor geomDescriptor = (GeometryDescriptor)desc;
                GeometryType geomType = geomDescriptor.getType();
                Class<?> geometryClass = this.getGeometryForDimensionality(dimensionality);
                GeometryTypeImpl gt = new GeometryTypeImpl(geomType.getName(), geometryClass, geomType.getCoordinateReferenceSystem(), geomType.isIdentified(), geomType.isAbstract(), geomType.getRestrictions(), geomType.getSuper(), geomType.getDescription());
                builder.add((AttributeDescriptor)new GeometryDescriptorImpl((GeometryType)gt, geomDescriptor.getName(), geomDescriptor.getMinOccurs(), geomDescriptor.getMaxOccurs(), geomDescriptor.isNillable(), geomDescriptor.getDefaultValue()));
                continue;
            }
            builder.add(desc);
        }
        schema = builder.buildFeatureType();
        return schema;
    }

    private Class<?> getGeometryForDimensionality(int dimensionality) {
        if (dimensionality == 1) {
            return Point.class;
        }
        if (dimensionality == 2) {
            return LineString.class;
        }
        return Polygon.class;
    }

    protected Feature createSampleFeature(FeatureType schema) throws ServiceException {
        Object sampleFeature;
        try {
            SimpleFeatureType type;
            sampleFeature = schema instanceof SimpleFeatureType ? (this.hasMixedGeometry(type = (SimpleFeatureType)schema) ? null : SimpleFeatureBuilder.template((SimpleFeatureType)type, null)) : DataUtilities.templateFeature((FeatureType)schema);
        }
        catch (IllegalAttributeException e) {
            throw new ServiceException((Throwable)e);
        }
        return sampleFeature;
    }

    private boolean hasMixedGeometry(SimpleFeatureType schema) {
        for (AttributeDescriptor attDesc : schema.getAttributeDescriptors()) {
            if (!this.isMixedGeometry(attDesc)) continue;
            return true;
        }
        return false;
    }

    private boolean isMixedGeometry(AttributeDescriptor attDesc) {
        return attDesc instanceof GeometryDescriptor && attDesc.getType().getBinding() == Geometry.class;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public abstract Object buildLegendGraphic(GetLegendGraphicRequest var1);

    protected void checkForRenderingTransformations(Style gt2Style) {
        List ftsList = gt2Style.featureTypeStyles();
        for (FeatureTypeStyle fts : ftsList) {
            Parameter output;
            Expression exp = fts.getTransformation();
            if (exp == null) continue;
            HashMap<String, Parameter> outputs = Collections.emptyMap();
            if (exp instanceof ProcessFunction) {
                ProcessFunction processFunction = (ProcessFunction)exp;
                Name processName = processFunction.getProcessName();
                outputs = Processors.getResultInfo((Name)processName, null);
                if (outputs.isEmpty()) {
                    continue;
                }
            } else if (exp instanceof Function) {
                Function function = (Function)exp;
                FunctionName functionName = function.getFunctionName();
                if (functionName != null && functionName.getReturn() != null && functionName.getReturn().getName() != null && functionName.getReturn() instanceof Parameter) {
                    outputs = new HashMap<String, Parameter>();
                    outputs.put(functionName.getReturn().getName(), (Parameter)functionName.getReturn());
                }
                if (outputs.isEmpty()) continue;
            }
            if (!this.isVectorOrRaster(output = (Parameter)outputs.values().iterator().next())) continue;
            break;
        }
    }

    private boolean isVectorOrRaster(Parameter<?> output) {
        if (SimpleFeatureCollection.class.isAssignableFrom(output.getType())) {
            this.hasVectorTransformation = true;
            return true;
        }
        if (GridCoverage2D.class.isAssignableFrom(output.getType())) {
            this.hasRasterTransformation = true;
            return true;
        }
        return false;
    }

    protected Style applyRenderingSelection(Style style) {
        LegendRenderingSelectorStyleVisitor renderingSelectorStyleVisitor = new LegendRenderingSelectorStyleVisitor();
        style.accept((StyleVisitor)renderingSelectorStyleVisitor);
        return (Style)renderingSelectorStyleVisitor.getCopy();
    }
}

