/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.filter.function.CategorizeFunction;
import org.geotools.filter.function.InterpolateFunction;
import org.geotools.filter.function.RecodeFunction;

abstract class RuleContextExtractor {
    public static final String DASH_SEPARATOR = " - ";
    Function transformation;

    static List<RuleContext> extract(Function transformation) {
        if (transformation instanceof RecodeFunction) {
            RecodeFunction recode = (RecodeFunction)transformation;
            return new RecodeExtractor(recode).extract();
        }
        if (transformation instanceof CategorizeFunction) {
            CategorizeFunction categorize = (CategorizeFunction)transformation;
            return new CategorizeExtractor(categorize).extract();
        }
        if (transformation instanceof InterpolateFunction) {
            InterpolateFunction interpolate = (InterpolateFunction)transformation;
            return new InterpolateExtractor(interpolate).extract();
        }
        throw new IllegalStateException("Unexpected transformation function type: " + transformation.getClass().getName());
    }

    private RuleContextExtractor(Function transformation) {
        this.transformation = transformation;
    }

    public abstract List<RuleContext> extract();

    protected List<RuleContext> extractFromTable(List<Expression> parameters) {
        ArrayList<RuleContext> contexts = new ArrayList<RuleContext>();
        for (int i = 0; i < parameters.size(); i += 2) {
            Expression from = parameters.get(i);
            Expression to = parameters.get(i + 1);
            contexts.add(new RuleContext(RuleContextExtractor.toString(from), this.transformation, to, DASH_SEPARATOR));
        }
        return contexts;
    }

    protected static String toString(Expression expression) {
        if (expression == null) {
            return null;
        }
        String result = (String)expression.evaluate(null, String.class);
        if (result == null) {
            throw new IllegalStateException("Cannot convert expression to string: " + String.valueOf(expression));
        }
        return result;
    }

    private static class RecodeExtractor
    extends RuleContextExtractor {
        RecodeExtractor(RecodeFunction recode) {
            super((Function)recode);
        }

        @Override
        public List<RuleContext> extract() {
            return this.extractFromTable(this.transformation.getParameters().subList(1, this.transformation.getParameters().size()));
        }
    }

    private static class CategorizeExtractor
    extends RuleContextExtractor {
        public static final String SPACE = " ";

        private CategorizeExtractor(CategorizeFunction categorize) {
            super((Function)categorize);
        }

        @Override
        public List<RuleContext> extract() {
            Expression last;
            String lastValue;
            boolean succeeding = true;
            int skipAtEnd = this.transformation.getParameters().size() % 2;
            if (skipAtEnd == 1 && "preceding".equalsIgnoreCase(lastValue = CategorizeExtractor.toString(last = (Expression)this.transformation.getParameters().get(this.transformation.getParameters().size() - 1)))) {
                succeeding = false;
            }
            List categorizeTable = this.transformation.getParameters().subList(1, this.transformation.getParameters().size() - skipAtEnd);
            ArrayList<RuleContext> contexts = new ArrayList<RuleContext>();
            String titleSuffix = (succeeding ? "< " : "<= ") + CategorizeExtractor.toString((Expression)categorizeTable.get(1));
            contexts.add(new RuleContext(titleSuffix, this.transformation, (Expression)categorizeTable.get(0), SPACE));
            for (int i = 1; i < categorizeTable.size() - 2; i += 2) {
                String[] stringArray;
                Expression before = (Expression)categorizeTable.get(i);
                Expression value = (Expression)categorizeTable.get(i + 1);
                Expression after = (Expression)categorizeTable.get(i + 2);
                if (succeeding) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = ">= ";
                    stringArray = stringArray2;
                    stringArray2[1] = "< ";
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = "> ";
                    stringArray = stringArray3;
                    stringArray3[1] = "<= ";
                }
                String[] comparators = stringArray;
                titleSuffix = comparators[0] + CategorizeExtractor.toString(before) + " & " + comparators[1] + CategorizeExtractor.toString(after);
                contexts.add(new RuleContext(titleSuffix, this.transformation, value, SPACE));
            }
            int n = categorizeTable.size();
            titleSuffix = (succeeding ? ">= " : "> ") + CategorizeExtractor.toString((Expression)categorizeTable.get(n - 2));
            contexts.add(new RuleContext(titleSuffix, this.transformation, (Expression)categorizeTable.get(n - 1), SPACE));
            return contexts;
        }
    }

    private static class InterpolateExtractor
    extends RuleContextExtractor {
        static final Set<String> METHODS = Collections.newSetFromMap(new CaseInsensitiveMap());
        static final Set<String> MODES = Collections.newSetFromMap(new CaseInsensitiveMap());

        InterpolateExtractor(InterpolateFunction interpolate) {
            super((Function)interpolate);
        }

        @Override
        public List<RuleContext> extract() {
            int skipAtEnd = 0;
            if (this.isExpectedValueSpecified(this.transformation.getParameters(), MODES)) {
                ++skipAtEnd;
            }
            if (this.isExpectedValueSpecified(this.transformation.getParameters(), METHODS)) {
                ++skipAtEnd;
            }
            return this.extractFromTable(this.transformation.getParameters().subList(1, this.transformation.getParameters().size() - skipAtEnd));
        }

        private boolean isExpectedValueSpecified(List<Expression> parameters, Set<String> expectedValues) {
            int n = parameters.size();
            for (int i = 2; i >= 1; --i) {
                String value;
                Expression expr;
                int index = n - i;
                if (index <= 1 || !((expr = parameters.get(index)) instanceof Literal)) continue;
                Literal literal = (Literal)expr;
                if (!(((Literal)expr).getValue() instanceof String) || !expectedValues.contains(value = (String)literal.getValue())) continue;
                return true;
            }
            return false;
        }

        static {
            METHODS.add("numeric");
            METHODS.add("color");
            METHODS.add("colour");
            MODES.add("linear");
            MODES.add("cosine");
            MODES.add("cubic");
        }
    }

    record RuleContext(String titleSuffix, Function sourceFunction, Expression replacementValue, String separator) {
    }
}

