/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.style.Rule;
import org.geotools.filter.function.CategorizeFunction;
import org.geotools.filter.function.InterpolateFunction;
import org.geotools.filter.function.RecodeFunction;
import org.geotools.renderer.style.StyleAttributeExtractor;

class TransformationFunctionCollector
extends StyleAttributeExtractor {
    Rule currentRule;
    Map<Rule, Set<Function>> ruleTransformations = new HashMap<Rule, Set<Function>>();

    TransformationFunctionCollector() {
    }

    public void visit(Rule rule) {
        this.currentRule = rule;
        super.visit(rule);
        this.currentRule = null;
    }

    public Object visit(Function f, Object data) {
        if (this.currentRule != null && TransformationFunctionCollector.isTransformationFunction(f)) {
            this.ruleTransformations.computeIfAbsent(this.currentRule, r -> new HashSet()).add(f);
        }
        return data;
    }

    private static boolean isTransformationFunction(Function f) {
        return f instanceof RecodeFunction || f instanceof CategorizeFunction || f instanceof InterpolateFunction;
    }

    public Map<Rule, Set<Function>> getRuleFunctions() {
        return this.ruleTransformations;
    }

    public Map<Rule, Function> getTargetRule() {
        HashMap<Rule, Function> result = new HashMap<Rule, Function>();
        for (Map.Entry<Rule, Set<Function>> entry : this.ruleTransformations.entrySet()) {
            if (entry.getValue().size() != 1) continue;
            Function f = entry.getValue().iterator().next();
            result.put(entry.getKey(), f);
        }
        return result;
    }
}

