/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.geoserver.wms.legendgraphic.RuleContextExtractor;
import org.geoserver.wms.legendgraphic.TransformationFunctionCollector;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.style.Description;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;

class TransformationFunctionTranslator
extends DuplicatingStyleVisitor {
    Map<Rule, Function> targetRules;
    RuleContextExtractor.RuleContext ruleContext = null;
    private final DuplicatingFilterVisitor expressionTransformer;

    public static Style translate(Style style) {
        TransformationFunctionCollector collector = new TransformationFunctionCollector();
        style.accept((StyleVisitor)collector);
        Map<Rule, Function> targetRules = collector.getTargetRule();
        if (targetRules.isEmpty()) {
            return style;
        }
        TransformationFunctionTranslator translator = new TransformationFunctionTranslator(targetRules);
        style.accept((StyleVisitor)translator);
        return (Style)translator.getCopy();
    }

    private TransformationFunctionTranslator(Map<Rule, Function> targetRules) {
        this.targetRules = targetRules;
        this.expressionTransformer = new DuplicatingFilterVisitor(){

            public Object visit(Function function, Object extraData) {
                if (TransformationFunctionTranslator.this.ruleContext != null && Objects.equals(function, TransformationFunctionTranslator.this.ruleContext.sourceFunction())) {
                    return TransformationFunctionTranslator.this.ruleContext.replacementValue();
                }
                return super.visit(function, extraData);
            }
        };
    }

    public void visit(FeatureTypeStyle fts) {
        FeatureTypeStyleImpl copy = new FeatureTypeStyleImpl(fts);
        ArrayList<Rule> rulesCopy = new ArrayList<Rule>();
        for (Rule rule : fts.rules()) {
            rule.accept((StyleVisitor)this);
            Object popped = this.pages.pop();
            if (popped instanceof List) {
                rulesCopy.addAll((List)popped);
                continue;
            }
            if (popped instanceof Rule) {
                rulesCopy.add((Rule)popped);
                continue;
            }
            throw new IllegalStateException("Expected a Rule or List<Rule> to be returned from rule visit, got: " + (popped != null ? popped.getClass().getName() : "null"));
        }
        copy.rules().clear();
        copy.rules().addAll(rulesCopy);
        if (fts.getTransformation() != null) {
            copy.setTransformation(this.copy(fts.getTransformation()));
        }
        if (fts.getOnlineResource() != null) {
            copy.setOnlineResource(fts.getOnlineResource());
        }
        copy.getOptions().clear();
        copy.getOptions().putAll(fts.getOptions());
        this.pages.push(copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Rule rule) {
        Function transformation = this.targetRules.get(rule);
        if (transformation == null || transformation.getParameters().size() < 3) {
            super.visit(rule);
            return;
        }
        try {
            List<RuleContextExtractor.RuleContext> contexts = RuleContextExtractor.extract(transformation);
            ArrayList<Rule> generated = new ArrayList<Rule>();
            for (RuleContextExtractor.RuleContext context : contexts) {
                Rule modified = this.transformRule(rule, context);
                generated.add(modified);
            }
            this.pages.push(generated);
        }
        finally {
            this.ruleContext = null;
        }
    }

    private Rule transformRule(Rule rule, RuleContextExtractor.RuleContext context) {
        this.ruleContext = context;
        super.visit(rule);
        Rule modified = (Rule)this.pages.pop();
        Description description = modified.getDescription();
        if (description == null) {
            description = new DescriptionImpl();
            description.setTitle(context.titleSuffix());
        } else if (description.getTitle() == null) {
            description.setTitle(context.titleSuffix());
        } else {
            description.setTitle(description.getTitle().toString() + context.separator() + context.titleSuffix());
        }
        return modified;
    }

    protected Expression copy(Expression expression) {
        if (expression == null) {
            return null;
        }
        if (this.ruleContext != null) {
            return (Expression)expression.accept((ExpressionVisitor)this.expressionTransformer, (Object)this.ff);
        }
        return super.copy(expression);
    }
}

