/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.eclipse.imagen.Interpolation;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wms.CacheConfiguration;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSErrorCode;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.capabilities.CapabilityUtil;
import org.geoserver.wms.clip.ClipWMSGetMapCallBack;
import org.geoserver.wms.map.ProcessStandaloneSLDVisitor;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.NamedStyle;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.UserLayer;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.ows.URLCheckerException;
import org.geotools.data.ows.URLCheckers;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.renderer.style.StyleAttributeExtractor;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.Nullable;
import org.vfny.geoserver.util.Requests;
import org.vfny.geoserver.util.SLDValidator;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class GetMapKvpRequestReader
extends KvpRequestReader
implements DisposableBean {
    private static Map<String, Integer> interpolationMethods = new HashMap<String, Integer>();
    private FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private boolean parseStyles = true;
    private WMS wms;
    private EntityResolverProvider _entityResolverProvider;
    private volatile CloseableHttpClient _httpClient;
    private CacheConfiguration cacheCfg;
    private boolean laxStyleMatchAllowed = true;
    @Nullable
    private HttpClientConnectionManager httpClientConnectionManager;
    private final ConfigurationListenerAdapter wmsCacheConfigListener = new ConfigurationListenerAdapter(){

        public void handleServiceChange(ServiceInfo service, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
            if (service instanceof WMSInfo) {
                WMSInfo info = (WMSInfo)service;
                CacheConfiguration newCacheCfg = info.getCacheConfiguration();
                if (GetMapKvpRequestReader.this.cacheCfg != null && !newCacheCfg.equals(GetMapKvpRequestReader.this.cacheCfg)) {
                    try {
                        GetMapKvpRequestReader.this.closeHttpClient();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "Error closing HTTPClient", e);
                    }
                }
            }
        }
    };

    public GetMapKvpRequestReader(WMS wms) {
        this(wms, null);
        this.wms = wms;
    }

    public GetMapKvpRequestReader(WMS wms, HttpClientConnectionManager manager) {
        super(GetMapRequest.class);
        this.wms = wms;
        this.httpClientConnectionManager = manager;
    }

    private void addWmsCacheConfigListener() {
        GeoServer geoServer = this.wms.getGeoServer();
        geoServer.addListener((ConfigurationListener)this.wmsCacheConfigListener);
    }

    private void removeWmsCacheConfigListener() {
        GeoServer geoServer = this.wms.getGeoServer();
        if (null != geoServer) {
            geoServer.removeListener((ConfigurationListener)this.wmsCacheConfigListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpClient getHttpClient() {
        if (null == this._httpClient) {
            GetMapKvpRequestReader getMapKvpRequestReader = this;
            synchronized (getMapKvpRequestReader) {
                if (null == this._httpClient) {
                    CacheConfiguration wmsCacheConfig = this.getCacheConfig();
                    RequestConfig requestConfig = this.createHttpRequestConfig();
                    this._httpClient = this.createHttpClient(requestConfig, wmsCacheConfig);
                    this.addWmsCacheConfigListener();
                    return this._httpClient;
                }
            }
        }
        return this._httpClient;
    }

    private RequestConfig createHttpRequestConfig() {
        RequestConfig.Builder builder = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT);
        int timeoutMillis = this.getTimeoutMillis();
        builder.setConnectTimeout(timeoutMillis);
        builder.setSocketTimeout(timeoutMillis);
        return builder.build();
    }

    private CacheConfiguration getCacheConfig() {
        if (null == this.cacheCfg) {
            this.cacheCfg = this.wms.getRemoteResourcesCacheConfiguration();
        }
        return this.cacheCfg;
    }

    EntityResolverProvider getEntityResolverProvider() {
        if (null == this._entityResolverProvider) {
            this._entityResolverProvider = new EntityResolverProvider(this.wms.getGeoServer());
        }
        return this._entityResolverProvider;
    }

    private int getTimeoutMillis() {
        return this.wms.getServiceInfo().getRemoteStyleTimeout();
    }

    protected synchronized CloseableHttpClient createHttpClient(RequestConfig requestConfig, CacheConfiguration wmsCacheConfig) {
        HttpClientBuilder builder;
        Objects.requireNonNull(requestConfig);
        Objects.requireNonNull(wmsCacheConfig);
        if (wmsCacheConfig.isEnabled()) {
            CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(wmsCacheConfig.getMaxEntries()).setMaxObjectSize(wmsCacheConfig.getMaxEntrySize()).build();
            builder = CachingHttpClientBuilder.create().setCacheConfig(cacheConfig).setConnectionManager(this.httpClientConnectionManager).setDefaultRequestConfig(requestConfig);
        } else {
            builder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeHttpClient() throws IOException {
        GetMapKvpRequestReader getMapKvpRequestReader = this;
        synchronized (getMapKvpRequestReader) {
            if (this._httpClient != null) {
                CloseableHttpClient client = this._httpClient;
                this._httpClient = null;
                this.cacheCfg = null;
                this.removeWmsCacheConfigListener();
                client.close();
            }
        }
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public boolean isParseStyle() {
        return this.parseStyles;
    }

    public void setParseStyle(boolean styleRequired) {
        this.parseStyles = styleRequired;
    }

    public GetMapRequest createRequest() throws Exception {
        GetMapRequest request = new GetMapRequest();
        HttpServletRequest httpRequest = Optional.ofNullable((Request)Dispatcher.REQUEST.get()).map(r -> r.getHttpRequest()).orElse(null);
        if (httpRequest != null) {
            request.setRequestCharset(httpRequest.getCharacterEncoding());
            request.setGet("GET".equalsIgnoreCase(httpRequest.getMethod()));
            List headerNames = EnumerationUtils.toList((Enumeration)httpRequest.getHeaderNames());
            for (String headerName : headerNames) {
                request.putHttpRequestHeader(headerName, httpRequest.getHeader(headerName));
            }
        }
        return request;
    }

    protected boolean skipResource(Object theResource) {
        return false;
    }

    public GetMapRequest read(Object request, Map<String, Object> kvp, Map<String, Object> rawKvp) throws Exception {
        List<List<SortBy>> sortBy;
        String trans;
        GetMapRequest getMap = (GetMapRequest)super.read(request, kvp, rawKvp);
        getMap.setRawKvp((Map<String, String>)KvpUtils.toStringKVP(rawKvp));
        boolean citeCompliant = this.wms.getServiceInfo().isCiteCompliant();
        if (kvp.containsKey("crs")) {
            getMap.setSRS((String)kvp.get("crs"));
        } else if (citeCompliant && WMS.VERSION_1_3_0.equals((Object)WMS.version(getMap.getVersion()))) {
            throw new ServiceException("GetMap CRS parameter is mandatory in WMS 1.3");
        }
        if (citeCompliant && rawKvp != null && rawKvp.containsKey("transparent") && !(trans = (String)rawKvp.get("transparent")).equalsIgnoreCase("false") && !trans.equalsIgnoreCase("true")) {
            throw new Exception("Invalid value of GetMap TRANSPARENT parameter, choose between true or false");
        }
        this.parseCRS(getMap);
        String remoteOwsType = getMap.getRemoteOwsType();
        String string = remoteOwsType = remoteOwsType != null ? remoteOwsType.toUpperCase() : null;
        if (remoteOwsType != null && !"WFS".equals(remoteOwsType)) {
            throw new ServiceException("Unsupported remote OWS type '" + remoteOwsType + "'");
        }
        URL remoteOwsUrl = getMap.getRemoteOwsURL();
        if (remoteOwsUrl != null && remoteOwsType == null) {
            throw new ServiceException("REMOTE_OWS_URL specified, but REMOTE_OWS_TYPE is missing");
        }
        ArrayList<Object> requestedLayerInfos = new ArrayList<Object>();
        String layerParam = (String)rawKvp.get("LAYERS");
        if (layerParam != null) {
            List layerNames = KvpUtils.readFlat((String)layerParam);
            requestedLayerInfos.addAll(this.parseLayers(layerNames, remoteOwsUrl, remoteOwsType));
        } else if (citeCompliant && getMap.getSldBody() == null && getMap.getSld() == null) {
            throw new ServiceException("GetMap LAYERS parameter is mandatory if SLD nor SLD_BODY are not specified");
        }
        String stylesParam = (String)kvp.get("STYLES");
        ArrayList<String> styleNameList = new ArrayList<String>();
        if (stylesParam != null) {
            styleNameList.addAll(KvpUtils.readFlat((String)stylesParam));
        } else if (citeCompliant && getMap.getSldBody() == null && getMap.getSld() == null) {
            throw new ServiceException("GetMap STYLES parameter is mandatory if SLD nor SLD_BODY are not specified");
        }
        String interpolationParam = (String)kvp.get("INTERPOLATIONS");
        ArrayList<String> interpolationList = new ArrayList<String>();
        if (interpolationParam != null) {
            interpolationList.addAll(KvpUtils.readFlat((String)interpolationParam));
        }
        ArrayList<Filter> rawFilters = getMap.getFilter() != null ? new ArrayList<Filter>(getMap.getFilter()) : Collections.emptyList();
        ArrayList<Filter> cqlFilters = getMap.getCQLFilter() != null ? new ArrayList<Filter>(getMap.getCQLFilter()) : Collections.emptyList();
        List<List<SortBy>> rawSortBy = Optional.ofNullable(getMap.getSortBy()).orElse(Collections.emptyList());
        ArrayList<MapLayerInfo> newLayers = new ArrayList<MapLayerInfo>();
        int i = 0;
        while (i < requestedLayerInfos.size()) {
            Object o = requestedLayerInfos.get(i);
            if (this.skipResource(o)) {
                requestedLayerInfos.remove(i);
                if (i < styleNameList.size()) {
                    styleNameList.remove(i);
                }
                if (i < interpolationList.size()) {
                    interpolationList.remove(i);
                }
                if (i < rawFilters.size()) {
                    rawFilters.remove(i);
                }
                if (i < cqlFilters.size()) {
                    cqlFilters.remove(i);
                }
                if (i >= rawSortBy.size()) continue;
                rawSortBy.remove(i);
                continue;
            }
            if (o instanceof LayerInfo) {
                LayerInfo info2 = (LayerInfo)o;
                newLayers.add(new MapLayerInfo(info2));
            } else if (o instanceof LayerGroupInfo) {
                LayerGroupInfo info1 = (LayerGroupInfo)o;
                this.addGroupLayers(newLayers, info1, i, styleNameList);
            } else if (o instanceof MapLayerInfo) {
                MapLayerInfo info = (MapLayerInfo)o;
                newLayers.add(info);
            }
            ++i;
        }
        getMap.setLayers(newLayers);
        if (!interpolationList.isEmpty()) {
            getMap.setInterpolations(this.parseInterpolations(requestedLayerInfos, interpolationList));
        }
        List<Filter> filters = this.parseFilters(getMap, rawFilters, cqlFilters);
        List<List<SortBy>> list = sortBy = rawSortBy.isEmpty() ? null : rawSortBy;
        if ((getMap.getSldBody() != null || getMap.getSld() != null) && this.wms.isDynamicStylingDisabled()) {
            throw new ServiceException("Dynamic style usage is forbidden");
        }
        if (getMap.getSldBody() != null) {
            this.processSLDBody(getMap, requestedLayerInfos, styleNameList, filters, sortBy);
        } else if (getMap.getSld() != null) {
            this.processSLDLink(getMap, requestedLayerInfos, styleNameList, filters, sortBy);
        } else {
            this.processLayersStyles(getMap, requestedLayerInfos, styleNameList, filters, sortBy);
        }
        List<Map<String, String>> viewParams = getMap.getViewParams();
        if (viewParams != null && !viewParams.isEmpty()) {
            this.applyViewParams(getMap, viewParams, requestedLayerInfos);
        }
        boolean hasTime = false;
        boolean hasElevation = false;
        for (MapLayerInfo layer : getMap.getLayers()) {
            GridCoverage2DReader reader;
            MetadataMap metadata;
            if (layer.getType() == MapLayerInfo.TYPE_VECTOR) {
                metadata = layer.getResource().getMetadata();
                DimensionInfo elevationInfo = (DimensionInfo)metadata.get("elevation", DimensionInfo.class);
                hasElevation |= elevationInfo != null && elevationInfo.isEnabled();
                DimensionInfo timeInfo = (DimensionInfo)metadata.get("time", DimensionInfo.class);
                hasTime |= timeInfo != null && timeInfo.isEnabled();
                continue;
            }
            if (layer.getType() != MapLayerInfo.TYPE_RASTER) continue;
            metadata = layer.getResource().getMetadata();
            try {
                reader = (GridCoverage2DReader)layer.getCoverageReader();
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            if (reader == null) continue;
            ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
            DimensionInfo elevationInfo = (DimensionInfo)metadata.get("elevation", DimensionInfo.class);
            hasElevation |= elevationInfo != null && elevationInfo.isEnabled() && dimensions.hasElevation();
            DimensionInfo timeInfo = (DimensionInfo)metadata.get("time", DimensionInfo.class);
            hasTime |= timeInfo != null && timeInfo.isEnabled() && dimensions.hasTime();
        }
        if (hasTime && (getMap.getTime() == null || getMap.getTime().isEmpty())) {
            getMap.setTime(Arrays.asList(new Object[]{null}));
        }
        if (hasElevation && (getMap.getElevation() == null || getMap.getElevation().isEmpty())) {
            getMap.setElevation(Arrays.asList(new Object[]{null}));
        }
        if (getMap.getElevation() != null && getMap.getElevation().size() > 1 && getMap.getTime() != null && getMap.getTime().size() > 1) {
            throw new ServiceException("TIME and ELEVATION values cannot be both multivalued");
        }
        if (rawKvp.get("clip") != null) {
            getMap.setClip(this.getClipGeometry(getMap));
        }
        return getMap;
    }

    private void addGroupLayers(List<MapLayerInfo> newLayers, LayerGroupInfo lg, int index, List<String> requestedStyles) {
        if (index < requestedStyles.size()) {
            String style = requestedStyles.get(index);
            this.addLayersFromGroup(lg, newLayers, style);
        } else {
            this.addLayersFromGroup(lg, newLayers, null);
        }
    }

    private void addLayersFromGroup(LayerGroupInfo groupInfo, List<MapLayerInfo> newLayers, String styleName) {
        boolean isDefault = this.isDefaultLgStyle(styleName, groupInfo);
        List layers = !isDefault && this.isGroupStyleName(styleName, groupInfo) ? groupInfo.layers(styleName) : groupInfo.layers();
        if (layers != null && !layers.isEmpty()) {
            for (LayerInfo l : layers) {
                newLayers.add(new MapLayerInfo(l, groupInfo.getMetadata()));
            }
        }
    }

    private void applyViewParams(GetMapRequest getMap, List<Map<String, String>> viewParams, List<Object> requestedLayerInfos) {
        int layerCount = getMap.getLayers().size();
        if (viewParams.size() == layerCount) {
            return;
        }
        ArrayList<Map<String, String>> replacement = new ArrayList<Map<String, String>>();
        if (viewParams.size() == 1 && layerCount > 1) {
            for (i = 0; i < layerCount; ++i) {
                replacement.add(viewParams.get(0));
            }
        } else {
            for (i = 0; i < requestedLayerInfos.size(); ++i) {
                Object o = requestedLayerInfos.get(i);
                Map<String, String> layerParams = viewParams.get(i);
                if (o instanceof LayerGroupInfo) {
                    LayerGroupInfo groupInfo = (LayerGroupInfo)o;
                    List layers = groupInfo.layers();
                    if (layers == null) continue;
                    layers.stream().forEach(l -> replacement.add(layerParams));
                    continue;
                }
                replacement.add(layerParams);
            }
        }
        getMap.setViewParams(replacement);
        if (replacement.size() != layerCount) {
            String msg = layerCount + " layers requested, but found " + viewParams.size() + " view params specified. ";
            throw new ServiceException(msg, ((Object)((Object)this)).getClass().getName());
        }
    }

    private void processLayersStyles(GetMapRequest getMap, List<Object> requestedLayerInfos, List<String> styleNameList, List<Filter> filters, List<List<SortBy>> sortBy) throws Exception {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting layers and styles from LAYERS and STYLES");
        }
        ArrayList<String> groupStyleNames = new ArrayList<String>();
        if (!styleNameList.isEmpty()) {
            ArrayList<Style> parsedStyle = new ArrayList<Style>();
            this.parseStyles(styleNameList, requestedLayerInfos, parsedStyle, groupStyleNames);
            getMap.setStyles(parsedStyle);
        }
        if (this.isParseStyle() && !requestedLayerInfos.isEmpty()) {
            ArrayList<Style> oldStyles = getMap.getStyles() != null ? new ArrayList<Style>(getMap.getStyles()) : new ArrayList();
            ArrayList<Style> newStyles = new ArrayList<Style>();
            ArrayList<Filter> newFilters = filters == null ? null : new ArrayList<Filter>();
            ArrayList<List<SortBy>> newSortBy = sortBy == null ? null : new ArrayList<List<SortBy>>();
            for (int i = 0; i < requestedLayerInfos.size(); ++i) {
                Style style;
                Object o = requestedLayerInfos.get(i);
                Style style2 = style = oldStyles.isEmpty() ? null : (Style)oldStyles.get(i);
                if (o instanceof LayerGroupInfo) {
                    LayerGroupInfo groupInfo = (LayerGroupInfo)o;
                    this.resolveLayerGroup(i, groupStyleNames, groupInfo, newStyles, newFilters, newSortBy, filters, sortBy);
                    continue;
                }
                if (o instanceof LayerInfo) {
                    LayerInfo layer = (LayerInfo)o;
                    Style style3 = style = oldStyles.isEmpty() ? null : (Style)oldStyles.get(i);
                    if (style != null) {
                        newStyles.add(style);
                    } else {
                        newStyles.add(this.getDefaultStyle(layer));
                    }
                    if (filters != null) {
                        newFilters.add(this.getFilter(filters, i));
                    }
                    if (sortBy == null) continue;
                    newSortBy.add(this.getSortBy(sortBy, i));
                    continue;
                }
                if (!(o instanceof MapLayerInfo)) continue;
                MapLayerInfo info = (MapLayerInfo)o;
                Style style4 = style = oldStyles.isEmpty() ? null : (Style)oldStyles.get(i);
                if (style == null) {
                    throw new ServiceException("no style requested for layer " + info.getName(), "NoDefaultStyle");
                }
                newStyles.add(style);
                if (filters != null) {
                    newFilters.add(this.getFilter(filters, i));
                }
                if (sortBy == null) continue;
                newSortBy.add(this.getSortBy(sortBy, i));
            }
            getMap.setStyles(newStyles);
            if (newFilters != null && !newFilters.isEmpty() && getMap.getCQLFilter() != null && !getMap.getCQLFilter().isEmpty()) {
                getMap.setCQLFilter(newFilters);
            }
            getMap.setFilter(newFilters);
            getMap.setSortBy(newSortBy);
        }
        List<MapLayerInfo> layers = getMap.getLayers();
        if (this.isParseStyle() && layers != null && !layers.isEmpty()) {
            List<Style> styles = getMap.getStyles();
            if (layers.size() != styles.size()) {
                String msg = layers.size() + " layers requested, but found " + styles.size() + " styles specified. ";
                throw new ServiceException(msg, ((Object)((Object)this)).getClass().getName());
            }
            for (int i = 0; i < styles.size(); ++i) {
                Style currStyle = getMap.getStyles().get(i);
                if (currStyle == null) {
                    throw new ServiceException("Could not find a style for layer " + getMap.getLayers().get(i).getName() + ", either none was specified or no default style is available for it", "NoDefaultStyle");
                }
                GetMapKvpRequestReader.checkStyle(currStyle, layers.get(i));
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine(new StringBuffer("establishing ").append(currStyle.getName()).append(" style for ").append(layers.get(i).getName()).toString());
            }
        }
        List<Filter> mapFilters = getMap.getFilter();
        List<MapLayerInfo> mapLayers = getMap.getLayers();
        if (mapFilters != null && mapFilters.size() != mapLayers.size()) {
            String msg = mapLayers.size() + " layers requested, but found " + mapFilters.size() + " filters specified. ";
            throw new ServiceException(msg, ((Object)((Object)this)).getClass().getName());
        }
        List<List<SortBy>> mapSortBy = getMap.getSortBy();
        if (mapSortBy != null && mapSortBy.size() != mapLayers.size()) {
            String msg = mapLayers.size() + " layers requested, but found " + mapSortBy.size() + " sortBy specified. ";
            throw new ServiceException(msg, ((Object)((Object)this)).getClass().getName());
        }
    }

    private void resolveLayerGroup(int i, List<String> groupStyleNames, LayerGroupInfo groupInfo, List<Style> newStyles, List<Filter> newFilters, List<List<SortBy>> newSortBy, List<Filter> filters, List<List<SortBy>> sortBy) throws IOException {
        int j;
        String styleName;
        List layers = null;
        List styles = null;
        if (!groupStyleNames.isEmpty() && !this.isDefaultLgStyle(styleName = groupStyleNames.get(i), groupInfo) && this.isGroupStyleName(styleName, groupInfo)) {
            layers = groupInfo.layers(styleName);
            styles = groupInfo.styles(styleName);
        }
        if (layers == null) {
            layers = groupInfo.layers();
            styles = groupInfo.styles();
        }
        for (j = 0; j < styles.size(); ++j) {
            StyleInfo si = (StyleInfo)styles.get(j);
            if (si != null) {
                newStyles.add(si.getStyle());
                continue;
            }
            LayerInfo layer = (LayerInfo)layers.get(j);
            newStyles.add(this.getDefaultStyle(layer));
        }
        if (filters != null) {
            for (j = 0; j < layers.size(); ++j) {
                newFilters.add(this.getFilter(filters, i));
            }
        }
        if (sortBy != null) {
            for (j = 0; j < layers.size(); ++j) {
                newSortBy.add(this.getSortBy(sortBy, i));
            }
        }
    }

    private void processSLDLink(GetMapRequest getMap, List<Object> requestedLayerInfos, List<String> styleNameList, List<Filter> filters, List<List<SortBy>> sortBy) throws IOException {
        block18: {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting layers and styles from reomte SLD");
            }
            try {
                URLCheckers.confirm((URI)getMap.getSld());
            }
            catch (URLCheckerException e) {
                throw new ServiceException("Invalid SLD URL: " + String.valueOf(getMap.getSld()), (Throwable)e, "InvalidParameterValue", "sld");
            }
            try (InputStream input = this.getStream(getMap);){
                if (input == null) break block18;
                try (InputStreamReader reader = new InputStreamReader(input);){
                    List<Exception> errors;
                    if (getMap.getValidateSchema().booleanValue() && (errors = this.validateStyle(input, getMap)) != null && !errors.isEmpty()) {
                        throw new ServiceException(SLDValidator.getErrorMessage((InputStream)input, errors));
                    }
                    StyledLayerDescriptor sld = this.parseStyle(getMap, reader);
                    this.processSld(getMap, requestedLayerInfos, sld, styleNameList);
                }
                catch (Exception ex) {
                    Level l = Level.WARNING;
                    if (ex.getCause() instanceof SAXException && ex.getCause().getMessage().contains("Entity resolution disallowed")) {
                        throw ex;
                    }
                    LOGGER.log(l, "Exception while getting SLD.", ex);
                    throw new ServiceException("Error while getting SLD.");
                }
            }
        }
        getMap.setFilter(filters);
        getMap.setSortBy(sortBy);
    }

    private void processSLDBody(GetMapRequest getMap, List<Object> requestedLayerInfos, List<String> styleNameList, List<Filter> filters, List<List<SortBy>> sortBy) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting layers and styles from SLD_BODY");
        }
        if (getMap.getValidateSchema().booleanValue()) {
            try (StringReader reader = new StringReader(getMap.getSldBody());){
                List<Exception> errors = this.validateStyle(reader, getMap);
                if (!errors.isEmpty()) {
                    throw new ServiceException(SLDValidator.getErrorMessage((Reader)new StringReader(getMap.getSldBody()), errors));
                }
            }
        }
        try (StringReader input = new StringReader(getMap.getSldBody());){
            StyledLayerDescriptor sld = this.parseStyle(getMap, input);
            this.processSld(getMap, requestedLayerInfos, sld, styleNameList);
        }
        getMap.setFilter(filters);
        getMap.setSortBy(sortBy);
    }

    private void parseCRS(GetMapRequest getMap) {
        String srs = getMap.getSRS();
        srs = WMS.toInternalSRS(srs, WMS.version(getMap.getVersion()));
        getMap.setSRS(srs);
        if (srs != null) {
            try {
                CoordinateReferenceSystem mapcrs = CRS.decode((String)srs);
                getMap.setCrs(mapcrs);
            }
            catch (Exception e) {
                throw new ServiceException("Error occurred decoding the espg code " + srs, (Throwable)e, WMSErrorCode.INVALID_CRS.get(getMap.getVersion()));
            }
        }
    }

    private InputStream getStream(GetMapRequest getMap) throws IOException {
        URL styleUrl = getMap.getStyleUrl().toURL();
        if (styleUrl.getProtocol().toLowerCase().indexOf("http") == 0) {
            return this.getHttpInputStream(styleUrl, getMap.getHttpRequestHeader("Authorization"));
        }
        try {
            return Requests.getInputStream((URL)styleUrl);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Exception while getting SLD.", ex);
            throw new ServiceException("Error while getting SLD.");
        }
    }

    private InputStream getHttpInputStream(URL styleUrl, String authorizationHeader) throws IOException {
        InputStream inputStream;
        block16: {
            InputStream input = null;
            HttpCacheContext cacheContext = HttpCacheContext.create();
            HttpGet httpget = new HttpGet(styleUrl.toExternalForm());
            if (StringUtils.isNotBlank((String)authorizationHeader) && this.isAllowedURL(styleUrl)) {
                httpget.addHeader("Authorization", authorizationHeader);
            }
            CloseableHttpResponse response = this.executeRequest(cacheContext, httpget);
            try {
                CacheResponseStatus responseStatus;
                if (cacheContext != null && (responseStatus = cacheContext.getCacheResponseStatus()) != null) {
                    switch (responseStatus) {
                        case CACHE_HIT: {
                            if (!LOGGER.isLoggable(Level.FINE)) break;
                            LOGGER.fine("A response was generated from the cache with no requests sent upstream");
                            break;
                        }
                        case CACHE_MODULE_RESPONSE: {
                            if (!LOGGER.isLoggable(Level.FINE)) break;
                            LOGGER.fine("The response was generated directly by the caching module");
                            break;
                        }
                        case CACHE_MISS: {
                            if (!LOGGER.isLoggable(Level.FINE)) break;
                            LOGGER.fine("The response came from an upstream server");
                            break;
                        }
                        case VALIDATED: {
                            if (!LOGGER.isLoggable(Level.FINE)) break;
                            LOGGER.fine("The response was generated from the cache after validating the entry with the origin server");
                        }
                    }
                }
                input = response.getEntity().getContent();
                ByteArrayInputStream styleData = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)input));
                input.close();
                input = styleData;
                input.reset();
                inputStream = input;
                if (response == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Exception while getting SLD.", ex);
                    throw new ServiceException("Error while getting SLD.");
                }
            }
            response.close();
        }
        return inputStream;
    }

    private boolean isAllowedURL(URL styleUrl) {
        String url = styleUrl.toString();
        return this.wms.getAllowedURLsForAuthForwarding().stream().anyMatch(s -> url.startsWith((String)s));
    }

    protected CloseableHttpResponse executeRequest(HttpCacheContext cacheContext, final HttpGet httpget) throws IOException, ClientProtocolException {
        int hardTimeout = this.wms.getServiceInfo().getRemoteStyleMaxRequestTime();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (httpget != null) {
                    httpget.abort();
                }
            }
        };
        new Timer(true).schedule(task, hardTimeout);
        return this.getHttpClient().execute((HttpUriRequest)httpget, (HttpContext)cacheContext);
    }

    private List<Interpolation> parseInterpolations(List<Object> requestedLayers, List<String> interpolationList) {
        ArrayList<Interpolation> interpolations = new ArrayList<Interpolation>();
        for (int i = 0; i < requestedLayers.size(); ++i) {
            Object o;
            String interpolationName;
            Interpolation interpolation = null;
            if (i < interpolationList.size() && !(interpolationName = interpolationList.get(i)).trim().equals("")) {
                interpolation = this.getInterpolationObject(interpolationName);
            }
            if ((o = requestedLayers.get(i)) instanceof LayerInfo) {
                interpolations.add(interpolation);
                continue;
            }
            if (o instanceof LayerGroupInfo) {
                LayerGroupInfo info = (LayerGroupInfo)o;
                List subLayers = info.layers();
                interpolations.addAll(Collections.nCopies(subLayers.size(), interpolation));
                continue;
            }
            throw new IllegalArgumentException("Unknown layer info type: " + String.valueOf(o));
        }
        return interpolations;
    }

    private Interpolation getInterpolationObject(String interpolation) {
        return Interpolation.getInstance((int)interpolationMethods.get(interpolation.toUpperCase()));
    }

    private Style getDefaultStyle(LayerInfo layer) throws IOException {
        if (layer.getResource() instanceof WMSLayerInfo) {
            NamedStyle namedStyle = CommonFactoryFinder.getStyleFactory(null).createNamedStyle();
            namedStyle.setName(null);
            return namedStyle;
        }
        StyleInfo defaultStyle = layer.getDefaultStyle();
        return defaultStyle.getStyle();
    }

    Filter getFilter(List<Filter> filters, int index) {
        if (filters.size() == 1 && filters.get(0) instanceof Id) {
            return filters.get(0);
        }
        if (index < filters.size()) {
            return filters.get(index);
        }
        throw new ServiceException("Layers and filters are mismatched, you need to provide one filter for each layer");
    }

    List<SortBy> getSortBy(List<List<SortBy>> items, int index) {
        if (index < items.size()) {
            return items.get(index);
        }
        throw new ServiceException("Layers and sortBy are mismatched, you need to provide one sortBy for each layer");
    }

    private List<Filter> parseFilters(GetMapRequest getMap, List<Filter> rawFilters, List<Filter> cqlFilters) {
        List<Object> featureId;
        List<Filter> filters = rawFilters;
        List<Object> list = featureId = getMap.getFeatureId() != null ? getMap.getFeatureId() : Collections.emptyList();
        if (!featureId.isEmpty()) {
            if (!filters.isEmpty()) {
                throw new ServiceException("GetMap KVP request contained conflicting filters.  Filter: " + String.valueOf(rawFilters) + ", fid: " + String.valueOf(featureId));
            }
            HashSet<FeatureId> ids = new HashSet<FeatureId>();
            for (Object o : featureId) {
                ids.add(this.filterFactory.featureId((String)o));
            }
            filters = Collections.singletonList(this.filterFactory.id(ids));
        }
        if (!cqlFilters.isEmpty()) {
            if (!filters.isEmpty()) {
                throw new ServiceException("GetMap KVP request contained conflicting filters.  Filter: " + String.valueOf(rawFilters) + ", fid: " + String.valueOf(featureId) + ", cql: " + String.valueOf(cqlFilters));
            }
            filters = cqlFilters;
        }
        if (filters.isEmpty()) {
            filters = null;
        }
        return filters;
    }

    private List<Exception> validateStyle(Object input, GetMapRequest getMap) {
        try {
            String language = this.getStyleFormat(getMap);
            EntityResolverProvider entityResolverProvider = this.getEntityResolverProvider();
            EntityResolver entityResolver = entityResolverProvider.getEntityResolver();
            return Styles.handler((String)language).validate(input, getMap.styleVersion(), entityResolver);
        }
        catch (IOException e) {
            throw new ServiceException("Error validating style", (Throwable)e);
        }
    }

    private StyledLayerDescriptor parseStyle(GetMapRequest getMap, Reader reader) {
        try {
            String format = this.getStyleFormat(getMap);
            EntityResolverProvider entityResolverProvider = this.getEntityResolverProvider();
            EntityResolver entityResolver = entityResolverProvider.getEntityResolver();
            return Styles.handler((String)format).parse((Object)reader, getMap.styleVersion(), null, entityResolver);
        }
        catch (IOException e) {
            throw new ServiceException("Error parsing style", (Throwable)e);
        }
    }

    private String getStyleFormat(GetMapRequest request) {
        return request.getStyleFormat() != null ? request.getStyleFormat() : "sld";
    }

    private void processSld(GetMapRequest request, List<?> requestedLayers, StyledLayerDescriptor sld, List<String> styleNames) throws ServiceException, IOException {
        if (requestedLayers.isEmpty()) {
            sld.accept((StyleVisitor)new ProcessStandaloneSLDVisitor(this.wms, request));
        } else {
            this.processLibrarySld(request, sld, requestedLayers, styleNames);
        }
    }

    private void processLibrarySld(GetMapRequest request, StyledLayerDescriptor sld, List<?> requestedLayers, List<String> styleNames) throws ServiceException, IOException {
        StyledLayer[] styledLayers = sld.getStyledLayers();
        int slCount = styledLayers.length;
        if (slCount == 0) {
            throw new ServiceException("SLD document contains no layers");
        }
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        ArrayList<Style> styles = new ArrayList<Style>();
        MapLayerInfo currLayer = null;
        String styleName = null;
        for (int i = 0; i < requestedLayers.size(); ++i) {
            Object o;
            if (styleNames != null && !styleNames.isEmpty()) {
                styleName = styleNames.get(i);
            }
            if ((o = requestedLayers.get(i)) instanceof LayerInfo) {
                LayerInfo info1 = (LayerInfo)o;
                currLayer = new MapLayerInfo(info1);
                StyledLayer styledLayer = styledLayers[i];
                if (styledLayer instanceof NamedLayer) {
                    NamedLayer layer;
                    NamedLayer namedLayer = layer = (NamedLayer)styledLayer;
                    currLayer.setLayerFeatureConstraints(namedLayer.getLayerFeatureConstraints());
                }
                layers.add(currLayer);
                Style style = this.findStyleOf(request, currLayer, styleName, styledLayers);
                styles.add(style);
                continue;
            }
            if (o instanceof LayerGroupInfo) {
                LayerGroupInfo info = (LayerGroupInfo)o;
                List subLayers = info.layers();
                for (LayerInfo layer : subLayers) {
                    currLayer = new MapLayerInfo(layer, info.getMetadata());
                    layers.add(currLayer);
                    Style style = this.findStyleOf(request, currLayer, styleName, styledLayers);
                    styles.add(style);
                }
                continue;
            }
            throw new IllegalArgumentException("Unknown layer info type: " + String.valueOf(o));
        }
        request.setLayers(layers);
        request.setStyles(styles);
    }

    public static void addStyles(WMS wms, GetMapRequest request, MapLayerInfo currLayer, StyledLayer layer, List<MapLayerInfo> layers, List<Style> styles) throws ServiceException, IOException {
        if (currLayer == null) {
            return;
        }
        Style[] layerStyles = null;
        if (layer instanceof NamedLayer) {
            NamedLayer namedLayer = (NamedLayer)layer;
            layerStyles = namedLayer.getStyles();
        } else if (layer instanceof UserLayer) {
            UserLayer userLayer = (UserLayer)layer;
            layerStyles = userLayer.getUserStyles();
        }
        if (layerStyles == null || layerStyles.length == 0) {
            layers.add(currLayer);
            styles.add(currLayer.getDefaultStyle());
            return;
        }
        for (Style layerStyle : layerStyles) {
            if (layerStyle instanceof NamedStyle) {
                layers.add(currLayer);
                Style s = GetMapKvpRequestReader.findStyle(wms, request, layerStyle.getName());
                if (s == null) {
                    throw new ServiceException("couldn't find style named '" + layerStyle.getName() + "'");
                }
                styles.add(s);
                continue;
            }
            layers.add(currLayer);
            styles.add(layerStyle);
        }
    }

    private static Style findStyle(WMS wms, GetMapRequest request, String currStyleName) throws IOException {
        return wms.getStyleByName(currStyleName);
    }

    private Style findStyleOf(GetMapRequest request, MapLayerInfo layer, String styleName, StyledLayer[] styledLayers) throws ServiceException, IOException {
        NamedLayer namedLayer;
        Style[] styles;
        UserLayer userLayer;
        StyledLayer sl;
        Style style = null;
        String layerName = layer.getName();
        for (StyledLayer value : styledLayers) {
            int j;
            sl = value;
            if (!layerName.equals(sl.getName())) continue;
            if (sl instanceof UserLayer) {
                userLayer = (UserLayer)sl;
                styles = userLayer.getUserStyles();
                for (j = 0; style == null && styles != null && j < styles.length; ++j) {
                    if (styleName == null || styleName.equals("") && styles[j].isDefault()) {
                        style = styles[j];
                        continue;
                    }
                    if (styleName == null || !styleName.equals(styles[j].getName())) continue;
                    style = styles[j];
                }
                break;
            }
            if (sl instanceof NamedLayer) {
                namedLayer = (NamedLayer)sl;
                styles = namedLayer.getStyles();
                for (j = 0; style == null && styles != null && j < styles.length; ++j) {
                    if ((styleName == null || styleName.equals("")) && styles[j].isDefault()) {
                        style = styles[j];
                        continue;
                    }
                    if (styleName == null || !styleName.equals(styles[j].getName())) continue;
                    style = styles[j];
                }
                if (!(style instanceof NamedStyle)) break;
                style = GetMapKvpRequestReader.findStyle(this.wms, request, style.getName());
                break;
            }
            throw new RuntimeException("Unknown layer type: " + String.valueOf(sl));
        }
        if (style == null && this.laxStyleMatchAllowed) {
            for (StyledLayer styledLayer : styledLayers) {
                sl = styledLayer;
                if (!layerName.equals(sl.getName())) continue;
                if (sl instanceof UserLayer) {
                    userLayer = (UserLayer)sl;
                    styles = userLayer.getUserStyles();
                    if (null == styles || 0 >= styles.length) break;
                    style = styles[0];
                    break;
                }
                if (sl instanceof NamedLayer) {
                    namedLayer = (NamedLayer)sl;
                    styles = namedLayer.getStyles();
                    if (null != styles && 0 < styles.length) {
                        style = styles[0];
                    }
                    if (!(style instanceof NamedStyle)) break;
                    style = GetMapKvpRequestReader.findStyle(this.wms, request, style.getName());
                    break;
                }
                throw new RuntimeException("Unknown layer type: " + String.valueOf(sl));
            }
        }
        if (style == null) {
            if (styleName == null || "".equals(styleName)) {
                style = layer.getDefaultStyle();
                if (style == null) {
                    throw new ServiceException("Could not find a default style for " + layer.getName());
                }
            } else {
                style = this.wms.getStyleByName(styleName);
                if (style == null) {
                    String msg = "No such style: " + styleName;
                    throw new ServiceException(msg, "StyleNotDefined");
                }
            }
        }
        GetMapKvpRequestReader.checkStyle(style, layer);
        return style;
    }

    private static void checkStyle(Style style, MapLayerInfo mapLayerInfo) throws ServiceException {
        if (mapLayerInfo.getType() == MapLayerInfo.TYPE_RASTER) {
            return;
        }
        if (GetMapKvpRequestReader.hasTransformation(style)) {
            return;
        }
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        sae.visit(style);
        Set styleAttributes = sae.getAttributes();
        FeatureType type = null;
        if (mapLayerInfo.getType() == MapLayerInfo.TYPE_VECTOR || mapLayerInfo.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
            try {
                type = mapLayerInfo.getType() == MapLayerInfo.TYPE_VECTOR ? mapLayerInfo.getFeature().getFeatureType() : mapLayerInfo.getRemoteFeatureSource().getSchema();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error getting FeatureType, this should never happen!", ioe);
            }
        }
        for (PropertyName attName : styleAttributes) {
            if (attName.evaluate((Object)type) != null) continue;
            throw new ServiceException("The requested Style can not be used with this layer.  The style specifies an attribute named '" + String.valueOf(attName) + "', not found in the '" + mapLayerInfo.getName() + "' layer");
        }
    }

    private static boolean hasTransformation(Style style) {
        for (FeatureTypeStyle fs : style.featureTypeStyles()) {
            if (fs.getTransformation() == null) continue;
            return true;
        }
        return false;
    }

    protected List<Object> parseLayers(List<String> requestedLayerNames, URL remoteOwsUrl, String remoteOwsType) throws Exception {
        ArrayList<Object> layersOrGroups = new ArrayList<Object>();
        DataStore remoteWFS = null;
        ArrayList<String> remoteTypeNames = new ArrayList<String>();
        if ("WFS".equals(remoteOwsType) && remoteOwsUrl != null) {
            remoteWFS = GetMapKvpRequestReader.connectRemoteWFS(remoteOwsUrl);
            remoteTypeNames.addAll(Arrays.asList(remoteWFS.getTypeNames()));
            Collections.sort(remoteTypeNames);
        }
        for (String layerName : requestedLayerNames) {
            SimpleFeatureSource remoteSource;
            if (remoteTypeNames.contains(layerName) && (remoteSource = remoteWFS.getFeatureSource(layerName)) != null) {
                layersOrGroups.add(new MapLayerInfo(remoteSource));
                continue;
            }
            LayerInfo layerInfo = this.wms.getLayerByName(layerName);
            if (layerInfo != null) {
                layersOrGroups.add(layerInfo);
                continue;
            }
            LayerGroupInfo layerGroup = this.wms.getLayerGroupByName(layerName);
            if (layerGroup == null || LayerGroupInfo.Mode.CONTAINER.equals((Object)layerGroup.getMode())) {
                throw new ServiceException("Could not find layer " + layerName, "LayerNotDefined", "layers");
            }
            layersOrGroups.add(layerGroup);
        }
        if (layersOrGroups.isEmpty()) {
            throw new ServiceException("No LAYERS has been requested", ((Object)((Object)this)).getClass().getName());
        }
        return layersOrGroups;
    }

    private static DataStore connectRemoteWFS(URL remoteOwsUrl) throws ServiceException {
        try {
            URLCheckers.confirm((URL)remoteOwsUrl);
        }
        catch (URLCheckerException e) {
            String msg = "Invalid remote URL: " + String.valueOf(remoteOwsUrl);
            throw new ServiceException(msg, (Throwable)e, "InvalidParameterValue", "REMOTE_OWS_URL");
        }
        try {
            WFSDataStoreFactory factory = new WFSDataStoreFactory();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(WFSDataStoreFactory.URL.key, ResponseUtils.appendQueryString((String)remoteOwsUrl.toExternalForm(), (String)"REQUEST=GetCapabilities&SERVICE=WFS"));
            params.put(WFSDataStoreFactory.TRY_GZIP.key, Boolean.TRUE);
            return factory.createDataStore(params);
        }
        catch (Exception e) {
            throw new ServiceException("Could not connect to remote OWS", (Throwable)e, "RemoteOWSFailure");
        }
    }

    protected void parseStyles(List<String> styleNames, List<Object> requestedLayerInfos, List<Style> styles, List<String> groupStyles) throws Exception {
        for (int i = 0; i < styleNames.size(); ++i) {
            String styleName = styleNames.get(i);
            if (styleName == null || "".equals(styleName)) {
                styles.add(null);
                groupStyles.add(null);
                continue;
            }
            Object layer = requestedLayerInfos.get(i);
            if (this.isRemoteWMSLayer(layer)) {
                WMSLayerInfo remoteWMSLayer = (WMSLayerInfo)((LayerInfo)layer).getResource();
                Optional remoteStyle = remoteWMSLayer.findRemoteStyleByName(styleName);
                if (remoteStyle.isPresent()) {
                    styles.add((Style)remoteStyle.get());
                    groupStyles.add(null);
                    continue;
                }
                throw new ServiceException("No such remote style: " + styleName, "StyleNotDefined");
            }
            this.parseStyle(layer, styleName, groupStyles, styles);
        }
    }

    private void parseStyle(Object layer, String styleName, List<String> groupStyles, List<Style> styles) throws IOException {
        if (layer instanceof LayerGroupInfo) {
            LayerGroupInfo groupInfo = (LayerGroupInfo)layer;
            boolean isDefaultStyle = this.isDefaultLgStyle(styleName, groupInfo);
            if (!isDefaultStyle && this.isGroupStyleName(styleName, groupInfo)) {
                groupStyles.add(styleName);
            } else {
                groupStyles.add(null);
            }
            styles.add(null);
        } else {
            groupStyles.add(null);
            Style style = this.wms.getStyleByName(styleName);
            if (style != null) {
                styles.add(style);
            } else {
                String msg = "No such style: " + styleName;
                throw new ServiceException(msg, "StyleNotDefined");
            }
        }
    }

    public boolean isLaxStyleMatchAllowed() {
        return this.laxStyleMatchAllowed;
    }

    public void setLaxStyleMatchAllowed(boolean laxStyleMatchAllowed) {
        this.laxStyleMatchAllowed = laxStyleMatchAllowed;
    }

    public void destroy() throws Exception {
        this.closeHttpClient();
    }

    private boolean isRemoteWMSLayer(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof LayerInfo)) {
            return false;
        }
        return ((LayerInfo)o).getResource() instanceof WMSLayerInfo;
    }

    private Geometry getClipGeometry(GetMapRequest getMapRequest) {
        if (getMapRequest.getRawKvp() == null || getMapRequest.getCrs() == null) {
            return null;
        }
        String wktString = getMapRequest.getRawKvp().get("clip");
        if (wktString == null) {
            return null;
        }
        try {
            Geometry geom = ClipWMSGetMapCallBack.readGeometry(wktString, getMapRequest.getCrs());
            if (LOGGER.isLoggable(Level.FINE) && geom != null) {
                LOGGER.fine("parsed Clip param to geometry " + geom.toText());
            }
            return geom;
        }
        catch (Exception e) {
            LOGGER.severe("Ignoring clip param,Error parsing wkt in clip parameter : " + wktString);
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private boolean isDefaultLgStyle(String styleName, LayerGroupInfo groupInfo) {
        return CapabilityUtil.encodeGroupDefaultStyle(this.wms, groupInfo) && styleName != null && styleName.equals(CapabilityUtil.getGroupDefaultStyleName(groupInfo));
    }

    private boolean isGroupStyleName(String styleName, LayerGroupInfo groupInfo) {
        return styleName != null && !"".equals(styleName) && LayerGroupHelper.isSingleOrOpaque((LayerGroupInfo)groupInfo);
    }

    static {
        interpolationMethods.put("NEAREST NEIGHBOR", 0);
        interpolationMethods.put("BILINEAR", 1);
        interpolationMethods.put("BICUBIC", 2);
    }
}

