/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.RenderingHints;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.RenderedImageMap;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ImageUtilities;

public class JpegOrPngChooser {
    static final String JPEG_PNG_CHOOSER = "jpegOrPngChooser";
    boolean jpegPreferred;

    public static JpegOrPngChooser getFromMap(RenderedImageMap map) {
        WMSMapContent ctx = map.getMapContext();
        return JpegOrPngChooser.getFromMapContent(map.getImage(), ctx);
    }

    public static JpegOrPngChooser getFromMapContent(RenderedImage image, WMSMapContent ctx) {
        JpegOrPngChooser chooser = (JpegOrPngChooser)ctx.getMetadata().get(JPEG_PNG_CHOOSER);
        if (chooser == null) {
            chooser = new JpegOrPngChooser(image);
            ctx.getMetadata().put(JPEG_PNG_CHOOSER, chooser);
        }
        return chooser;
    }

    public JpegOrPngChooser(RenderedImage image) {
        this.jpegPreferred = this.isBestFormatJpeg(image);
    }

    public String getMime() {
        String mime = this.jpegPreferred ? "image/jpeg" : "image/png";
        return mime;
    }

    public String getExtension() {
        String extension = this.jpegPreferred ? "jpeg" : "png";
        return extension;
    }

    private boolean isBestFormatJpeg(RenderedImage renderedImage) {
        int numBands = renderedImage.getSampleModel().getNumBands();
        if (numBands == 4 || numBands == 2) {
            RenderingHints renderingHints = ImageUtilities.getRenderingHints((RenderedImage)renderedImage);
            ImageWorker iw = new ImageWorker(renderedImage);
            iw.setRenderingHints(renderingHints);
            double[] mins = iw.getMinimums();
            return mins[mins.length - 1] == 255.0;
        }
        if (renderedImage.getColorModel() instanceof IndexColorModel) {
            return false;
        }
        return numBands == 3 || numBands == 1;
    }

    public boolean isJpegPreferred() {
        return this.jpegPreferred;
    }
}

