/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.eclipse.imagen.PlanarImage;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.RasterCleaner;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.map.QuickTileCache;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.filter.function.EnvFunction;
import org.geotools.util.logging.Logging;

public final class MetatileMapOutputFormat
implements GetMapOutputFormat {
    private static final Logger LOGGER = Logging.getLogger(MetatileMapOutputFormat.class);
    public static final double EPS = 1.0E-6;
    private static boolean DEBUG = Boolean.valueOf(GeoServerExtensions.getProperty((String)"org.geoserver.wms.map.MetatileMapOutputFormat.debug"));
    private static String DEBUG_DIR;
    private QuickTileCache tileCache;
    private GetMapRequest request;
    private RenderedImageMapOutputFormat delegate;

    static void writeRenderedImage(RenderedImage raster, String fileName) {
        if (DEBUG_DIR == null) {
            throw new NullPointerException("Unable to write the provided coverage in the debug directory");
        }
        if (!DEBUG) {
            throw new IllegalStateException("Unable to write the provided coverage since we are not in debug mode");
        }
        try {
            ImageIO.write(raster, "tiff", new File(DEBUG_DIR, fileName + ".tiff"));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public MetatileMapOutputFormat(GetMapRequest request, RenderedImageMapOutputFormat delegate) {
        if (this.tileCache == null) {
            this.tileCache = (QuickTileCache)GeoServerExtensions.bean((String)"metaTileCache");
        }
        this.request = request;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebMap produceMap(WMSMapContent mapContent) throws ServiceException, IOException {
        QuickTileCache.MetaTileKey key;
        QuickTileCache.MetaTileKey metaTileKey = key = this.tileCache.getMetaTileKey(this.request);
        synchronized (metaTileKey) {
            RenderedImage tile = this.tileCache.getTile(key, this.request);
            List<GridCoverage2D> renderedCoverages = null;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Looked for meta tile " + key.metaTileCoords.x + ", " + key.metaTileCoords.y + "in cache: " + (tile != null ? "hit!" : "miss"));
            }
            if (tile == null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Building meta tile " + key.metaTileCoords.x + ", " + key.metaTileCoords.y + " of size w=" + key.getTileSize() * key.getMetaFactor() + ", h=" + key.getTileSize() * key.getMetaFactor() + " with metatilign factor " + key.getMetaFactor());
                }
                mapContent.getViewport().setBounds(key.getMetaTileEnvelope());
                mapContent.setMapWidth(key.getTileSize() * key.getMetaFactor());
                mapContent.setMapHeight(key.getTileSize() * key.getMetaFactor());
                mapContent.setTileSize(key.getTileSize());
                EnvFunction.setLocalValue((String)"wms_bbox", (Object)mapContent.getViewport().getBounds());
                EnvFunction.setLocalValue((String)"wms_width", (Object)mapContent.getMapWidth());
                EnvFunction.setLocalValue((String)"wms_height", (Object)mapContent.getMapHeight());
                RenderedImageMap metaTileMap = this.delegate.produceMap(mapContent);
                RenderedImage metaTile = metaTileMap.getImage();
                RenderedImage[] tiles = MetatileMapOutputFormat.split(key, metaTile);
                this.tileCache.storeTiles(key, tiles);
                tile = this.tileCache.getTile(key, this.request, tiles);
                renderedCoverages = metaTileMap.getRenderedCoverages();
            }
            RenderedImageMap tileMap = new RenderedImageMap(mapContent, tile, this.getMimeType());
            tileMap.setRenderedCoverages(renderedCoverages);
            return tileMap;
        }
    }

    @Override
    public Set<String> getOutputFormatNames() {
        return this.delegate.getOutputFormatNames();
    }

    @Override
    public String getMimeType() {
        return this.delegate.getMimeType();
    }

    public static boolean isRequestTiled(GetMapRequest request, GetMapOutputFormat delegate) {
        boolean tiled = request.isTiled();
        Point2D tilesOrigin = request.getTilesOrigin();
        int width = request.getWidth();
        int height = request.getHeight();
        return tiled && tilesOrigin != null && width == 256 && height == 256 && delegate instanceof RenderedImageMapOutputFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RenderedImage[] split(QuickTileCache.MetaTileKey key, RenderedImage metaTile) {
        int metaFactor = key.getMetaFactor();
        RenderedImage[] tiles = new RenderedImage[key.getMetaFactor() * key.getMetaFactor()];
        int tileSize = key.getTileSize();
        int type = 0;
        if (metaTile instanceof PlanarImage) {
            type = 1;
        } else if (metaTile instanceof BufferedImage) {
            type = 2;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Metatile type " + type);
        }
        try {
            if (DEBUG) {
                MetatileMapOutputFormat.writeRenderedImage(metaTile, "metaTile");
            }
            for (int i = 0; i < metaFactor; ++i) {
                for (int j = 0; j < metaFactor; ++j) {
                    BufferedImage tile;
                    int x = j * tileSize;
                    int y = tileSize * (metaFactor - 1) - i * tileSize;
                    switch (type) {
                        case 0: {
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("Metatile split on RenderedImage");
                            }
                            metaTile = PlanarImage.wrapRenderedImage((RenderedImage)metaTile);
                        }
                        case 1: {
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("Metatile split on PlanarImage");
                            }
                            PlanarImage pImage = (PlanarImage)metaTile;
                            WritableRaster wTile = WritableRaster.createWritableRaster(pImage.getSampleModel().createCompatibleSampleModel(tileSize, tileSize), new Point(x, y));
                            Rectangle sourceArea = new Rectangle(x, y, tileSize, tileSize);
                            sourceArea = sourceArea.intersection(pImage.getBounds());
                            pImage.copyData(wTile);
                            if (wTile.getMinX() != 0 || wTile.getMinY() != 0) {
                                tile = new BufferedImage(pImage.getColorModel(), wTile.createWritableTranslatedChild(0, 0), pImage.getColorModel().isAlphaPremultiplied(), null);
                                break;
                            }
                            tile = new BufferedImage(pImage.getColorModel(), wTile, pImage.getColorModel().isAlphaPremultiplied(), null);
                            break;
                        }
                        case 2: {
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("Metatile split on BufferedImage");
                            }
                            BufferedImage image = (BufferedImage)metaTile;
                            tile = image.getSubimage(x, y, tileSize, tileSize);
                            break;
                        }
                        default: {
                            throw new IllegalStateException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "metaTile class", metaTile.getClass().toString()));
                        }
                    }
                    tiles[i * key.getMetaFactor() + j] = tile;
                    if (!DEBUG) continue;
                    MetatileMapOutputFormat.writeRenderedImage(tile, "tile" + i + "-" + j);
                }
            }
        }
        finally {
            RasterCleaner.addImage(metaTile);
        }
        return tiles;
    }

    @Override
    public MapProducerCapabilities getCapabilities(String format) {
        throw new RuntimeException("The meta-tile output format should never be invoked directly!");
    }

    static {
        if (DEBUG) {
            File tempDir = new File(GeoServerExtensions.getProperty((String)"user.home"), ".geoserver");
            if (!tempDir.exists()) {
                if (!tempDir.mkdir()) {
                    LOGGER.severe("Unable to create debug dir, exiting application!!!");
                }
                DEBUG = false;
                DEBUG_DIR = null;
            } else {
                DEBUG_DIR = tempDir.getAbsolutePath();
                LOGGER.fine("MetatileMapOutputFormat debug dir " + DEBUG_DIR);
            }
        }
    }
}

