/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.parameter.Parameter;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeConstraint;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.Halo;
import org.geotools.api.style.ImageOutline;
import org.geotools.api.style.LinePlacement;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.OverlapBehavior;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.SelectedChannelType;
import org.geotools.api.style.ShadedRelief;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.api.style.UserLayer;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.CoverageReadingTransformation;
import org.geotools.feature.FeatureTypes;

public class RasterSymbolizerVisitor
implements StyleVisitor {
    public static final String TRANSFORM_FEATURE_INFO = "transformFeatureInfo";
    double scaleDenominator;
    FeatureType featureType;
    List<RasterSymbolizer> symbolizers = new ArrayList<RasterSymbolizer>();
    boolean otherSymbolizers = false;
    Expression rasterTransformation = null;
    CoverageReadingTransformation coverageReadingTransformation = null;
    List<Expression> otherRenderingTransformations = new ArrayList<Expression>();
    Boolean transformFeatureInfo = null;

    public RasterSymbolizerVisitor(double scaleDenominator, FeatureType featureType) {
        this(scaleDenominator, featureType, null);
    }

    public RasterSymbolizerVisitor(double scaleDenominator, FeatureType featureType, Boolean transformFeatureInfo) {
        this.scaleDenominator = scaleDenominator;
        this.featureType = featureType;
        this.transformFeatureInfo = transformFeatureInfo;
    }

    public void reset() {
        this.symbolizers.clear();
        this.otherSymbolizers = false;
        this.rasterTransformation = null;
        this.otherRenderingTransformations = new ArrayList<Expression>();
    }

    public List<RasterSymbolizer> getRasterSymbolizers() {
        if (this.otherSymbolizers || !this.otherRenderingTransformations.isEmpty()) {
            return Collections.emptyList();
        }
        return this.symbolizers;
    }

    public Expression getRasterRenderingTransformation() {
        return this.rasterTransformation;
    }

    public CoverageReadingTransformation getCoverageReadingTransformation() {
        return this.coverageReadingTransformation;
    }

    public List<Expression> getOtherRenderingTransformations() {
        return this.otherRenderingTransformations;
    }

    public void visit(StyledLayerDescriptor sld) {
        for (StyledLayer sl : sld.getStyledLayers()) {
            if (sl instanceof UserLayer) {
                UserLayer layer1 = (UserLayer)sl;
                layer1.accept((StyleVisitor)this);
                continue;
            }
            if (!(sl instanceof NamedLayer)) continue;
            NamedLayer layer = (NamedLayer)sl;
            layer.accept((StyleVisitor)this);
        }
    }

    public void visit(NamedLayer layer) {
        for (Style s : layer.getStyles()) {
            s.accept((StyleVisitor)this);
        }
    }

    public void visit(UserLayer layer) {
        for (Style s : layer.getUserStyles()) {
            s.accept((StyleVisitor)this);
        }
    }

    public void visit(FeatureTypeConstraint ftc) {
    }

    public void visit(Style style) {
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            fts.accept((StyleVisitor)this);
        }
    }

    public void visit(Rule rule) {
        if (rule.getMinScaleDenominator() < this.scaleDenominator && rule.getMaxScaleDenominator() > this.scaleDenominator) {
            for (Symbolizer s : rule.symbolizers()) {
                s.accept((StyleVisitor)this);
            }
        }
    }

    public void visit(FeatureTypeStyle fts) {
        if ((this.featureType == null || this.featureType.getName().getLocalPart() != null && (fts.featureTypeNames().isEmpty() || fts.featureTypeNames().stream().anyMatch(tn -> FeatureTypes.matches((FeatureType)this.featureType, (Name)tn)))) && this.activeRules(fts)) {
            Expression tx;
            Expression expression = tx = this.isTransformFeatureInfo(fts) ? fts.getTransformation() : null;
            if (tx != null) {
                boolean rasterTransformation = false;
                if (tx instanceof CoverageReadingTransformation) {
                    CoverageReadingTransformation transformation;
                    this.coverageReadingTransformation = transformation = (CoverageReadingTransformation)tx;
                } else if (tx instanceof Function) {
                    rasterTransformation = this.isRasterTransformation(tx, rasterTransformation);
                }
                if (!rasterTransformation) {
                    this.otherRenderingTransformations.add(tx);
                }
            }
            for (Rule r : fts.rules()) {
                r.accept((StyleVisitor)this);
            }
        }
    }

    private boolean isTransformFeatureInfo(FeatureTypeStyle fts) {
        if (this.transformFeatureInfo == null) {
            return true;
        }
        String option = (String)fts.getOptions().get(TRANSFORM_FEATURE_INFO);
        return option != null ? Boolean.parseBoolean(option) : this.transformFeatureInfo;
    }

    private boolean activeRules(FeatureTypeStyle fts) {
        for (Rule rule : fts.rules()) {
            if (!(rule.getMinScaleDenominator() < this.scaleDenominator) || !(rule.getMaxScaleDenominator() > this.scaleDenominator)) continue;
            return true;
        }
        return false;
    }

    private boolean isRasterTransformation(Expression tx, boolean rasterTransformation) {
        Parameter result;
        Function f = (Function)tx;
        FunctionName name = f.getFunctionName();
        if (name != null && (result = name.getReturn()) != null && GridCoverage2D.class.isAssignableFrom(result.getType())) {
            rasterTransformation = true;
            this.rasterTransformation = tx;
        }
        return rasterTransformation;
    }

    public void visit(Fill fill) {
    }

    public void visit(Stroke stroke) {
    }

    public void visit(Symbolizer sym) {
        if (sym instanceof RasterSymbolizer) {
            RasterSymbolizer symbolizer = (RasterSymbolizer)sym;
            this.visit(symbolizer);
        } else {
            this.otherSymbolizers = true;
        }
    }

    public void visit(PointSymbolizer ps) {
        this.otherSymbolizers = true;
    }

    public void visit(LineSymbolizer line) {
        this.otherSymbolizers = true;
    }

    public void visit(PolygonSymbolizer poly) {
        this.otherSymbolizers = true;
    }

    public void visit(TextSymbolizer text) {
        this.otherSymbolizers = true;
    }

    public void visit(RasterSymbolizer raster) {
        this.symbolizers.add(raster);
    }

    public void visit(Graphic gr) {
    }

    public void visit(Mark mark) {
    }

    public void visit(ExternalGraphic exgr) {
    }

    public void visit(PointPlacement pp) {
    }

    public void visit(AnchorPoint ap) {
    }

    public void visit(Displacement dis) {
    }

    public void visit(LinePlacement lp) {
    }

    public void visit(Halo halo) {
    }

    public void visit(ColorMap colorMap) {
    }

    public void visit(ColorMapEntry colorMapEntry) {
    }

    public void visit(ContrastEnhancement contrastEnhancement) {
    }

    public void visit(ImageOutline outline) {
    }

    public void visit(ChannelSelection cs) {
    }

    public void visit(OverlapBehavior ob) {
    }

    public void visit(SelectedChannelType sct) {
    }

    public void visit(ShadedRelief sr) {
    }
}

